/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.locale;

import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.locale.LocaleEditorDialog;
import it.businesslogic.ireport.gui.locale.NewLocaleFileDialog;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class LocaleResourceFilesDialog
extends JDialog {
    private int dialogResult = 2;
    private JReportFrame jReportFrame = null;
    private JButton jButtonClose;
    private JButton jButtonCreateNewLocale;
    private JButton jButtonDeleteFile;
    private JButton jButtonModifyFile;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanelData;
    private JScrollPane jScrollPane3;
    private JTable jTable1;

    public LocaleResourceFilesDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.initFrame();
    }

    public void initFrame() {
        DefaultListModel dlm = new DefaultListModel();
        this.setSize(500, 400);
        Misc.centerFrame(this);
        DefaultListSelectionModel dlsm = (DefaultListSelectionModel)this.jTable1.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                LocaleResourceFilesDialog.this.jTable1ListSelectionValueChanged(e);
            }
        });
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LocaleResourceFilesDialog.this.jButtonCloseActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonClose);
    }

    public void jTable1ListSelectionValueChanged(ListSelectionEvent e) {
        if (this.jTable1.getSelectedRowCount() > 0) {
            this.jButtonModifyFile.setEnabled(true);
            this.jButtonDeleteFile.setEnabled(true);
        } else {
            this.jButtonModifyFile.setEnabled(false);
            this.jButtonDeleteFile.setEnabled(false);
        }
    }

    public LocaleResourceFilesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.initFrame();
    }

    public void updateFileList() {
        DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
        dtm.setRowCount(0);
        if (this.getJReportFrame() == null) {
            this.jTable1.updateUI();
            return;
        }
        Report report = this.getJReportFrame().getReport();
        if (report.getFilename() == null || report.getFilename().trim().equals("")) {
            return;
        }
        if (report.getResourceBundleBaseName() == null || report.getResourceBundleBaseName().trim().equals("")) {
            return;
        }
        String basename = report.getResourceBundleBaseName();
        File f = new File(report.getFilename());
        File dir = f.getParentFile();
        String[] files = dir.list();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].startsWith(basename) || !files[i].endsWith(".properties")) continue;
            dtm.addRow(new Object[]{LocaleResourceFilesDialog.getLocaleName(basename, files[i]), files[i]});
        }
        this.jTable1.updateUI();
    }

    public JReportFrame getJReportFrame() {
        return this.jReportFrame;
    }

    public void setJReportFrame(JReportFrame jReportFrame) {
        this.jReportFrame = jReportFrame;
        this.updateFileList();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    private void initComponents() {
        this.jPanelData = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel2 = new JPanel();
        this.jButtonCreateNewLocale = new JButton();
        this.jButtonModifyFile = new JButton();
        this.jButtonDeleteFile = new JButton();
        this.jPanel3 = new JPanel();
        this.jButtonClose = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Report Imports");
        this.jPanelData.setLayout(new GridBagLayout());
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"Locale", "File name"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                LocaleResourceFilesDialog.this.jTable1MouseClicked(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.jTable1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelData.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setMinimumSize(new Dimension(140, 151));
        this.jPanel2.setPreferredSize(new Dimension(180, 100));
        this.jButtonCreateNewLocale.setText("Create new locale");
        this.jButtonCreateNewLocale.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocaleResourceFilesDialog.this.jButtonCreateNewLocaleActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jButtonCreateNewLocale, gridBagConstraints);
        this.jButtonModifyFile.setText(" Modify file");
        this.jButtonModifyFile.setActionCommand("Modify locale");
        this.jButtonModifyFile.setEnabled(false);
        this.jButtonModifyFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocaleResourceFilesDialog.this.jButtonModifyFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel2.add((Component)this.jButtonModifyFile, gridBagConstraints);
        this.jButtonDeleteFile.setText("Delete file");
        this.jButtonDeleteFile.setEnabled(false);
        this.jButtonDeleteFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocaleResourceFilesDialog.this.jButtonDeleteFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel2.add((Component)this.jButtonDeleteFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LocaleResourceFilesDialog.this.jButtonCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jButtonClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanelData.add((Component)this.jPanel2, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanelData, "Center");
        this.pack();
    }

    private void jTable1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1) {
                this.jButtonModifyFileActionPerformed(null);
            }
        }
    }

    private void jButtonDeleteFileActionPerformed(ActionEvent evt) {
        if (this.jTable1.getSelectedRow() >= 0) {
            Report report = this.getJReportFrame().getReport();
            File f = new File(report.getFilename());
            File dir = f.getParentFile();
            File localeFile = new File(dir, "" + this.jTable1.getValueAt(this.jTable1.getSelectedRow(), 1));
            try {
                localeFile.delete();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.updateFileList();
        }
    }

    private void jButtonModifyFileActionPerformed(ActionEvent evt) {
        if (this.jTable1.getSelectedRow() >= 0) {
            Report report = this.getJReportFrame().getReport();
            File f = new File(report.getFilename());
            File dir = f.getParentFile();
            File localeFile = new File(dir, "" + this.jTable1.getValueAt(this.jTable1.getSelectedRow(), 1));
            LocaleEditorDialog led = new LocaleEditorDialog((Frame)this.getJReportFrame().getMainFrame(), false);
            led.setFile(localeFile);
            led.setVisible(true);
            try {
                led.setTitle(localeFile.getName());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    private void jButtonCreateNewLocaleActionPerformed(ActionEvent evt) {
        String suffix = "";
        Report report = this.getJReportFrame().getReport();
        if (report.getFilename() == null || report.getFilename().trim().equals("")) {
            JOptionPane.showMessageDialog(this, "To create a new locale file please save your report first.");
            return;
        }
        File f = new File(report.getFilename());
        NewLocaleFileDialog fd = new NewLocaleFileDialog((Dialog)this, true);
        fd.setVisible(true);
        File localeFile = null;
        if (fd.getDialogResult() == 0) {
            try {
                suffix = fd.getText();
                if (report.getResourceBundleBaseName() == null || report.getResourceBundleBaseName().trim().equals("")) {
                    String filename = f.getName();
                    int index = filename.lastIndexOf(".");
                    if (index >= 0) {
                        filename = filename.substring(0, index);
                    }
                    report.setResourceBundleBaseName(filename);
                }
                File dir = f.getParentFile();
                localeFile = new File(dir, report.getResourceBundleBaseName() + ".properties");
                String str = "# Locale " + suffix + " for report " + f.getName() + "\n";
                try {
                    FileInputStream fis = new FileInputStream(localeFile);
                    byte[] buffer = new byte[1024];
                    int read = 0;
                    while ((read = fis.read(buffer)) > 0) {
                        str = str + new String(buffer, 0, read);
                    }
                    fis.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                localeFile = new File(dir, report.getResourceBundleBaseName() + suffix + ".properties");
                FileOutputStream fos = new FileOutputStream(localeFile);
                fos.write(str.getBytes());
                fos.close();
                this.updateFileList();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Error creating new locale " + localeFile.getName() + ": " + ex.getMessage());
            }
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.setDialogResult(0);
        this.setVisible(false);
    }

    public static String getLocaleName(String baseName, String propertiesName) {
        String language = "";
        String country = "";
        String variant = "";
        Locale locale = Locale.getDefault();
        if (!propertiesName.endsWith(".properties")) {
            return "";
        }
        if (!propertiesName.startsWith(baseName)) {
            return "";
        }
        if ((propertiesName = propertiesName.substring(baseName.length(), propertiesName.length() - ".properties".length())).length() == 0) {
            return "Default";
        }
        if (propertiesName.startsWith("_")) {
            propertiesName = propertiesName.substring(1);
        }
        if (propertiesName.indexOf("_") > 0) {
            language = propertiesName.substring(0, propertiesName.indexOf("_"));
            if ((propertiesName = propertiesName.substring(propertiesName.indexOf("_") + 1)).indexOf("_") > 0) {
                country = propertiesName.substring(0, propertiesName.indexOf("_"));
                if ((propertiesName = propertiesName.substring(propertiesName.indexOf("_") + 1)).indexOf("_") > 0) {
                    variant = propertiesName.substring(0, propertiesName.indexOf("_"));
                    propertiesName = propertiesName.substring(propertiesName.indexOf("_") + 1);
                } else {
                    variant = propertiesName;
                }
            } else {
                country = propertiesName;
            }
        } else {
            language = propertiesName;
        }
        locale = new Locale(language, country, variant);
        return locale.getDisplayName();
    }
}

