/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.Topic;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.support.JmsUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.ClassUtils;

public class DefaultMessageListenerContainer
extends AbstractMessageListenerContainer {
    public static final String DEFAULT_THREAD_NAME_PREFIX = ClassUtils.getShortName(class$org$springframework$jms$listener$DefaultMessageListenerContainer == null ? (class$org$springframework$jms$listener$DefaultMessageListenerContainer = DefaultMessageListenerContainer.class$("org.springframework.jms.listener.DefaultMessageListenerContainer")) : class$org$springframework$jms$listener$DefaultMessageListenerContainer) + "-";
    public static final long DEFAULT_RECEIVE_TIMEOUT = 1000L;
    private final Object monitor = new Object();
    private boolean pubSubNoLocal = false;
    private int concurrentConsumers = 1;
    private TaskExecutor taskExecutor = new SimpleAsyncTaskExecutor(DEFAULT_THREAD_NAME_PREFIX);
    private TransactionTemplate transactionTemplate = new TransactionTemplate();
    private long receiveTimeout = 1000L;
    private int listenersRunning = 0;
    static /* synthetic */ Class class$org$springframework$jms$listener$DefaultMessageListenerContainer;

    public void setPubSubNoLocal(boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
    }

    protected boolean isPubSubNoLocal() {
        return this.pubSubNoLocal;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionTemplate.setTransactionManager(transactionManager);
    }

    public void setTransactionTimeout(int timeout) {
        this.transactionTemplate.setTimeout(timeout);
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    protected void registerListener() throws JMSException {
        AsyncMessageListenerInvoker invoker = new AsyncMessageListenerInvoker();
        for (int i = 0; i < this.concurrentConsumers; ++i) {
            this.taskExecutor.execute(invoker);
        }
    }

    protected MessageConsumer createListenerConsumer(Session session) throws JMSException {
        Destination destination = this.getDestination();
        if (destination == null) {
            destination = this.resolveDestinationName(session, this.getDestinationName());
        }
        return this.createConsumer(session, destination);
    }

    protected void executeListener(final Session session, final MessageConsumer consumer) {
        if (this.transactionTemplate.getTransactionManager() != null) {
            this.transactionTemplate.execute(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    try {
                        DefaultMessageListenerContainer.this.doExecuteListener(session, consumer);
                    }
                    catch (Throwable ex) {
                        status.setRollbackOnly();
                        DefaultMessageListenerContainer.this.logger.error((Object)"Execution of JMS message listener failed - rolling back transaction", ex);
                    }
                }
            });
        } else {
            try {
                this.doExecuteListener(session, consumer);
            }
            catch (JMSException ex) {
                this.logger.error((Object)"Execution of JMS message listener failed", (Throwable)ex);
            }
        }
    }

    protected void doExecuteListener(Session session, MessageConsumer consumer) throws JMSException {
        Message message;
        Message message2 = message = this.receiveTimeout < 0L ? consumer.receive() : consumer.receive(this.receiveTimeout);
        if (message != null) {
            this.doExecuteListener(session, message);
        }
    }

    protected void destroyListener() throws JMSException {
        this.logger.debug((Object)"Shutting down JMS message listener invokers");
        if (this.receiveTimeout > 0L) {
            while (this.listenersRunning > 0) {
                try {
                    Thread.sleep(this.receiveTimeout);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected MessageConsumer createConsumer(Session session, Destination destination) throws JMSException {
        if (destination instanceof Topic) {
            return session.createConsumer(destination, this.getMessageSelector(), this.isPubSubNoLocal());
        }
        return session.createConsumer(destination, this.getMessageSelector());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class AsyncMessageListenerInvoker
    implements Runnable {
        private AsyncMessageListenerInvoker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = DefaultMessageListenerContainer.this.monitor;
            synchronized (object) {
                DefaultMessageListenerContainer.this.listenersRunning++;
            }
            Session session = null;
            MessageConsumer consumer = null;
            try {
                session = DefaultMessageListenerContainer.this.createSession(DefaultMessageListenerContainer.this.getConnection());
                consumer = DefaultMessageListenerContainer.this.createListenerConsumer(session);
                while (DefaultMessageListenerContainer.this.isActive()) {
                    DefaultMessageListenerContainer.this.executeListener(session, consumer);
                }
            }
            catch (JMSException ex) {
                try {
                    DefaultMessageListenerContainer.this.logger.error((Object)"Setup of JMS message listener invoker failed", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    JmsUtils.closeMessageConsumer(consumer);
                    JmsUtils.closeSession(session);
                    Object object2 = DefaultMessageListenerContainer.this.monitor;
                    synchronized (object2) {
                        DefaultMessageListenerContainer.this.listenersRunning--;
                    }
                    throw throwable;
                }
                JmsUtils.closeMessageConsumer(consumer);
                JmsUtils.closeSession(session);
                Object object3 = DefaultMessageListenerContainer.this.monitor;
                synchronized (object3) {
                    DefaultMessageListenerContainer.this.listenersRunning--;
                }
            }
            JmsUtils.closeMessageConsumer(consumer);
            JmsUtils.closeSession(session);
            Object object4 = DefaultMessageListenerContainer.this.monitor;
            synchronized (object4) {
                DefaultMessageListenerContainer.this.listenersRunning--;
            }
        }
    }
}

