/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;

public class SqlContextConstraint
implements MemberChildrenConstraint,
TupleConstraint {
    List cacheKey;
    private Evaluator evaluator;
    private boolean strict;

    SqlContextConstraint(RolapEvaluator evaluator, boolean strict) {
        this.evaluator = evaluator;
        this.strict = strict;
        this.cacheKey = new ArrayList();
        this.cacheKey.add(this.getClass());
        this.cacheKey.add(strict);
        this.cacheKey.addAll(Arrays.asList(evaluator.getMembers()));
    }

    public void addMemberConstraint(SqlQuery sqlQuery, RolapMember parent) {
        if (parent.isCalculated()) {
            throw Util.newInternal("cannot restrict SQL to calculated member");
        }
        Evaluator e = this.evaluator.push(parent);
        SqlConstraintUtils.addContextConstraint(sqlQuery, e, this.strict);
    }

    public void addMemberConstraint(SqlQuery sqlQuery, List parents) {
        SqlConstraintUtils.addContextConstraint(sqlQuery, this.evaluator, this.strict);
        SqlConstraintUtils.addMemberConstraint(sqlQuery, parents, true);
    }

    public void addConstraint(SqlQuery sqlQuery) {
        SqlConstraintUtils.addContextConstraint(sqlQuery, this.evaluator, this.strict);
    }

    protected boolean isJoinRequired() {
        Member[] members = this.evaluator.getMembers();
        for (int i = 1; i < members.length; ++i) {
            if (members[i].isAll()) continue;
            return true;
        }
        return false;
    }

    public void addLevelConstraint(SqlQuery sqlQuery, RolapLevel level) {
        if (!this.isJoinRequired()) {
            return;
        }
        RolapCube cube = (RolapCube)this.evaluator.getCube();
        SqlConstraintUtils.joinLevelTableToFactTable(sqlQuery, cube, level);
    }

    public MemberChildrenConstraint getMemberChildrenConstraint(RolapMember parent) {
        return this;
    }

    public Object getCacheKey() {
        return this.cacheKey;
    }
}

