/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.ArrayList;
import mondrian.olap.CubeAccess;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.Hierarchy;
import mondrian.olap.OlapElement;
import mondrian.olap.OlapElementBase;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.Visitor;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;

public abstract class DimensionBase
extends OlapElementBase
implements Dimension {
    protected final String name;
    protected final String uniqueName;
    protected final String description;
    protected final int globalOrdinal;
    protected Hierarchy[] hierarchies;
    protected DimensionType dimensionType;

    protected DimensionBase(String name, String uniqueName, String description, int globalOrdinal, DimensionType dimensionType) {
        this.name = name;
        this.uniqueName = Util.makeFqName(name);
        this.description = null;
        this.globalOrdinal = globalOrdinal;
        this.dimensionType = dimensionType;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Hierarchy[] getHierarchies() {
        return this.hierarchies;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchies[0];
    }

    public Dimension getDimension() {
        return this;
    }

    public int getCategory() {
        return 2;
    }

    public Type getTypeX() {
        return new mondrian.olap.type.DimensionType(this);
    }

    public DimensionType getDimensionType() {
        return this.dimensionType;
    }

    public String getQualifiedName() {
        return MondrianResource.instance().MdxDimensionName.str(this.getUniqueName());
    }

    public boolean isMeasures() {
        return this.getUniqueName().equals("[Measures]");
    }

    public boolean usesDimension(Dimension dimension) {
        return dimension == this;
    }

    public OlapElement lookupChild(SchemaReader schemaReader, String s) {
        OlapElement oeLevel;
        OlapElement oe = this.lookupHierarchy(s);
        if ((oe == null || oe.getName().equalsIgnoreCase(this.getName())) && (oeLevel = this.getHierarchy().lookupChild(schemaReader, s)) != null) {
            oe = oeLevel;
        }
        if (this.getLogger().isDebugEnabled()) {
            StringBuffer buf = new StringBuffer(64);
            buf.append("DimensionBase.lookupChild: ");
            buf.append("name=");
            buf.append(this.getName());
            buf.append(", childname=");
            buf.append(s);
            if (oe == null) {
                buf.append(" returning null");
            } else {
                buf.append(" returning elementname=" + oe.getName());
            }
            this.getLogger().debug((Object)buf.toString());
        }
        return oe;
    }

    private Hierarchy lookupHierarchy(String s) {
        for (int i = 0; i < this.hierarchies.length; ++i) {
            if (!this.hierarchies[i].getName().equalsIgnoreCase(s)) continue;
            return this.hierarchies[i];
        }
        return null;
    }

    public Object[] getChildren() {
        return this.getHierarchies();
    }

    protected Object[] getAllowedChildren(CubeAccess cubeAccess) {
        ArrayList<Hierarchy> hierarchyList = new ArrayList<Hierarchy>();
        Hierarchy[] mdxHierarchies = this.getHierarchies();
        for (int i = 0; i < mdxHierarchies.length; ++i) {
            if (!cubeAccess.isHierarchyAllowed(mdxHierarchies[i])) continue;
            hierarchyList.add(mdxHierarchies[i]);
        }
        return hierarchyList.toArray(new Hierarchy[hierarchyList.size()]);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        Hierarchy[] hierarchies = this.getHierarchies();
        for (int i = 0; i < hierarchies.length; ++i) {
            hierarchies[i].accept(visitor);
        }
    }
}

