/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.lang.reflect.Field;
import javax.swing.table.AbstractTableModel;

public class PropertyTableModel
extends AbstractTableModel {
    String[] propertyNames;
    Object target;

    public PropertyTableModel(Object t, String[] pNames) {
        this.propertyNames = pNames;
        this.target = t;
    }

    public String getColumnName(int i) {
        if (i == 0) {
            return "Property";
        }
        if (i == 1) {
            return "Value";
        }
        return "?";
    }

    public boolean isCellEditable(int row, int col) {
        return col == 1;
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.propertyNames.length;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.propertyNames[rowIndex];
        }
        try {
            Field f = this.target.getClass().getField(this.propertyNames[rowIndex]);
            Object obj = f.get(this.target);
            return obj;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "#ERROR";
        }
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        try {
            Field f = this.target.getClass().getField(this.propertyNames[rowIndex]);
            f.set(this.target, aValue);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Object getValue() {
        return this.target;
    }
}

