/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.syntax.parser;

import java.util.ArrayList;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.syntax.CSTNode;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.parser.ExpressionSupport;
import org.codehaus.groovy.syntax.parser.Parser;

public class ExpressionStack {
    private ArrayList stack = new ArrayList();
    private Parser parser = null;
    private int open = 0;

    ExpressionStack(Parser context) {
        this.parser = context;
    }

    boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public boolean isComplete() {
        return this.size() == 1 && this.topIsAnExpression();
    }

    public boolean canComplete() {
        if (this.open > 0 || !this.topIsAnExpression()) {
            return false;
        }
        if (this.size() == 1) {
            return true;
        }
        return true;
    }

    int size() {
        return this.stack.size();
    }

    void push(CSTNode node) {
        if ((node.isA(50) || node.isA(330)) && node.size() == 1) {
            ++this.open;
        }
        this.stack.add(node);
    }

    CSTNode pop() {
        CSTNode node = (CSTNode)this.stack.remove(this.stack.size() - 1);
        if ((node.isA(50) || node.isA(330)) && node.size() == 1) {
            --this.open;
        }
        return node;
    }

    CSTNode top() {
        return this.top(0);
    }

    CSTNode top(int offset) {
        if (offset < this.stack.size()) {
            return (CSTNode)this.stack.get(this.stack.size() - 1 - offset);
        }
        return Token.NULL;
    }

    void shift(int count) throws SyntaxException, CompilationFailedException {
        for (int i = 0; i < count; ++i) {
            this.push(this.parser.consume());
        }
    }

    void shift() throws SyntaxException, CompilationFailedException {
        this.push(this.parser.consume());
    }

    void reduce(int count, int rootOffset, boolean mark) {
        if (count <= rootOffset || rootOffset < 0 || count > this.size()) {
            throw new GroovyBugError("error in call to ExpressionStack.reduce(): count=" + count + ", rootOffset=" + rootOffset);
        }
        CSTNode root = null;
        CSTNode[] children = new CSTNode[count - 1];
        int child = count - 2;
        for (int element = 0; element < count; ++element) {
            if (element == rootOffset) {
                root = this.pop();
                continue;
            }
            children[child--] = this.pop();
        }
        root = root.asReduction();
        for (int i = 0; i < children.length; ++i) {
            root.add(children[i]);
        }
        if (mark) {
            root.markAsExpression();
        }
        this.push(root);
    }

    boolean atStartOfExpression() {
        return this.isEmpty() || this.top().isA(50) && !this.top().hasChildren();
    }

    boolean topIsAnOperator() {
        return ExpressionSupport.isAnOperator(this.top(), false);
    }

    boolean topIsAnOperator(int offset, boolean unknownReturns) {
        return ExpressionSupport.isAnOperator(this.top(offset), unknownReturns);
    }

    boolean topIsAModifiableExpression() {
        return ExpressionSupport.isAModifiableExpression(this.top());
    }

    boolean topIsAnExpression() {
        return this.top().isAnExpression();
    }

    void shiftIf(boolean flag, String error) throws SyntaxException, CompilationFailedException {
        if (flag) {
            this.push(this.parser.consume());
        } else {
            this.parser.error(error);
        }
    }

    void shiftUnless(boolean flag, String error) throws SyntaxException, CompilationFailedException {
        if (flag) {
            this.parser.error(error);
        } else {
            this.push(this.parser.consume());
        }
    }

    void shiftIfTopIsAnExpression(String error) throws SyntaxException, CompilationFailedException {
        this.shiftIf(ExpressionSupport.isAnExpression(this.top(), false), error);
    }

    void shiftIfTopIsAnOperator(String error) throws SyntaxException, CompilationFailedException {
        this.shiftIf(ExpressionSupport.isAnOperator(this.top(), false), error);
    }

    void shiftUnlessTopIsAnExpression(String error) throws SyntaxException, CompilationFailedException {
        this.shiftUnless(ExpressionSupport.isAnExpression(this.top(), false), error);
    }

    void shiftUnlessTopIsAnOperator(String error) throws SyntaxException, CompilationFailedException {
        this.shiftUnless(ExpressionSupport.isAnOperator(this.top(), false), error);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String newline = System.getProperty("line.separator", "\n");
        int count = this.stack.size();
        buffer.append("ExpressionStack with ").append(this.size()).append(" elements").append(newline);
        for (int i = count - 1; i >= 0; --i) {
            buffer.append(this.top(i).toString()).append(newline);
        }
        return buffer.toString();
    }
}

