/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.syntax.lexer;

import org.codehaus.groovy.syntax.ReadException;
import org.codehaus.groovy.syntax.lexer.Lexer;
import org.codehaus.groovy.syntax.lexer.LexerBase;
import org.codehaus.groovy.syntax.lexer.LexerException;
import org.codehaus.groovy.syntax.lexer.TextLexerBase;
import org.codehaus.groovy.syntax.lexer.UnterminatedStringLiteralException;

public class HereDocLexer
extends TextLexerBase {
    protected String marker = null;
    protected boolean onmargin = true;
    protected String data = "";
    protected int consumed = -1;
    protected boolean last = false;

    public HereDocLexer(String marker) {
        if (marker.startsWith("-")) {
            this.marker = marker.substring(1, marker.length());
            this.onmargin = false;
        } else {
            this.marker = marker;
            this.onmargin = true;
        }
    }

    public void setSource(Lexer source) {
        super.setSource(source);
        this.data = "";
        this.consumed = -1;
        this.last = false;
        this.restart();
        this.delimit(true);
    }

    public void unsetSource() {
        this.finish();
        super.unsetSource();
    }

    public void delimit(boolean delimit) {
        super.delimit(delimit);
        if (delimit) {
            try {
                if (!this.finished && this.la(1) == '\uffff') {
                    this.finish();
                }
            }
            catch (Exception e) {
                this.finished = true;
            }
        }
    }

    public char la(int k) throws LexerException, ReadException {
        if (!this.finished && this.source != null) {
            if (this.consumed + k >= this.data.length()) {
                this.refill();
            }
            if (this.consumed + k < this.data.length()) {
                return this.data.charAt(this.consumed + k);
            }
        }
        return '\uffff';
    }

    public char consume() throws LexerException, ReadException {
        if (!this.finished && this.source != null) {
            char c = this.data.charAt(++this.consumed);
            if (this.delimited && this.la(1) == '\uffff') {
                this.finish();
            }
            return c;
        }
        return '\uffff';
    }

    protected void refill() throws LexerException, ReadException {
        if (!this.finished && this.source != null && !this.last) {
            char c;
            StringBuffer read = new StringBuffer();
            for (int i = this.consumed + 1; i < this.data.length(); ++i) {
                read.append(this.data.charAt(i));
            }
            StringBuffer raw = new StringBuffer();
            while ((c = this.source.la()) == '\n' || c == '\r') {
                if (raw.length() > 0) {
                    read.append(raw);
                    raw.setLength(0);
                }
                if (((LexerBase)this.source).readEOL(raw)) continue;
                throw new UnterminatedStringLiteralException(this.getStartLine(), this.getStartColumn());
            }
            boolean use = true;
            if (!this.isDelimited()) {
                while ((c = this.source.la()) != '\n' && c != '\r' && c != '\uffff') {
                    raw.append(this.source.consume());
                }
            } else {
                if (!this.onmargin) {
                    while ((c = this.source.la()) == ' ' || c == '\t') {
                        raw.append(this.source.consume());
                    }
                }
                int testing = 0;
                int length = this.marker.length();
                boolean found = false;
                boolean lost = false;
                while ((c = this.source.la()) != '\n' && c != '\r' && c != '\uffff' && !found) {
                    if (!lost && c == this.marker.charAt(testing)) {
                        if (++testing == length) {
                            found = true;
                        }
                    } else {
                        lost = true;
                    }
                    raw.append(this.source.consume());
                }
                if (found) {
                    use = false;
                }
            }
            if (use) {
                read.append(raw);
            } else {
                this.last = true;
            }
            this.data = read.toString();
            this.consumed = -1;
        }
    }
}

