/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.charts.design.JRDesignAreaPlot;
import net.sf.jasperreports.charts.design.JRDesignBar3DPlot;
import net.sf.jasperreports.charts.design.JRDesignBarPlot;
import net.sf.jasperreports.charts.design.JRDesignBubblePlot;
import net.sf.jasperreports.charts.design.JRDesignCandlestickPlot;
import net.sf.jasperreports.charts.design.JRDesignCategoryDataset;
import net.sf.jasperreports.charts.design.JRDesignHighLowDataset;
import net.sf.jasperreports.charts.design.JRDesignHighLowPlot;
import net.sf.jasperreports.charts.design.JRDesignLinePlot;
import net.sf.jasperreports.charts.design.JRDesignMeterPlot;
import net.sf.jasperreports.charts.design.JRDesignMultiAxisPlot;
import net.sf.jasperreports.charts.design.JRDesignPie3DPlot;
import net.sf.jasperreports.charts.design.JRDesignPieDataset;
import net.sf.jasperreports.charts.design.JRDesignPiePlot;
import net.sf.jasperreports.charts.design.JRDesignScatterPlot;
import net.sf.jasperreports.charts.design.JRDesignThermometerPlot;
import net.sf.jasperreports.charts.design.JRDesignTimePeriodDataset;
import net.sf.jasperreports.charts.design.JRDesignTimeSeriesDataset;
import net.sf.jasperreports.charts.design.JRDesignTimeSeriesPlot;
import net.sf.jasperreports.charts.design.JRDesignValueDataset;
import net.sf.jasperreports.charts.design.JRDesignXyDataset;
import net.sf.jasperreports.charts.design.JRDesignXyzDataset;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRDesignChart
extends JRDesignElement
implements JRChart {
    private static final long serialVersionUID = 10200L;
    protected byte chartType = 0;
    protected boolean isShowLegend = false;
    protected byte evaluationTime = 1;
    protected byte hyperlinkType = 0;
    protected String linkType;
    protected byte hyperlinkTarget = 1;
    protected byte titlePosition = 1;
    protected Color titleColor = Color.black;
    protected Color subtitleColor = Color.black;
    protected Color legendColor = null;
    protected Color legendBackgroundColor = null;
    protected JRFont titleFont = null;
    protected JRFont subtitleFont = null;
    protected JRFont legendFont = null;
    protected String customizerClass;
    protected JRGroup evaluationGroup = null;
    protected JRExpression titleExpression = null;
    protected JRExpression subtitleExpression = null;
    protected JRExpression anchorNameExpression = null;
    protected JRExpression hyperlinkReferenceExpression = null;
    protected JRExpression hyperlinkAnchorExpression = null;
    protected JRExpression hyperlinkPageExpression = null;
    private JRExpression hyperlinkTooltipExpression;
    private List hyperlinkParameters;
    protected JRChartDataset dataset = null;
    protected JRChartPlot plot = null;
    protected Byte border;
    protected Byte topBorder = null;
    protected Byte leftBorder = null;
    protected Byte bottomBorder = null;
    protected Byte rightBorder = null;
    protected Color borderColor = null;
    protected Color topBorderColor = null;
    protected Color leftBorderColor = null;
    protected Color bottomBorderColor = null;
    protected Color rightBorderColor = null;
    protected Integer padding;
    protected Integer topPadding = null;
    protected Integer leftPadding = null;
    protected Integer bottomPadding = null;
    protected Integer rightPadding = null;
    protected int bookmarkLevel = 0;

    public JRDesignChart(JRDefaultStyleProvider defaultStyleProvider, byte chartType) {
        super(defaultStyleProvider);
        this.setChartType(chartType);
        this.hyperlinkParameters = new ArrayList();
    }

    public boolean isShowLegend() {
        return this.isShowLegend;
    }

    public void setShowLegend(boolean isShowLegend) {
        this.isShowLegend = isShowLegend;
    }

    public byte getEvaluationTime() {
        return this.evaluationTime;
    }

    public void setEvaluationTime(byte evaluationTime) {
        this.evaluationTime = evaluationTime;
    }

    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    public void setEvaluationGroup(JRGroup group) {
        this.evaluationGroup = group;
    }

    public JRBox getBox() {
        return this;
    }

    public void setBox(JRBox box) {
        this.border = box.getOwnBorder();
        this.topBorder = box.getOwnTopBorder();
        this.leftBorder = box.getOwnLeftBorder();
        this.bottomBorder = box.getOwnBottomBorder();
        this.rightBorder = box.getOwnRightBorder();
        this.borderColor = box.getOwnBorderColor();
        this.topBorderColor = box.getOwnTopBorderColor();
        this.leftBorderColor = box.getOwnLeftBorderColor();
        this.bottomBorderColor = box.getOwnBottomBorderColor();
        this.rightBorderColor = box.getOwnRightBorderColor();
        this.padding = box.getOwnPadding();
        this.topPadding = box.getOwnTopPadding();
        this.leftPadding = box.getOwnLeftPadding();
        this.bottomPadding = box.getOwnBottomPadding();
        this.rightPadding = box.getOwnRightPadding();
    }

    public JRFont getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(JRFont font) {
        this.titleFont = font;
    }

    public byte getTitlePosition() {
        return this.titlePosition;
    }

    public void setTitlePosition(byte titlePosition) {
        this.titlePosition = titlePosition;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
    }

    public JRFont getSubtitleFont() {
        return this.subtitleFont;
    }

    public void setSubtitleFont(JRFont font) {
        this.subtitleFont = font;
    }

    public Color getSubtitleColor() {
        return this.subtitleColor;
    }

    public void setSubtitleColor(Color subtitleColor) {
        this.subtitleColor = subtitleColor;
    }

    public Color getLegendColor() {
        return this.legendColor;
    }

    public void setLegendColor(Color legendColor) {
        this.legendColor = legendColor;
    }

    public Color getLegendBackgroundColor() {
        return this.legendBackgroundColor;
    }

    public void setLegendBackgroundColor(Color legendBackgroundColor) {
        this.legendBackgroundColor = legendBackgroundColor;
    }

    public JRFont getLegendFont() {
        return this.legendFont;
    }

    public void setLegendFont(JRFont legendFont) {
        this.legendFont = legendFont;
    }

    public byte getHyperlinkType() {
        return JRHyperlinkHelper.getHyperlinkType(this);
    }

    public void setHyperlinkType(byte hyperlinkType) {
        this.setLinkType(JRHyperlinkHelper.getLinkType(hyperlinkType));
    }

    public byte getHyperlinkTarget() {
        return this.hyperlinkTarget;
    }

    public void setHyperlinkTarget(byte hyperlinkTarget) {
        this.hyperlinkTarget = hyperlinkTarget;
    }

    public JRExpression getTitleExpression() {
        return this.titleExpression;
    }

    public void setTitleExpression(JRExpression expression) {
        this.titleExpression = expression;
    }

    public JRExpression getSubtitleExpression() {
        return this.subtitleExpression;
    }

    public void setSubtitleExpression(JRExpression expression) {
        this.subtitleExpression = expression;
    }

    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    public void setAnchorNameExpression(JRExpression anchorNameExpression) {
        this.anchorNameExpression = anchorNameExpression;
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    public void setHyperlinkReferenceExpression(JRExpression hyperlinkReferenceExpression) {
        this.hyperlinkReferenceExpression = hyperlinkReferenceExpression;
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    public void setHyperlinkAnchorExpression(JRExpression hyperlinkAnchorExpression) {
        this.hyperlinkAnchorExpression = hyperlinkAnchorExpression;
    }

    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    public void setHyperlinkPageExpression(JRExpression hyperlinkPageExpression) {
        this.hyperlinkPageExpression = hyperlinkPageExpression;
    }

    public JRChartDataset getDataset() {
        return this.dataset;
    }

    public JRChartPlot getPlot() {
        return this.plot;
    }

    public byte getChartType() {
        return this.chartType;
    }

    public void setChartType(byte chartType) {
        this.chartType = chartType;
        switch (chartType) {
            case 1: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignAreaPlot(this.plot);
                break;
            }
            case 3: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBarPlot(this.plot);
                break;
            }
            case 2: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBar3DPlot(this.plot);
                break;
            }
            case 4: {
                this.dataset = new JRDesignXyzDataset(this.dataset);
                this.plot = new JRDesignBubblePlot(this.plot);
                break;
            }
            case 5: {
                this.dataset = new JRDesignHighLowDataset(this.dataset);
                this.plot = new JRDesignCandlestickPlot(this.plot);
                break;
            }
            case 6: {
                this.dataset = new JRDesignHighLowDataset(this.dataset);
                this.plot = new JRDesignHighLowPlot(this.plot);
                break;
            }
            case 7: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignLinePlot(this.plot);
                break;
            }
            case 17: {
                this.dataset = new JRDesignValueDataset(this.dataset);
                this.plot = new JRDesignMeterPlot(this.plot);
                break;
            }
            case 19: {
                this.plot = new JRDesignMultiAxisPlot(this.plot);
                this.dataset = null;
                break;
            }
            case 9: {
                this.dataset = new JRDesignPieDataset(this.dataset);
                this.plot = new JRDesignPiePlot(this.plot);
                break;
            }
            case 8: {
                this.dataset = new JRDesignPieDataset(this.dataset);
                this.plot = new JRDesignPie3DPlot(this.plot);
                break;
            }
            case 10: {
                this.dataset = new JRDesignXyDataset(this.dataset);
                this.plot = new JRDesignScatterPlot(this.plot);
                break;
            }
            case 12: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBarPlot(this.plot);
                break;
            }
            case 11: {
                this.dataset = new JRDesignCategoryDataset(this.dataset);
                this.plot = new JRDesignBar3DPlot(this.plot);
                break;
            }
            case 18: {
                this.dataset = new JRDesignValueDataset(this.dataset);
                this.plot = new JRDesignThermometerPlot(this.plot);
                break;
            }
            case 16: {
                this.dataset = new JRDesignTimeSeriesDataset(this.dataset);
                this.plot = new JRDesignTimeSeriesPlot(this.plot);
                break;
            }
            case 13: {
                this.dataset = new JRDesignXyDataset(this.dataset);
                this.plot = new JRDesignAreaPlot(this.plot);
                break;
            }
            case 14: {
                this.plot = new JRDesignBarPlot(this.plot);
                break;
            }
            case 15: {
                this.dataset = new JRDesignXyDataset(this.dataset);
                this.plot = new JRDesignLinePlot(this.plot);
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
    }

    public void setDataset(JRChartDataset ds) {
        switch (ds.getDatasetType()) {
            case 2: {
                this.dataset = (JRDesignCategoryDataset)ds;
                break;
            }
            case 7: {
                this.dataset = (JRDesignHighLowDataset)ds;
                break;
            }
            case 1: {
                this.dataset = (JRDesignPieDataset)ds;
                break;
            }
            case 5: {
                this.dataset = (JRDesignTimePeriodDataset)ds;
                break;
            }
            case 6: {
                this.dataset = (JRDesignTimeSeriesDataset)ds;
                break;
            }
            case 8: {
                this.dataset = (JRDesignValueDataset)ds;
                break;
            }
            case 3: {
                this.dataset = (JRDesignXyDataset)ds;
                break;
            }
            case 4: {
                this.dataset = (JRDesignXyzDataset)ds;
            }
        }
    }

    public JRChild getCopy(JRAbstractObjectFactory factory) {
        return factory.getChart(this);
    }

    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    public void writeXml(JRXmlWriter xmlWriter) throws IOException {
        switch (this.chartType) {
            case 1: {
                xmlWriter.writeAreaChart(this);
                break;
            }
            case 3: {
                xmlWriter.writeBarChart(this);
                break;
            }
            case 2: {
                xmlWriter.writeBar3DChart(this);
                break;
            }
            case 4: {
                xmlWriter.writeBubbleChart(this);
                break;
            }
            case 5: {
                xmlWriter.writeCandlestickChart(this);
                break;
            }
            case 6: {
                xmlWriter.writeHighLowChart(this);
                break;
            }
            case 7: {
                xmlWriter.writeLineChart(this);
                break;
            }
            case 17: {
                xmlWriter.writeMeterChart(this);
                break;
            }
            case 19: {
                xmlWriter.writeMultiAxisChart(this);
                break;
            }
            case 9: {
                xmlWriter.writePieChart(this);
                break;
            }
            case 8: {
                xmlWriter.writePie3DChart(this);
                break;
            }
            case 10: {
                xmlWriter.writeScatterChart(this);
                break;
            }
            case 12: {
                xmlWriter.writeStackedBarChart(this);
                break;
            }
            case 11: {
                xmlWriter.writeStackedBar3DChart(this);
                break;
            }
            case 18: {
                xmlWriter.writeThermometerChart(this);
                break;
            }
            case 16: {
                xmlWriter.writeTimeSeriesChart(this);
                break;
            }
            case 13: {
                xmlWriter.writeXyAreaChart(this);
                break;
            }
            case 14: {
                xmlWriter.writeXyBarChart(this);
                break;
            }
            case 15: {
                xmlWriter.writeXyLineChart(this);
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
    }

    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public void setBookmarkLevel(int bookmarkLevel) {
        this.bookmarkLevel = bookmarkLevel;
    }

    public String getCustomizerClass() {
        return this.customizerClass;
    }

    public void setCustomizerClass(String customizerClass) {
        this.customizerClass = customizerClass;
    }

    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    public byte getBorder() {
        return JRStyleResolver.getBorder(this);
    }

    public Byte getOwnBorder() {
        return this.border;
    }

    public void setBorder(byte border) {
        this.border = new Byte(border);
    }

    public Color getBorderColor() {
        return JRStyleResolver.getBorderColor(this, this.getForecolor());
    }

    public Color getOwnBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public int getPadding() {
        return JRStyleResolver.getPadding(this);
    }

    public Integer getOwnPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = new Integer(padding);
    }

    public byte getTopBorder() {
        return JRStyleResolver.getTopBorder(this);
    }

    public Byte getOwnTopBorder() {
        return this.topBorder;
    }

    public void setTopBorder(byte topBorder) {
        this.topBorder = new Byte(topBorder);
    }

    public Color getTopBorderColor() {
        return JRStyleResolver.getTopBorderColor(this, this.getForecolor());
    }

    public Color getOwnTopBorderColor() {
        return this.topBorderColor;
    }

    public void setTopBorderColor(Color topBorderColor) {
        this.topBorderColor = topBorderColor;
    }

    public int getTopPadding() {
        return JRStyleResolver.getTopPadding(this);
    }

    public Integer getOwnTopPadding() {
        return this.topPadding;
    }

    public void setTopPadding(int topPadding) {
        this.topPadding = new Integer(topPadding);
    }

    public byte getLeftBorder() {
        return JRStyleResolver.getLeftBorder(this);
    }

    public Byte getOwnLeftBorder() {
        return this.leftBorder;
    }

    public void setLeftBorder(byte leftBorder) {
        this.leftBorder = new Byte(leftBorder);
    }

    public Color getLeftBorderColor() {
        return JRStyleResolver.getLeftBorderColor(this, this.getForecolor());
    }

    public Color getOwnLeftBorderColor() {
        return this.leftBorderColor;
    }

    public void setLeftBorderColor(Color leftBorderColor) {
        this.leftBorderColor = leftBorderColor;
    }

    public int getLeftPadding() {
        return JRStyleResolver.getLeftPadding(this);
    }

    public Integer getOwnLeftPadding() {
        return this.leftPadding;
    }

    public void setLeftPadding(int leftPadding) {
        this.leftPadding = new Integer(leftPadding);
    }

    public byte getBottomBorder() {
        return JRStyleResolver.getBottomBorder(this);
    }

    public Byte getOwnBottomBorder() {
        return this.bottomBorder;
    }

    public void setBottomBorder(byte bottomBorder) {
        this.bottomBorder = new Byte(bottomBorder);
    }

    public Color getBottomBorderColor() {
        return JRStyleResolver.getBottomBorderColor(this, this.getForecolor());
    }

    public Color getOwnBottomBorderColor() {
        return this.bottomBorderColor;
    }

    public void setBottomBorderColor(Color bottomBorderColor) {
        this.bottomBorderColor = bottomBorderColor;
    }

    public int getBottomPadding() {
        return JRStyleResolver.getBottomPadding(this);
    }

    public Integer getOwnBottomPadding() {
        return this.bottomPadding;
    }

    public void setBottomPadding(int bottomPadding) {
        this.bottomPadding = new Integer(bottomPadding);
    }

    public byte getRightBorder() {
        return JRStyleResolver.getRightBorder(this);
    }

    public Byte getOwnRightBorder() {
        return this.rightBorder;
    }

    public void setRightBorder(byte rightBorder) {
        this.rightBorder = new Byte(rightBorder);
    }

    public Color getRightBorderColor() {
        return JRStyleResolver.getRightBorderColor(this, this.getForecolor());
    }

    public Color getOwnRightBorderColor() {
        return this.rightBorderColor;
    }

    public void setRightBorderColor(Color rightBorderColor) {
        this.rightBorderColor = rightBorderColor;
    }

    public int getRightPadding() {
        return JRStyleResolver.getRightPadding(this);
    }

    public Integer getOwnRightPadding() {
        return this.rightPadding;
    }

    public void setRightPadding(int rightPadding) {
        this.rightPadding = new Integer(rightPadding);
    }

    public void setBorder(Byte border) {
        this.border = border;
    }

    public void setPadding(Integer padding) {
        this.padding = padding;
    }

    public void setTopBorder(Byte topBorder) {
        this.topBorder = topBorder;
    }

    public void setTopPadding(Integer topPadding) {
        this.topPadding = topPadding;
    }

    public void setLeftBorder(Byte leftBorder) {
        this.leftBorder = leftBorder;
    }

    public void setLeftPadding(Integer leftPadding) {
        this.leftPadding = leftPadding;
    }

    public void setBottomBorder(Byte bottomBorder) {
        this.bottomBorder = bottomBorder;
    }

    public void setBottomPadding(Integer bottomPadding) {
        this.bottomPadding = bottomPadding;
    }

    public void setRightBorder(Byte rightBorder) {
        this.rightBorder = rightBorder;
    }

    public void setRightPadding(Integer rightPadding) {
        this.rightPadding = rightPadding;
    }

    public String getLinkType() {
        return this.linkType;
    }

    public void setLinkType(String type) {
        this.linkType = type;
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        JRHyperlinkParameter[] parameters;
        if (this.hyperlinkParameters.isEmpty()) {
            parameters = null;
        } else {
            parameters = new JRHyperlinkParameter[this.hyperlinkParameters.size()];
            this.hyperlinkParameters.toArray(parameters);
        }
        return parameters;
    }

    public List getHyperlinkParametersList() {
        return this.hyperlinkParameters;
    }

    public void addHyperlinkParameter(JRHyperlinkParameter parameter) {
        this.hyperlinkParameters.add(parameter);
    }

    public void removeHyperlinkParameter(JRHyperlinkParameter parameter) {
        this.hyperlinkParameters.remove(parameter);
    }

    public void removeHyperlinkParameter(String parameterName) {
        Iterator it = this.hyperlinkParameters.iterator();
        while (it.hasNext()) {
            JRHyperlinkParameter parameter = (JRHyperlinkParameter)it.next();
            if (parameter.getName() == null || !parameter.getName().equals(parameterName)) continue;
            it.remove();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.normalizeLinkType();
    }

    protected void normalizeLinkType() {
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(this.hyperlinkType);
        }
        this.hyperlinkType = 0;
    }

    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    public void setHyperlinkTooltipExpression(JRExpression hyperlinkTooltipExpression) {
        this.hyperlinkTooltipExpression = hyperlinkTooltipExpression;
    }
}

