/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.awt.Color;
import java.io.Serializable;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import org.jfree.chart.plot.PlotOrientation;

public abstract class JRBaseChartPlot
implements JRChartPlot,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected Color backcolor = null;
    protected PlotOrientation orientation = PlotOrientation.VERTICAL;
    protected float backgroundAlpha = 1.0f;
    protected float foregroundAlpha = 1.0f;
    protected double labelRotation = 0.0;
    protected SortedSet seriesColors = null;

    protected JRBaseChartPlot(JRChartPlot plot) {
        if (plot != null) {
            this.backcolor = plot.getBackcolor();
            this.orientation = plot.getOrientation();
            this.backgroundAlpha = plot.getBackgroundAlpha();
            this.foregroundAlpha = plot.getForegroundAlpha();
            this.labelRotation = plot.getLabelRotation();
            this.seriesColors = new TreeSet(plot.getSeriesColors());
        } else {
            this.seriesColors = new TreeSet();
        }
    }

    protected JRBaseChartPlot(JRChartPlot plot, JRBaseObjectFactory factory) {
        factory.put(plot, this);
        this.backcolor = plot.getBackcolor();
        this.orientation = plot.getOrientation();
        this.backgroundAlpha = plot.getBackgroundAlpha();
        this.foregroundAlpha = plot.getForegroundAlpha();
        this.labelRotation = plot.getLabelRotation();
        this.seriesColors = new TreeSet(plot.getSeriesColors());
    }

    public Color getBackcolor() {
        return this.backcolor;
    }

    public void setBackcolor(Color backcolor) {
        this.backcolor = backcolor;
    }

    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(PlotOrientation orientation) {
        this.orientation = orientation;
    }

    public float getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    public void setBackgroundAlpha(float backgroundAlpha) {
        this.backgroundAlpha = backgroundAlpha;
    }

    public float getForegroundAlpha() {
        return this.foregroundAlpha;
    }

    public void setForegroundAlpha(float foregroundAlpha) {
        this.foregroundAlpha = foregroundAlpha;
    }

    public double getLabelRotation() {
        return this.labelRotation;
    }

    public void setLabelRotation(double labelRotation) {
        this.labelRotation = labelRotation;
    }

    public SortedSet getSeriesColors() {
        return this.seriesColors;
    }

    public void clearSeriesColors() {
        this.seriesColors.clear();
    }

    public void addSeriesColor(JRChartPlot.JRSeriesColor seriesColor) {
        this.seriesColors.add(seriesColor);
    }

    public static class JRBaseSeriesColor
    implements JRChartPlot.JRSeriesColor,
    Serializable,
    Comparable {
        private static final long serialVersionUID = 10200L;
        protected int seriesOrder = -1;
        protected Color color = null;

        public JRBaseSeriesColor(int seriesOrder, Color color) {
            this.seriesOrder = seriesOrder;
            this.color = color;
        }

        public int getSeriesOrder() {
            return this.seriesOrder;
        }

        public Color getColor() {
            return this.color;
        }

        public int compareTo(Object obj) {
            if (obj == null) {
                throw new NullPointerException();
            }
            return this.seriesOrder - ((JRBaseSeriesColor)obj).getSeriesOrder();
        }
    }
}

