/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.Arrays;
import mondrian.rolap.DefaultMemberChildrenConstraint;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.sql.SqlQuery;

class ChildByNameConstraint
extends DefaultMemberChildrenConstraint {
    String childName;
    Object cacheKey;

    public ChildByNameConstraint(String childName) {
        this.childName = childName;
        this.cacheKey = Arrays.asList(super.getCacheKey(), ChildByNameConstraint.class, childName);
    }

    public void addLevelConstraint(SqlQuery query, RolapLevel level) {
        super.addLevelConstraint(query, level);
        String column = level.getKeyExp().getExpression(query);
        String value = this.childName;
        if (!level.isNumeric()) {
            column = query.getDialect().toUpper(column);
            value = value.toUpperCase();
        }
        value = query.quote(level.isNumeric(), value);
        query.addWhere(column, "=", value);
    }

    public String toString() {
        return "ChildByNameConstraint(" + this.childName + ")";
    }

    public Object getCacheKey() {
        return this.cacheKey;
    }
}

