/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.type;

import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.olap.type.Type;

public class MemberType
implements Type {
    private final Hierarchy hierarchy;
    private final Level level;
    private final Member member;

    public MemberType(Hierarchy hierarchy, Level level, Member member) {
        this.level = level;
        this.member = member;
        this.hierarchy = hierarchy;
        if (member != null) {
            Util.assertPrecondition(level != null);
            Util.assertPrecondition(member.getLevel() == level);
        }
        if (level != null) {
            Util.assertPrecondition(hierarchy != null);
            Util.assertPrecondition(level.getHierarchy() == hierarchy);
        }
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public Level getLevel() {
        return this.level;
    }

    public boolean usesDimension(Dimension dimension) {
        return this.hierarchy != null && this.hierarchy.getDimension() == dimension;
    }
}

