/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.barbecue.linear.ean;

import java.text.StringCharacterIterator;
import java.util.StringTokenizer;
import net.sourceforge.barbecue.BarcodeException;
import net.sourceforge.barbecue.CompositeModule;
import net.sourceforge.barbecue.Module;
import net.sourceforge.barbecue.linear.code128.Accumulator;
import net.sourceforge.barbecue.linear.code128.CharBuffer;
import net.sourceforge.barbecue.linear.code128.Code128Barcode;
import net.sourceforge.barbecue.linear.code128.ModuleFactory;

public class UCCEAN128Barcode
extends Code128Barcode {
    public static final String SSCC_18_AI = "00";
    public static final String SCC_14_AI = "01";
    public static final String GTIN_AI = "01";
    public static final String EAN128_AI = "01";
    public static final String SHIPMENT_ID_AI = "402";
    public static final String USPS_AI = "420";
    private final String applicationIdentifier;
    private final boolean includeCheckDigit;
    private String labelData;
    private boolean labelDataEncoded = false;

    public UCCEAN128Barcode(String string, String string2) throws BarcodeException {
        this(string, string2, true);
    }

    public UCCEAN128Barcode(String string, String string2, boolean bl) throws BarcodeException {
        super("\u00ca" + string + string2 + UCCEAN128Barcode.getMod10CheckDigit(string2, bl), 2);
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Application Identifier must be provided");
        }
        this.applicationIdentifier = string;
        this.includeCheckDigit = bl;
        this.labelData = string2;
    }

    public UCCEAN128Barcode(String string, boolean bl) throws BarcodeException {
        super("\u00ca" + string + UCCEAN128Barcode.getMod10CheckDigit(string, bl), 2);
        this.applicationIdentifier = "";
        this.includeCheckDigit = bl;
        this.labelData = string;
    }

    public UCCEAN128Barcode(String string) throws BarcodeException {
        super("\u00ca", 2);
        this.applicationIdentifier = "01";
        this.includeCheckDigit = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "()", true);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = null;
            if (string2.equals("(")) {
                string3 = stringTokenizer.nextToken();
                stringTokenizer.nextToken();
            }
            String string4 = stringTokenizer.nextToken();
            if (bl) {
                stringBuffer.append("\u00ca");
            }
            bl = this.getAILength(string3) == 0;
            stringBuffer.append(string3);
            stringBuffer.append(string4);
            stringBuffer2.append("(" + string3 + ")");
            stringBuffer2.append(string4);
            if (!string3.equals("01")) continue;
            String string5 = UCCEAN128Barcode.getGTINCheckDigit(string4);
            stringBuffer.append(string5);
            stringBuffer2.append(string5);
        }
        this.data = this.data + stringBuffer.toString();
        this.labelData = stringBuffer2.toString();
        this.labelDataEncoded = true;
    }

    private int getAILength(String string) {
        if (string.equals(SSCC_18_AI)) {
            return 20;
        }
        if (string.equals("01")) {
            return 16;
        }
        if (string.equals("02")) {
            return 16;
        }
        if (string.equals("03")) {
            return 16;
        }
        if (string.equals("04")) {
            return 18;
        }
        if (string.equals("11")) {
            return 8;
        }
        if (string.equals("12")) {
            return 8;
        }
        if (string.equals("13")) {
            return 8;
        }
        if (string.equals("14")) {
            return 8;
        }
        if (string.equals("15")) {
            return 8;
        }
        if (string.equals("16")) {
            return 8;
        }
        if (string.equals("17")) {
            return 8;
        }
        if (string.equals("18")) {
            return 8;
        }
        if (string.equals("19")) {
            return 8;
        }
        if (string.equals("20")) {
            return 4;
        }
        if (string.equals("31")) {
            return 10;
        }
        if (string.equals("32")) {
            return 10;
        }
        if (string.equals("33")) {
            return 10;
        }
        if (string.equals("34")) {
            return 10;
        }
        if (string.equals("35")) {
            return 10;
        }
        if (string.equals("36")) {
            return 10;
        }
        if (string.equals("41")) {
            return 16;
        }
        return 0;
    }

    protected Module getPreAmble() {
        CompositeModule compositeModule = new CompositeModule();
        compositeModule.add(QUIET_SECTION);
        compositeModule.add(START_C);
        return compositeModule;
    }

    public String getLabel() {
        if (null != this.labelData && this.labelDataEncoded) {
            return this.labelData;
        }
        if (null != this.label) {
            return this.label;
        }
        return '(' + this.applicationIdentifier + ") " + this.labelData + UCCEAN128Barcode.getMod10CheckDigit(this.labelData, this.includeCheckDigit);
    }

    static String getMod10CheckDigit(String string, boolean bl) {
        if (!bl) {
            return "";
        }
        Accumulator accumulator = new Accumulator(START_INDICES[2]);
        Accumulator accumulator2 = new Accumulator(1);
        CharBuffer charBuffer = new CharBuffer(BUF_SIZES[2]);
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            charBuffer.addChar(c);
            if (charBuffer.isFull()) {
                int n = ModuleFactory.getIndex(charBuffer.toString(), 2);
                accumulator.add(n * accumulator2.getValue());
                accumulator2.increment();
                charBuffer.clear();
            }
            c = stringCharacterIterator.next();
        }
        return String.valueOf(accumulator.getValue() % 10);
    }

    static String getGTINCheckDigit(String string) {
        int n;
        int n2 = string.length();
        int n3 = 1;
        int n4 = 0;
        for (n = n2 - 1; n >= 0; --n) {
            n3 = n3 == 1 ? 3 : 1;
            n4 += n3 * Integer.parseInt(string.substring(n, n + 1));
        }
        n = (n4 / 10 + 1) * 10 - n4;
        return String.valueOf(n);
    }
}

