/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jca.cci.connection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import org.springframework.jca.cci.connection.ConnectionFactoryUtils;
import org.springframework.jca.cci.connection.DelegatingConnectionFactory;

public class TransactionAwareConnectionFactoryProxy
extends DelegatingConnectionFactory {
    static /* synthetic */ Class class$javax$resource$cci$Connection;

    public TransactionAwareConnectionFactoryProxy() {
    }

    public TransactionAwareConnectionFactoryProxy(ConnectionFactory targetConnectionFactory) {
        this.setTargetConnectionFactory(targetConnectionFactory);
        this.afterPropertiesSet();
    }

    public Connection getConnection() throws ResourceException {
        Connection con = ConnectionFactoryUtils.doGetConnection(this.getTargetConnectionFactory());
        return this.getTransactionAwareConnectionProxy(con, this.getTargetConnectionFactory());
    }

    protected Connection getTransactionAwareConnectionProxy(Connection target, ConnectionFactory cf) {
        return (Connection)Proxy.newProxyInstance((class$javax$resource$cci$Connection == null ? (class$javax$resource$cci$Connection = TransactionAwareConnectionFactoryProxy.class$("javax.resource.cci.Connection")) : class$javax$resource$cci$Connection).getClassLoader(), new Class[]{class$javax$resource$cci$Connection == null ? (class$javax$resource$cci$Connection = TransactionAwareConnectionFactoryProxy.class$("javax.resource.cci.Connection")) : class$javax$resource$cci$Connection}, (InvocationHandler)new TransactionAwareInvocationHandler(target, cf));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class TransactionAwareInvocationHandler
    implements InvocationHandler {
        private final Connection target;
        private final ConnectionFactory connectionFactory;

        public TransactionAwareInvocationHandler(Connection target, ConnectionFactory cf) {
            this.target = target;
            this.connectionFactory = cf;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            if (method.getName().equals("close")) {
                if (this.connectionFactory != null) {
                    ConnectionFactoryUtils.doReleaseConnection(this.target, this.connectionFactory);
                }
                return null;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

