/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.undo;

import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.TransformationType;
import it.businesslogic.ireport.UndoOperation;
import it.businesslogic.ireport.gui.JReportFrame;
import java.awt.Point;
import java.util.Enumeration;

public class RemoveMarginsOperation
implements UndoOperation {
    private int oldTop = 0;
    private int oldLeft = 0;
    private int oldBottom = 0;
    private int oldRight = 0;
    private JReportFrame jrf = null;

    public RemoveMarginsOperation(JReportFrame jrf, int oldTop, int oldBottom, int oldLeft, int oldRight) {
        this.oldTop = oldTop;
        this.oldBottom = oldBottom;
        this.oldLeft = oldLeft;
        this.oldRight = oldRight;
        this.jrf = jrf;
    }

    public void redo() {
        if (this.jrf == null) {
            return;
        }
        this.jrf.getReport().setTopMargin(0);
        this.jrf.getReport().setBottomMargin(0);
        this.jrf.getReport().setLeftMargin(0);
        this.jrf.getReport().setRightMargin(0);
        this.jrf.getReport().setWidth(this.jrf.getReport().getWidth() - this.oldLeft - this.oldRight);
        if (this.oldTop != 0 || this.oldLeft != 0) {
            Enumeration e = this.jrf.getReport().getElements().elements();
            while (e.hasMoreElements()) {
                ReportElement re = (ReportElement)e.nextElement();
                re.trasform(new Point(-this.oldLeft, -this.oldTop), TransformationType.TRANSFORMATION_MOVE);
            }
        }
        this.jrf.setIsDocDirty(true);
        this.jrf.getReportPanel().repaint();
    }

    public void undo() {
        if (this.jrf == null) {
            return;
        }
        this.jrf.getReport().setTopMargin(this.oldTop);
        this.jrf.getReport().setBottomMargin(this.oldBottom);
        this.jrf.getReport().setLeftMargin(this.oldLeft);
        this.jrf.getReport().setRightMargin(this.oldRight);
        this.jrf.getReport().setWidth(this.jrf.getReport().getWidth() + this.oldLeft + this.oldRight);
        if (this.oldTop != 0 || this.oldLeft != 0) {
            Enumeration e = this.jrf.getReport().getElements().elements();
            while (e.hasMoreElements()) {
                ReportElement re = (ReportElement)e.nextElement();
                re.trasform(new Point(this.oldLeft, this.oldTop), TransformationType.TRANSFORMATION_MOVE);
            }
        }
        this.jrf.setIsDocDirty(true);
        this.jrf.getReportPanel().repaint();
    }

    public String toString() {
        return "remove margins";
    }
}

