/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.sheet;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.BarcodeReportElement;
import it.businesslogic.ireport.ChartReportElement2;
import it.businesslogic.ireport.ExpressionContext;
import it.businesslogic.ireport.GraphicReportElement;
import it.businesslogic.ireport.IRFont;
import it.businesslogic.ireport.ImageReportElement;
import it.businesslogic.ireport.LineReportElement;
import it.businesslogic.ireport.RectangleReportElement;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.StaticTextReportElement;
import it.businesslogic.ireport.Style;
import it.businesslogic.ireport.TextFieldReportElement;
import it.businesslogic.ireport.TextReportElement;
import it.businesslogic.ireport.TransformationType;
import it.businesslogic.ireport.crosstab.CrosstabCell;
import it.businesslogic.ireport.gui.JNumberComboBox;
import it.businesslogic.ireport.gui.JNumberField;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.FontsListChangedEvent;
import it.businesslogic.ireport.gui.event.FontsListChangedListener;
import it.businesslogic.ireport.gui.event.ReportBandChangedEvent;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.gui.event.ReportElementsSelectionEvent;
import it.businesslogic.ireport.gui.event.ReportFrameActivatedEvent;
import it.businesslogic.ireport.gui.event.ReportFrameActivatedListener;
import it.businesslogic.ireport.gui.event.ReportListener;
import it.businesslogic.ireport.gui.event.SheetPropertyValueChangedEvent;
import it.businesslogic.ireport.gui.sheet.CategorySheetPanel;
import it.businesslogic.ireport.gui.sheet.ColorSelectorPanel;
import it.businesslogic.ireport.gui.sheet.ComboBoxSheetProperty;
import it.businesslogic.ireport.gui.sheet.ExpressionSheetProperty;
import it.businesslogic.ireport.gui.sheet.ExpressionSheetPropertyComponent;
import it.businesslogic.ireport.gui.sheet.NumberComboBoxSheetProperty;
import it.businesslogic.ireport.gui.sheet.PatternSheetProperty;
import it.businesslogic.ireport.gui.sheet.PatternSheetPropertyComponent;
import it.businesslogic.ireport.gui.sheet.SheetProperty;
import it.businesslogic.ireport.gui.sheet.Tag;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class ReportElementSheetPanel
extends CategorySheetPanel
implements ReportListener,
LanguageChangedListener,
ReportFrameActivatedListener {
    private ComboBoxSheetProperty spBands;
    private SheetProperty spTop;
    private SheetProperty spLeft;
    private SheetProperty spHeight;
    private SheetProperty spWidth;
    private SheetProperty spFgColor;
    private SheetProperty spBgColor;
    private SheetProperty spMode;
    private SheetProperty spPrintRepeatedValues;
    private SheetProperty spPrintWhenDetailOverflows;
    private SheetProperty spPrintInFirstWholeBand;
    private SheetProperty spRemoveLineWhenBlank;
    private SheetProperty spPositionType;
    private SheetProperty spElementKey;
    private SheetProperty spStretchType;
    private ComboBoxSheetProperty spStyle;
    private ComboBoxSheetProperty spGroups;
    private ExpressionSheetProperty spPrintWhenExpression;
    private SheetProperty spFill;
    private SheetProperty spPen;
    private SheetProperty spRadius;
    private SheetProperty spDirection;
    private SheetProperty spTextHAlign;
    private SheetProperty spTextVAlign;
    private SheetProperty spStyledText;
    private SheetProperty spLineSpacing;
    private SheetProperty spRotate;
    private SheetProperty spFontName;
    private NumberComboBoxSheetProperty spFontSize;
    private SheetProperty spPdfFontName;
    private SheetProperty spBold;
    private SheetProperty spItalic;
    private SheetProperty spUnderline;
    private SheetProperty spStriketrough;
    private SheetProperty spPdfEmbedded;
    private SheetProperty spPdfEncoding;
    private ExpressionSheetProperty spStaticText;
    private ExpressionSheetProperty spTextfieldExpression;
    private SheetProperty spTextfieldExpressionClass;
    private SheetProperty spTextfieldEvaluationTime;
    private ComboBoxSheetProperty spTextfieldEvaluationGroup;
    private SheetProperty spStretchWithOverflow;
    private SheetProperty spTextfieldBlankWhenNull;
    private PatternSheetProperty spPattern;
    private ExpressionSheetProperty spImageExpression;
    private SheetProperty spImageExpressionClass;
    private SheetProperty spImageEvaluationTime;
    private ComboBoxSheetProperty spImageEvaluationGroup;
    private SheetProperty spImageScale;
    private SheetProperty spImageError;
    private SheetProperty spImageHAlign;
    private SheetProperty spImageVAlign;
    private SheetProperty spImageLazy;
    private SheetProperty spImageCache;
    private SheetProperty spBCType;
    private SheetProperty spBCChecksum;
    private SheetProperty spBCShowText;
    private ExpressionSheetProperty spBCExpression;
    private SheetProperty spBCBarWidth;
    private SheetProperty spBCBarHeight;
    private ExpressionSheetProperty spBCApplicationIdentifier;
    private SheetProperty spBCScale;
    private SheetProperty spBCError;
    private SheetProperty spBCHAlign;
    private SheetProperty spBCVAlign;
    private SheetProperty spBCEvaluationTime;
    private ComboBoxSheetProperty spBCEvaluationGroup;
    private SheetProperty spChartEvaluationTime;
    private ComboBoxSheetProperty spChartEvaluationGroup;
    public static Color sharedDifferentValueLabelColor = Color.red.darker().darker();
    public static Color mandatoryPropertiesLabelColor = Color.blue;
    public static Color notMandatoryPropertiesLabelColor = Color.black;
    private JReportFrame jrf = null;
    private boolean init = false;
    private Vector elementSelection = new Vector();

    public ReportElementSheetPanel() {
        this.initSheetProperties();
        MainFrame mf = MainFrame.getMainInstance();
        mf.addReportListener(this);
        mf.addReportFrameActivatedListener(this);
        I18n.addOnLanguageChangedListener(this);
        MainFrame.getMainInstance().addFontsListChangedListener(new FontsListChangedListener(){

            public void fontsListChanged(FontsListChangedEvent evt) {
                boolean localinit = ReportElementSheetPanel.this.isInit();
                ReportElementSheetPanel.this.setInit(true);
                ReportElementSheetPanel.this.updateReportFonts();
                ReportElementSheetPanel.this.setInit(localinit);
            }
        });
    }

    public void reportFrameActivated(ReportFrameActivatedEvent evt) {
        if (evt.getReportFrame() == null) {
            this.updateSelection(evt.getReportFrame());
        }
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.removeAllProperties();
        this.initSheetProperties();
        this.updateSelection();
    }

    public void updateSelection() {
        JReportFrame newJrf = MainFrame.getMainInstance().getActiveReportFrame();
        this.updateSelection(newJrf);
    }

    public void applyValueForNumbers() {
        Enumeration e = this.getProperties().elements();
        while (e.hasMoreElements()) {
            JComponent c;
            SheetProperty sp = (SheetProperty)e.nextElement();
            if (sp.getType() != 6) {
                if (sp.getType() != 1) continue;
            }
            if (!(c = sp.getEditor()).hasFocus() || !(c instanceof JNumberField)) continue;
            ((JNumberField)c).focusLost(null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSelection(JReportFrame newJrf) {
        this.applyValueForNumbers();
        this.setInit(true);
        if (newJrf != null) {
            if (newJrf.getSelectedCrosstabEditorPanel() == null) {
                this.setElementSelection(newJrf.getSelectedElements());
            } else {
                this.setElementSelection(newJrf.getSelectedCrosstabEditorPanel().getSelectedElements());
            }
        } else {
            this.getElementSelection().removeAllElements();
        }
        this.removeAllProperties();
        this.jrf = newJrf;
        if (this.jrf == null || this.getElementSelection().size() == 0) {
            this.recreateSheet();
            return;
        }
        this.updateAllComboBoxes();
        try {
            Vector selectedElements = this.getElementSelection();
            boolean sameBand = true;
            boolean sameTop = true;
            boolean sameLeft = true;
            boolean sameWidth = true;
            boolean sameHeight = true;
            boolean sameForeground = true;
            boolean sameBackground = true;
            boolean sameMode = true;
            boolean samePrintRepeatedValues = true;
            boolean samePrintWhenDetailOverflows = true;
            boolean samePrintInFirstWholeBand = true;
            boolean sameRemoveLineWhenBlank = true;
            boolean samePositionType = true;
            boolean samePrintWhenGroupChanges = true;
            boolean sameStretchType = true;
            boolean sameStyle = true;
            boolean samePrintWhenExpression = true;
            boolean areAllGraphicsElements = true;
            boolean sameFill = true;
            boolean samePen = true;
            boolean areAllRectangleElements = true;
            boolean sameRadius = true;
            boolean areAllLineElements = true;
            boolean sameDirection = true;
            boolean areAllTextElements = true;
            boolean sameHAlign = true;
            boolean sameVAlign = true;
            boolean sameStyledText = true;
            boolean sameLineSpacing = true;
            boolean sameRotate = true;
            boolean sameBold = true;
            boolean sameItalic = true;
            boolean sameUnderline = true;
            boolean sameStrikethrough = true;
            boolean samePdfEmbedded = true;
            boolean sameFontSize = true;
            boolean sameFontName = true;
            boolean samePDFFontName = true;
            boolean samePdfEncoding = true;
            boolean areAllStaticTextElements = true;
            boolean sameText = true;
            boolean areAllTextfieldElements = true;
            boolean sameTextfieldExpression = true;
            boolean sameTextfieldExpressionClass = true;
            boolean sameTextfieldEvaluationTime = true;
            boolean sameTextfieldEvaluationGroup = true;
            boolean sameStrtchWithOverflow = true;
            boolean sameBlankWhenNull = true;
            boolean samePattern = true;
            boolean areAllImageElements = true;
            boolean sameImageExpression = true;
            boolean sameImageExpressionClass = true;
            boolean sameImageEvaluationTime = true;
            boolean sameImageEvaluationGroup = true;
            boolean sameImageLazy = true;
            boolean sameImageCache = true;
            boolean sameImageScale = true;
            boolean sameImageOnError = true;
            boolean sameImageVAlign = true;
            boolean sameImageHAlign = true;
            boolean areAllBarcodeElements = true;
            boolean sameBCType = true;
            boolean sameBCChecksum = true;
            boolean sameBCShowText = true;
            boolean sameBCExpression = true;
            boolean sameBCBarWidth = true;
            boolean sameBCBarHeight = true;
            boolean sameBCApplicationIdentifier = true;
            boolean sameBCScale = true;
            boolean sameBCError = true;
            boolean sameBCHAlign = true;
            boolean sameBCVAlign = true;
            boolean sameBCEvaluationTime = true;
            boolean sameBCEvaluationGroup = true;
            boolean areAllChartElements = true;
            boolean sameChartEvaluationTime = true;
            boolean sameChartEvaluationGroup = true;
            boolean isTheFirstElement = true;
            Band last_band = null;
            int y_location = 0;
            for (int i = 0; i < selectedElements.size(); ++i) {
                ReportElement re = (ReportElement)selectedElements.elementAt(i);
                if (re.getBand() != null && (last_band == null || last_band != re.getBand())) {
                    y_location = this.jrf.getReport().getBandYLocation(re.getBand());
                    last_band = re.getBand();
                }
                int x_location = this.jrf.getReport().getLeftMargin();
                if (re.getBand() == null && re.getCell() != null) {
                    y_location = re.getCell().getTop();
                    x_location = re.getCell().getLeft();
                }
                if (sameBand) {
                    sameBand = this.setComboBox(isTheFirstElement, re.getBand() == null ? re.getCell() : re.getBand(), (JComboBox)this.spBands.getEditor());
                }
                if (sameTop) {
                    int position_y = re.getPosition().y;
                    position_y = re.getParentElement() != null ? (position_y -= re.getParentElement().getPosition().y) : position_y - y_location - 10;
                    sameTop = this.setElementNumber(isTheFirstElement, position_y, (JNumberField)this.spTop.getEditor());
                }
                if (sameLeft) {
                    int position_x = re.getPosition().x;
                    position_x = re.getParentElement() != null ? (position_x -= re.getParentElement().getPosition().x) : position_x - 10 - x_location;
                    sameLeft = this.setElementNumber(isTheFirstElement, position_x, (JNumberField)this.spLeft.getEditor());
                }
                if (sameWidth) {
                    sameWidth = this.setElementNumber(isTheFirstElement, re.getWidth(), (JNumberField)this.spWidth.getEditor());
                }
                if (sameHeight) {
                    sameHeight = this.setElementNumber(isTheFirstElement, re.getHeight(), (JNumberField)this.spHeight.getEditor());
                }
                if (sameForeground) {
                    sameForeground = this.setColorProperty(isTheFirstElement, re.getColorValue("FGCOLOR", null), this.spFgColor);
                }
                if (sameBackground) {
                    sameBackground = this.setColorProperty(isTheFirstElement, re.getColorValue("BGCOLOR", null), this.spBgColor);
                }
                if (sameMode) {
                    sameMode = this.setCheckBox(isTheFirstElement, re.getTransparent().equals("Transparent"), re.getPropertyValue("MODE") == null, this.spMode);
                }
                if (samePrintRepeatedValues) {
                    samePrintRepeatedValues = this.setCheckBox(isTheFirstElement, re.isIsPrintRepeatedValues(), false, this.spPrintRepeatedValues);
                }
                if (samePrintWhenDetailOverflows) {
                    samePrintWhenDetailOverflows = this.setCheckBox(isTheFirstElement, re.isIsPrintWhenDetailOverflows(), false, this.spPrintWhenDetailOverflows);
                }
                if (samePrintInFirstWholeBand) {
                    samePrintInFirstWholeBand = this.setCheckBox(isTheFirstElement, re.isIsPrintInFirstWholeBand(), false, this.spPrintInFirstWholeBand);
                }
                if (sameRemoveLineWhenBlank) {
                    sameRemoveLineWhenBlank = this.setCheckBox(isTheFirstElement, re.isIsRemoveLineWhenBlank(), false, this.spRemoveLineWhenBlank);
                }
                if (samePositionType) {
                    samePositionType = this.setTagComboBox(isTheFirstElement, re.getPositionType(), this.spPositionType);
                }
                if (samePrintWhenGroupChanges) {
                    samePrintWhenGroupChanges = this.setTagComboBox(isTheFirstElement, re.getPrintWhenGroupChanges(), this.spGroups);
                }
                if (sameStretchType) {
                    sameStretchType = this.setTagComboBox(isTheFirstElement, re.getStretchType(), this.spStretchType);
                }
                if (sameStyle) {
                    sameStyle = this.setTagComboBox(isTheFirstElement, re.getStyle() == null ? "" : re.getStyle(), this.spStyle);
                }
                if (samePrintWhenExpression) {
                    samePrintWhenExpression = this.setTextArea(isTheFirstElement, re.getPrintWhenExpression(), this.spPrintWhenExpression);
                }
                if (i == 0) {
                    this.spElementKey.setValue(re.getKey());
                }
                if (areAllGraphicsElements && re instanceof GraphicReportElement) {
                    GraphicReportElement gre = (GraphicReportElement)re;
                    if (samePen) {
                        samePen = this.setTagComboBox(isTheFirstElement, re.getPropertyValue("PEN"), this.spPen);
                    }
                    if (sameFill) {
                        sameFill = this.setTagComboBox(isTheFirstElement, re.getPropertyValue("FILL"), this.spFill);
                    }
                } else {
                    areAllGraphicsElements = false;
                }
                if (areAllRectangleElements && re instanceof RectangleReportElement) {
                    RectangleReportElement rre = (RectangleReportElement)re;
                    if (sameRadius) {
                        sameRadius = this.setGenericSheetProperty(isTheFirstElement, rre.getPropertyValue("RADIUS"), this.spRadius);
                    }
                } else {
                    areAllRectangleElements = false;
                }
                if (areAllLineElements && re instanceof LineReportElement) {
                    LineReportElement rre = (LineReportElement)re;
                    if (sameDirection) {
                        sameDirection = this.setTagComboBox(isTheFirstElement, rre.getDirection(), this.spDirection);
                    }
                } else {
                    areAllLineElements = false;
                }
                if (areAllTextElements && re instanceof TextReportElement) {
                    TextReportElement rre = (TextReportElement)re;
                    if (sameHAlign) {
                        sameHAlign = this.setTagComboBox(isTheFirstElement, re.getPropertyValue(TextReportElement.ALIGN), this.spTextHAlign);
                    }
                    if (sameVAlign) {
                        sameVAlign = this.setTagComboBox(isTheFirstElement, re.getPropertyValue(TextReportElement.VERTICAL_ALIGN), this.spTextVAlign);
                    }
                    if (sameStyledText) {
                        sameStyledText = this.setCheckBox(isTheFirstElement, rre.isIsStyledText(), re.getPropertyValue(TextReportElement.IS_STYLED_TEXT) == null, this.spStyledText);
                    }
                    if (sameLineSpacing) {
                        sameLineSpacing = this.setTagComboBox(isTheFirstElement, re.getPropertyValue(TextReportElement.LINE_SPACING), this.spLineSpacing);
                    }
                    if (sameRotate) {
                        sameRotate = this.setTagComboBox(isTheFirstElement, re.getPropertyValue(TextReportElement.ROTATE), this.spRotate);
                    }
                    if (sameBold) {
                        sameBold = this.setCheckBox(isTheFirstElement, rre.isBold(), rre.getIReportFont().getPropertyValue("bold") == null, this.spBold);
                    }
                    if (sameItalic) {
                        sameItalic = this.setCheckBox(isTheFirstElement, rre.isItalic(), rre.getIReportFont().getPropertyValue("italic") == null, this.spItalic);
                    }
                    if (sameUnderline) {
                        sameUnderline = this.setCheckBox(isTheFirstElement, rre.isUnderline(), rre.getIReportFont().getPropertyValue("underline") == null, this.spUnderline);
                    }
                    if (sameStrikethrough) {
                        sameStrikethrough = this.setCheckBox(isTheFirstElement, rre.isStrikeTrought(), rre.getIReportFont().getPropertyValue("strikeTrought") == null, this.spStriketrough);
                    }
                    if (samePdfEmbedded) {
                        samePdfEmbedded = this.setCheckBox(isTheFirstElement, rre.isPdfEmbedded(), rre.getIReportFont().getPropertyValue("pdfEmbedded") == null, this.spPdfEmbedded);
                    }
                    if (sameFontSize) {
                        sameFontSize = this.setElementNumber(isTheFirstElement, rre.getFontSize(), rre.getIReportFont().getPropertyValue("fontSize"), this.spFontSize);
                    }
                    if (sameFontName) {
                        sameFontName = this.setTagComboBox(isTheFirstElement, rre.getIReportFont().getPropertyValue("fontName"), this.spFontName);
                    }
                    if (samePDFFontName) {
                        samePDFFontName = this.setTagComboBox(isTheFirstElement, rre.getIReportFont().getPropertyValue("PDFFontName"), this.spPdfFontName);
                    }
                    if (samePdfEncoding) {
                        samePdfEncoding = this.setTagComboBox(isTheFirstElement, rre.getIReportFont().getPropertyValue("pdfEncoding"), this.spPdfEncoding);
                    }
                } else {
                    areAllTextElements = false;
                }
                if (areAllStaticTextElements && re instanceof StaticTextReportElement) {
                    StaticTextReportElement rre = (StaticTextReportElement)re;
                    if (sameText) {
                        sameText = this.setTextArea(isTheFirstElement, rre.getText(), this.spStaticText);
                    }
                } else {
                    areAllStaticTextElements = false;
                }
                if (areAllTextfieldElements && re instanceof TextFieldReportElement) {
                    TextFieldReportElement rre = (TextFieldReportElement)re;
                    if (sameTextfieldExpression) {
                        sameTextfieldExpression = this.setTextArea(isTheFirstElement, rre.getText(), this.spTextfieldExpression);
                    }
                    if (sameTextfieldExpressionClass) {
                        sameTextfieldExpressionClass = this.setTagComboBox(isTheFirstElement, rre.getClassExpression(), this.spTextfieldExpressionClass);
                    }
                    if (sameTextfieldEvaluationTime) {
                        sameTextfieldEvaluationTime = this.setTagComboBox(isTheFirstElement, rre.getEvaluationTime(), this.spTextfieldEvaluationTime);
                    }
                    if (sameTextfieldEvaluationGroup && sameTextfieldEvaluationTime) {
                        sameTextfieldEvaluationGroup = this.setTagComboBox(isTheFirstElement, rre.getGroup(), this.spTextfieldEvaluationGroup);
                    }
                    if (sameStrtchWithOverflow) {
                        sameStrtchWithOverflow = this.setCheckBox(isTheFirstElement, rre.isStretchWithOverflow(), false, this.spStretchWithOverflow);
                    }
                    if (sameBlankWhenNull) {
                        sameBlankWhenNull = this.setCheckBox(isTheFirstElement, rre.isBlankWhenNull(), false, this.spTextfieldBlankWhenNull);
                    }
                    if (samePattern) {
                        samePattern = this.setTextPattern(isTheFirstElement, re.getPropertyValue("PATTERN"), this.spPattern);
                    }
                } else {
                    areAllTextfieldElements = false;
                }
                if (areAllImageElements && re instanceof ImageReportElement && !(re instanceof BarcodeReportElement)) {
                    ImageReportElement rre = (ImageReportElement)re;
                    if (sameImageExpression) {
                        sameImageExpression = this.setTextArea(isTheFirstElement, rre.getImageExpression(), this.spImageExpression);
                    }
                    if (sameImageExpressionClass) {
                        sameImageExpressionClass = this.setTagComboBox(isTheFirstElement, rre.getImageClass(), this.spImageExpressionClass);
                    }
                    if (sameImageEvaluationTime) {
                        sameImageEvaluationTime = this.setTagComboBox(isTheFirstElement, rre.getEvaluationTime(), this.spImageEvaluationTime);
                    }
                    if (sameImageEvaluationGroup && sameImageEvaluationTime) {
                        sameImageEvaluationGroup = this.setTagComboBox(isTheFirstElement, rre.getEvaluationGroup(), this.spImageEvaluationGroup);
                    }
                    if (sameImageLazy) {
                        sameImageLazy = this.setCheckBox(isTheFirstElement, rre.isIsLazy(), false, this.spImageLazy);
                    }
                    if (sameImageScale) {
                        sameImageScale = this.setTagComboBox(isTheFirstElement, re.getPropertyValue("SCALE"), this.spImageScale);
                    }
                    if (sameImageCache) {
                        sameImageCache = this.setCheckBox(isTheFirstElement, rre.isIsUsingCache(), rre.getPropertyValue("USING_CACHE") == null, this.spImageCache);
                    }
                    if (sameImageVAlign) {
                        sameImageVAlign = this.setTagComboBox(isTheFirstElement, re.getPropertyValue("VERTICAL_ALIGN"), this.spImageVAlign);
                    }
                    if (sameImageHAlign) {
                        sameImageHAlign = this.setTagComboBox(isTheFirstElement, re.getPropertyValue("HORIZONTAL_ALIGN"), this.spImageHAlign);
                    }
                } else {
                    areAllImageElements = false;
                }
                if (areAllBarcodeElements && re instanceof BarcodeReportElement) {
                    BarcodeReportElement rre = (BarcodeReportElement)re;
                    if (sameBCType) {
                        sameBCType = this.setTagComboBox(isTheFirstElement, rre.getType() + "", this.spBCType);
                    }
                    if (sameBCBarWidth) {
                        sameBCBarWidth = this.setGenericSheetProperty(isTheFirstElement, "" + rre.getImageWidth(), this.spBCBarWidth);
                    }
                    if (sameBCBarHeight) {
                        sameBCBarHeight = this.setGenericSheetProperty(isTheFirstElement, "" + rre.getImageHeight(), this.spBCBarHeight);
                    }
                    if (sameBCExpression) {
                        sameBCExpression = this.setTextArea(isTheFirstElement, rre.getText(), this.spBCExpression);
                    }
                    if (sameBCApplicationIdentifier) {
                        sameBCApplicationIdentifier = this.setTextArea(isTheFirstElement, rre.getApplicationIdentifier(), this.spBCApplicationIdentifier);
                    }
                    if (sameBCEvaluationTime) {
                        sameBCEvaluationTime = this.setTagComboBox(isTheFirstElement, rre.getEvaluationTime(), this.spBCEvaluationTime);
                    }
                    if (sameBCEvaluationGroup && sameBCEvaluationTime) {
                        sameBCEvaluationGroup = this.setTagComboBox(isTheFirstElement, rre.getEvaluationGroup(), this.spBCEvaluationGroup);
                    }
                    if (sameBCShowText) {
                        sameBCShowText = this.setCheckBox(isTheFirstElement, rre.isShowText(), false, this.spBCShowText);
                    }
                    if (sameBCChecksum) {
                        sameBCChecksum = this.setCheckBox(isTheFirstElement, rre.isCheckSum(), false, this.spBCChecksum);
                    }
                    if (sameBCScale) {
                        sameBCScale = this.setTagComboBox(isTheFirstElement, re.getPropertyValue("SCALE"), this.spBCScale);
                    }
                    if (sameBCVAlign) {
                        sameBCVAlign = this.setTagComboBox(isTheFirstElement, re.getPropertyValue("VERTICAL_ALIGN"), this.spBCVAlign);
                    }
                    if (sameBCHAlign) {
                        sameBCHAlign = this.setTagComboBox(isTheFirstElement, re.getPropertyValue("HORIZONTAL_ALIGN"), this.spBCHAlign);
                    }
                } else {
                    areAllBarcodeElements = false;
                }
                if (areAllChartElements && re instanceof ChartReportElement2) {
                    ChartReportElement2 rre = (ChartReportElement2)re;
                    if (sameChartEvaluationTime) {
                        sameChartEvaluationTime = this.setTagComboBox(isTheFirstElement, rre.getEvaluationTime(), this.spChartEvaluationTime);
                    }
                    if (sameChartEvaluationGroup && sameChartEvaluationTime) {
                        sameChartEvaluationGroup = this.setTagComboBox(isTheFirstElement, rre.getEvaluationGroup(), this.spChartEvaluationGroup);
                    }
                } else {
                    areAllChartElements = false;
                }
                if (sameBand) {
                    sameBand = this.setComboBox(isTheFirstElement, re.getBand() == null ? re.getCell() : re.getBand(), (JComboBox)this.spBands.getEditor());
                }
                isTheFirstElement = false;
            }
            this.spBands.setLabelColor(sameBand ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spTop.setLabelColor(sameTop ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spLeft.setLabelColor(sameLeft ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spHeight.setLabelColor(sameHeight ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spWidth.setLabelColor(sameWidth ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spFgColor.setLabelColor(sameForeground ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spBgColor.setLabelColor(sameBackground ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spMode.setLabelColor(sameMode ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spPrintRepeatedValues.setLabelColor(samePrintRepeatedValues ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spPrintWhenDetailOverflows.setLabelColor(samePrintWhenDetailOverflows ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spPrintInFirstWholeBand.setLabelColor(samePrintInFirstWholeBand ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spRemoveLineWhenBlank.setLabelColor(sameRemoveLineWhenBlank ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spPositionType.setLabelColor(samePositionType ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spGroups.setLabelColor(samePrintWhenGroupChanges ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spStretchType.setLabelColor(sameStretchType ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spStyle.setLabelColor(sameStyle ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spPrintWhenExpression.setLabelColor(samePrintWhenExpression ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spPen.setLabelColor(samePen ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spFill.setLabelColor(sameFill ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spRadius.setLabelColor(sameRadius ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spDirection.setLabelColor(sameDirection ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spTextHAlign.setLabelColor(sameHAlign ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spTextVAlign.setLabelColor(sameVAlign ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spStyledText.setLabelColor(sameStyledText ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spLineSpacing.setLabelColor(sameLineSpacing ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spRotate.setLabelColor(sameRotate ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spBold.setLabelColor(sameBold ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spItalic.setLabelColor(sameItalic ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spUnderline.setLabelColor(sameUnderline ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spStriketrough.setLabelColor(sameStrikethrough ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spPdfEmbedded.setLabelColor(samePdfEmbedded ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spFontSize.setLabelColor(sameFontSize ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spFontName.setLabelColor(sameFontName ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spPdfFontName.setLabelColor(samePDFFontName ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spPdfEncoding.setLabelColor(samePdfEncoding ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spStaticText.setLabelColor(sameText ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spTextfieldExpression.setLabelColor(sameTextfieldExpression ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spTextfieldExpressionClass.setLabelColor(sameTextfieldExpressionClass ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spTextfieldEvaluationTime.setLabelColor(sameTextfieldEvaluationTime ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spTextfieldEvaluationGroup.setLabelColor(sameTextfieldEvaluationGroup ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spStretchWithOverflow.setLabelColor(sameStrtchWithOverflow ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spTextfieldBlankWhenNull.setLabelColor(sameBlankWhenNull ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spPattern.setLabelColor(sameBlankWhenNull ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spImageExpression.setLabelColor(sameImageExpression ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spImageExpressionClass.setLabelColor(sameImageExpressionClass ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spImageEvaluationTime.setLabelColor(sameImageEvaluationTime ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spImageEvaluationGroup.setLabelColor(sameImageEvaluationGroup ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spImageLazy.setLabelColor(sameImageLazy ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spImageCache.setLabelColor(sameImageCache ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spImageScale.setLabelColor(sameImageScale ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spImageError.setLabelColor(sameImageOnError ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spImageVAlign.setLabelColor(sameImageVAlign ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spImageHAlign.setLabelColor(sameImageHAlign ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spBCType.setLabelColor(sameBCType ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spBCChecksum.setLabelColor(sameBCChecksum ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spBCShowText.setLabelColor(sameBCShowText ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spBCExpression.setLabelColor(sameBCExpression ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spBCBarWidth.setLabelColor(sameBCBarWidth ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spBCBarHeight.setLabelColor(sameBCBarHeight ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spBCApplicationIdentifier.setLabelColor(sameBCApplicationIdentifier ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spBCScale.setLabelColor(sameBCScale ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spBCError.setLabelColor(sameBCError ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spBCHAlign.setLabelColor(sameBCHAlign ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spBCVAlign.setLabelColor(sameBCVAlign ? notMandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spBCEvaluationTime.setLabelColor(sameBCEvaluationTime ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spBCEvaluationGroup.setLabelColor(sameBCEvaluationGroup ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spChartEvaluationTime.setLabelColor(sameChartEvaluationTime ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            this.spChartEvaluationGroup.setLabelColor(sameChartEvaluationGroup ? mandatoryPropertiesLabelColor : sharedDifferentValueLabelColor);
            ExpressionContext ec = new ExpressionContext();
            if (this.jrf.getSelectedCrosstabEditorPanel() == null) {
                ec.setSubDataset(this.jrf.getReport());
            } else {
                ec.addCrosstabReportElement(this.jrf.getSelectedCrosstabEditorPanel().getCrosstabElement());
            }
            this.spPrintWhenExpression.setExpressionContext(ec);
            this.spTextfieldExpression.setExpressionContext(ec);
            this.spImageExpression.setExpressionContext(ec);
            this.spBCExpression.setExpressionContext(ec);
            this.spBCApplicationIdentifier.setExpressionContext(ec);
            String commonStr = I18n.getString("gui.elementpropertiessheet.common", "Common");
            this.addSheetProperty(commonStr, this.spBands);
            this.addSheetProperty(commonStr, this.spTop);
            this.addSheetProperty(commonStr, this.spLeft);
            this.addSheetProperty(commonStr, this.spHeight);
            this.addSheetProperty(commonStr, this.spWidth);
            this.addSheetProperty(commonStr, this.spFgColor);
            this.addSheetProperty(commonStr, this.spBgColor);
            this.addSheetProperty(commonStr, this.spMode);
            this.spPrintRepeatedValues.setDefaultValue(new Boolean(true));
            this.addSheetProperty(commonStr, this.spRemoveLineWhenBlank);
            this.addSheetProperty(commonStr, this.spPrintInFirstWholeBand);
            this.addSheetProperty(commonStr, this.spPrintWhenDetailOverflows);
            this.addSheetProperty(commonStr, this.spPrintRepeatedValues);
            this.addSheetProperty(commonStr, this.spPositionType);
            this.addSheetProperty(commonStr, this.spGroups);
            if (selectedElements.size() == 1) {
                this.addSheetProperty(commonStr, this.spElementKey);
            }
            this.addSheetProperty(commonStr, this.spStretchType);
            this.addSheetProperty(commonStr, this.spStyle);
            this.addSheetProperty(commonStr, this.spPrintWhenExpression);
            if (areAllGraphicsElements) {
                String graphicStr = I18n.getString("gui.elementpropertiessheet.graphic", "Graphic");
                this.addSheetProperty(graphicStr, this.spPen);
                this.addSheetProperty(graphicStr, this.spFill);
            }
            if (areAllRectangleElements) {
                String rectangleStr = I18n.getString("gui.elementpropertiessheet.rectangle", "Rectangle");
                this.addSheetProperty(rectangleStr, this.spRadius);
            }
            if (areAllLineElements) {
                String lineStr = I18n.getString("gui.elementpropertiessheet.line", "Line");
                this.addSheetProperty(lineStr, this.spDirection);
            }
            if (areAllTextElements) {
                String textStr = I18n.getString("gui.elementpropertiessheet.text", "Text");
                this.addSheetProperty(textStr, this.spFontName);
                this.addSheetProperty(textStr, this.spFontSize);
                this.addSheetProperty(textStr, this.spBold);
                this.addSheetProperty(textStr, this.spItalic);
                this.addSheetProperty(textStr, this.spUnderline);
                this.addSheetProperty(textStr, this.spStriketrough);
                this.addSheetProperty(textStr, this.spPdfFontName);
                this.addSheetProperty(textStr, this.spPdfEmbedded);
                this.addSheetProperty(textStr, this.spPdfEncoding);
                this.addSheetProperty(textStr, this.spTextHAlign);
                this.addSheetProperty(textStr, this.spTextVAlign);
                this.addSheetProperty(textStr, this.spLineSpacing);
                this.addSheetProperty(textStr, this.spRotate);
                this.addSheetProperty(textStr, this.spStyledText);
            }
            if (areAllStaticTextElements) {
                String staticTextStr = I18n.getString("gui.elementpropertiessheet.staticText", "Static text");
                this.addSheetProperty(staticTextStr, this.spStaticText);
            }
            if (areAllTextfieldElements) {
                String textFieldStr = I18n.getString("gui.elementpropertiessheet.textField", "Textfield");
                this.addSheetProperty(textFieldStr, this.spTextfieldExpression);
                this.addSheetProperty(textFieldStr, this.spTextfieldExpressionClass);
                this.addSheetProperty(textFieldStr, this.spTextfieldEvaluationTime);
                this.addSheetProperty(textFieldStr, this.spTextfieldEvaluationGroup);
                this.addSheetProperty(textFieldStr, this.spStretchWithOverflow);
                this.addSheetProperty(textFieldStr, this.spTextfieldBlankWhenNull);
                this.addSheetProperty(textFieldStr, this.spPattern);
                if (!sameTextfieldEvaluationTime || !this.spTextfieldEvaluationTime.getValue().equals("Group")) {
                    this.spTextfieldEvaluationGroup.setReadOnly(true);
                } else {
                    this.spTextfieldEvaluationGroup.setReadOnly(false);
                }
            }
            if (areAllImageElements) {
                String imageStr = I18n.getString("gui.elementpropertiessheet.image", "Image");
                this.addSheetProperty(imageStr, this.spImageExpression);
                this.addSheetProperty(imageStr, this.spImageExpressionClass);
                this.addSheetProperty(imageStr, this.spImageEvaluationTime);
                this.addSheetProperty(imageStr, this.spImageEvaluationGroup);
                this.addSheetProperty(imageStr, this.spImageScale);
                this.addSheetProperty(imageStr, this.spImageError);
                this.addSheetProperty(imageStr, this.spImageVAlign);
                this.addSheetProperty(imageStr, this.spImageHAlign);
                this.addSheetProperty(imageStr, this.spImageLazy);
                this.addSheetProperty(imageStr, this.spImageCache);
                if (!sameImageEvaluationTime || !this.spImageEvaluationTime.getValue().equals("Group")) {
                    this.spImageEvaluationGroup.setReadOnly(true);
                } else {
                    this.spImageEvaluationGroup.setReadOnly(false);
                }
            }
            if (areAllBarcodeElements) {
                String barcodeStr = I18n.getString("gui.elementpropertiessheet.barcode", "Barcode");
                this.addSheetProperty(barcodeStr, this.spBCType);
                this.addSheetProperty(barcodeStr, this.spBCChecksum);
                this.addSheetProperty(barcodeStr, this.spBCShowText);
                this.addSheetProperty(barcodeStr, this.spBCExpression);
                this.addSheetProperty(barcodeStr, this.spBCBarWidth);
                this.addSheetProperty(barcodeStr, this.spBCBarHeight);
                this.addSheetProperty(barcodeStr, this.spBCApplicationIdentifier);
                this.addSheetProperty(barcodeStr, this.spBCScale);
                this.addSheetProperty(barcodeStr, this.spBCError);
                this.addSheetProperty(barcodeStr, this.spBCHAlign);
                this.addSheetProperty(barcodeStr, this.spBCVAlign);
                this.addSheetProperty(barcodeStr, this.spBCEvaluationTime);
                this.addSheetProperty(barcodeStr, this.spBCEvaluationGroup);
                if (!sameBCEvaluationTime || !this.spBCEvaluationTime.getValue().equals("Group")) {
                    this.spBCEvaluationGroup.setReadOnly(true);
                } else {
                    this.spBCEvaluationGroup.setReadOnly(false);
                }
            }
            if (areAllChartElements) {
                String chartStr = I18n.getString("gui.elementpropertiessheet.chart", "Chart");
                this.addSheetProperty(chartStr, this.spChartEvaluationTime);
                this.addSheetProperty(chartStr, this.spChartEvaluationGroup);
                if (!sameChartEvaluationTime || !this.spChartEvaluationTime.getValue().equals("Group")) {
                    this.spChartEvaluationGroup.setReadOnly(true);
                } else {
                    this.spChartEvaluationGroup.setReadOnly(false);
                }
            }
            this.recreateSheet();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setInit(false);
    }

    public void removeNullItem(SheetProperty comboProperty) {
        Object obj;
        JComboBox combobox;
        if (comboProperty == null) {
            return;
        }
        if (comboProperty.getEditor() instanceof JComboBox && (combobox = (JComboBox)comboProperty.getEditor()).getSelectedIndex() > 0 && ((obj = combobox.getItemAt(0)) + "").equals(I18n.getString("gui.elementpropertiessheet.differentValues", "<different values>"))) {
            combobox.removeItemAt(0);
        }
    }

    public boolean isNullItem(SheetProperty comboProperty) {
        Object obj;
        JComboBox combobox;
        if (comboProperty == null) {
            return false;
        }
        return comboProperty.getEditor() instanceof JComboBox && (combobox = (JComboBox)comboProperty.getEditor()).getSelectedIndex() == 0 && ((obj = combobox.getItemAt(0)) + "").equals(I18n.getString("gui.elementpropertiessheet.differentValues", "<different values>"));
    }

    public void sheetPropertyValueChanged(SheetPropertyValueChangedEvent evt) {
        if (this.isInit()) {
            return;
        }
        if (this.isNullItem((SheetProperty)evt.getSource())) {
            return;
        }
        this.removeNullItem((SheetProperty)evt.getSource());
        Vector selectedElements = this.getElementSelection();
        for (int i = 0; i < selectedElements.size(); ++i) {
            ReportElement re = (ReportElement)selectedElements.elementAt(i);
            this.applyNewProperty(re, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
        this.repaintEditor();
        ReportElementChangedEvent changedEvent = new ReportElementChangedEvent(this.jrf, selectedElements, 3);
        changedEvent.setEventSource(this);
        if (evt.getPropertyName().equals("textfieldEvaluationTime")) {
            changedEvent.setPropertyChanged(evt.getPropertyName());
            changedEvent.setNewValue(evt.getNewValue());
        }
        this.jrf.fireReportListenerReportElementsChanged(changedEvent);
        MainFrame.getMainInstance().getElementPropertiesDialog().updateSelection();
    }

    private void applyNewProperty(ReportElement re, String propertyName, Object oldValue, Object newValue) {
        if (propertyName == null) {
            return;
        }
        if (this.isInit()) {
            return;
        }
        if (propertyName.equals("band")) {
            if (newValue != null && newValue instanceof Band) {
                re.setBand((Band)newValue);
            } else if (newValue != null && newValue instanceof CrosstabCell) {
                re.setCell((CrosstabCell)newValue);
            }
        } else if (propertyName.equals("top")) {
            if (newValue != null && !newValue.equals("")) {
                int val = Integer.parseInt("" + newValue);
                int y_location = 0;
                if (re.getBand() != null) {
                    y_location = this.jrf.getReport().getBandYLocation(re.getBand());
                }
                if (re.getBand() == null && re.getCell() != null) {
                    y_location = re.getCell().getTop();
                }
                if (re.getParentElement() != null) {
                    y_location = (int)re.getParentElement().getPosition().getY() - 10;
                }
                re.trasform(new Point(0, val - (re.getPosition().y - 10 - y_location)), TransformationType.TRANSFORMATION_MOVE);
            }
        } else if (propertyName.equals("left")) {
            if (newValue != null && !newValue.equals("")) {
                int val = Integer.parseInt("" + newValue);
                int normalization = 0;
                normalization = re.getParentElement() != null ? (int)re.getParentElement().getPosition().getX() - 10 : (re.getCell() != null ? re.getCell().getLeft() : this.jrf.getReport().getLeftMargin());
                re.trasform(new Point(val - (re.getPosition().x - 10 - normalization), 0), TransformationType.TRANSFORMATION_MOVE);
            }
        } else if (propertyName.equals("width")) {
            if (newValue != null && !newValue.equals("")) {
                int val = Integer.parseInt("" + newValue);
                re.trasform(new Point(val - re.getWidth(), 0), TransformationType.TRANSFORMATION_RESIZE_E);
            }
        } else if (propertyName.equals("height")) {
            if (newValue != null && !newValue.equals("")) {
                int val = Integer.parseInt("" + newValue);
                re.trasform(new Point(0, val - re.getHeight()), TransformationType.TRANSFORMATION_RESIZE_S);
            }
        } else if (propertyName.equals("fgcolor")) {
            re.setPropertyValue("FGCOLOR", ColorSelectorPanel.parseColorString((String)newValue));
        } else if (propertyName.equals("bgcolor")) {
            re.setPropertyValue("BGCOLOR", ColorSelectorPanel.parseColorString((String)newValue));
        } else if (propertyName.equals("mode")) {
            if (newValue == null) {
                re.setPropertyValue("MODE", null);
            } else {
                re.setPropertyValue("MODE", (newValue + "").equals("true") ? "Transparent" : "Opaque");
            }
        } else if (propertyName.equals("printRepeatedValues")) {
            if (newValue == null) {
                re.setPropertyValue("PRINT_REPEATED_VALUES", null);
            } else {
                re.setPropertyValue("PRINT_REPEATED_VALUES", newValue + "");
            }
        } else if (propertyName.equals("printWhenDetailOverflows")) {
            if (newValue == null) {
                re.setPropertyValue("PRINT_WHEN_DETAIL_OVERFLOW", null);
            } else {
                re.setPropertyValue("PRINT_WHEN_DETAIL_OVERFLOW", newValue + "");
            }
        } else if (propertyName.equals("printInFirstWholeBand")) {
            if (newValue == null) {
                re.setPropertyValue("DEFAULT_PRINT_IN_FIRST_WHOLE_BAND", null);
            } else {
                re.setPropertyValue("DEFAULT_PRINT_IN_FIRST_WHOLE_BAND", newValue + "");
            }
        } else if (propertyName.equals("removeLineWhenBlank")) {
            if (newValue == null) {
                re.setPropertyValue("REMOVE_LINE_WHEN_BLANK", null);
            } else {
                re.setPropertyValue("REMOVE_LINE_WHEN_BLANK", newValue + "");
            }
        } else if (propertyName.equals("positionType")) {
            if (newValue == null) {
                re.setPropertyValue("POSITION_TYPE", null);
            } else {
                re.setPropertyValue("POSITION_TYPE", newValue + "");
            }
        } else if (propertyName.equals("printWhenGroupChanges")) {
            if (newValue != null) {
                re.setPrintWhenGroupChanges("" + newValue);
            }
        } else if (propertyName.equals("stretchType")) {
            if (newValue != null) {
                re.setStretchType("" + newValue);
            }
        } else if (propertyName.equals("style")) {
            if ((newValue + "").equals("")) {
                newValue = null;
            }
            re.setStyle((Style)newValue);
        } else if (propertyName.equals("printWhenExpression")) {
            if (newValue != null) {
                re.setPrintWhenExpression("" + newValue);
            }
        } else if (propertyName.equals("pen")) {
            if ((newValue + "").equals("")) {
                newValue = null;
            }
            re.setPropertyValue("PEN", newValue);
        } else if (propertyName.equals("fill")) {
            if ((newValue + "").equals("")) {
                newValue = null;
            }
            re.setPropertyValue("FILL", newValue);
        } else if (propertyName.equals("radius")) {
            if (newValue != null) {
                try {
                    newValue = "" + (int)Double.parseDouble("" + newValue);
                }
                catch (Exception ex) {
                    newValue = null;
                }
            }
            re.setPropertyValue("RADIUS", newValue);
        } else if (propertyName.equals("direction")) {
            if (newValue != null) {
                ((LineReportElement)re).setDirection("" + newValue);
            }
        } else if (propertyName.equals("hAlign")) {
            TextReportElement cfr_ignored_0 = (TextReportElement)re;
            re.setPropertyValue(TextReportElement.ALIGN, newValue);
        } else if (propertyName.equals("vAlign")) {
            TextReportElement cfr_ignored_1 = (TextReportElement)re;
            re.setPropertyValue(TextReportElement.VERTICAL_ALIGN, newValue);
        } else if (propertyName.equals("styledText")) {
            if (newValue == null) {
                TextReportElement cfr_ignored_2 = (TextReportElement)re;
                re.setPropertyValue(TextReportElement.IS_STYLED_TEXT, null);
            } else {
                TextReportElement cfr_ignored_3 = (TextReportElement)re;
                re.setPropertyValue(TextReportElement.IS_STYLED_TEXT, newValue + "");
            }
        } else if (propertyName.equals("lineSpacing")) {
            TextReportElement cfr_ignored_4 = (TextReportElement)re;
            re.setPropertyValue(TextReportElement.LINE_SPACING, newValue);
        } else if (propertyName.equals("rotate")) {
            TextReportElement cfr_ignored_5 = (TextReportElement)re;
            re.setPropertyValue(TextReportElement.ROTATE, newValue);
        } else if (propertyName.equals("bold")) {
            ((TextReportElement)re).getIReportFont().setPropertyValue("bold", newValue == null ? null : "" + newValue);
        } else if (propertyName.equals("italic")) {
            ((TextReportElement)re).getIReportFont().setPropertyValue("italic", newValue == null ? null : "" + newValue);
        } else if (propertyName.equals("underline")) {
            ((TextReportElement)re).getIReportFont().setPropertyValue("underline", newValue == null ? null : "" + newValue);
        } else if (propertyName.equals("strikethrough")) {
            ((TextReportElement)re).getIReportFont().setPropertyValue("strikeTrought", newValue == null ? null : "" + newValue);
        } else if (propertyName.equals("pdfEmbedded")) {
            ((TextReportElement)re).getIReportFont().setPropertyValue("pdfEmbedded", newValue == null ? null : "" + newValue);
        } else if (propertyName.equals("fontSize")) {
            try {
                if (newValue == null || Integer.parseInt("" + newValue) != ((TextReportElement)re).getFontSize()) {
                    ((TextReportElement)re).getIReportFont().setPropertyValue("fontSize", newValue == null ? null : "" + newValue);
                }
            }
            catch (Exception ex) {}
        } else if (propertyName.equals("fontName")) {
            ((TextReportElement)re).getIReportFont().setPropertyValue("fontName", newValue == null ? null : "" + newValue);
        } else if (propertyName.equals("pdfFontName")) {
            ((TextReportElement)re).getIReportFont().setPropertyValue("PDFFontName", newValue == null ? null : "" + newValue);
        } else if (propertyName.equals("pdfEncoding")) {
            ((TextReportElement)re).getIReportFont().setPropertyValue("pdfEncoding", newValue == null ? null : "" + newValue);
        } else if (propertyName.equals("text")) {
            ((TextReportElement)re).setText(newValue == null ? "" : "" + newValue);
        } else if (propertyName.equals("textfieldExpression")) {
            ((TextReportElement)re).setText(newValue == null ? "" : "" + newValue);
        } else if (propertyName.equals("textfieldExpressionClass")) {
            ((TextFieldReportElement)re).setClassExpression(newValue == null ? "" : "" + newValue);
        } else if (propertyName.equals("textfieldEvaluationTime")) {
            ((TextFieldReportElement)re).setEvaluationTime(newValue == null ? "" : "" + newValue);
            if (newValue != null && newValue.equals("Group")) {
                this.spTextfieldEvaluationGroup.setReadOnly(false);
                ((TextFieldReportElement)re).setGroup(this.spTextfieldEvaluationGroup.getValue() + "");
            } else {
                this.spTextfieldEvaluationGroup.setReadOnly(true);
                ((TextFieldReportElement)re).setGroup("");
            }
            this.spTextfieldEvaluationGroup.updateLabel();
        } else if (propertyName.equals("textfieldEvaluationGroup")) {
            ((TextFieldReportElement)re).setGroup(newValue == null ? "" : "" + newValue);
        } else if (propertyName.equals("blankWhenNull")) {
            try {
                ((TextFieldReportElement)re).setBlankWhenNull(Boolean.valueOf(newValue + ""));
            }
            catch (Exception ex) {}
        } else if (propertyName.equals("stretchWithOverflow")) {
            try {
                ((TextFieldReportElement)re).setStretchWithOverflow(Boolean.valueOf(newValue + ""));
            }
            catch (Exception ex) {}
        } else if (propertyName.equals("pattern")) {
            if ((newValue + "").equals("")) {
                newValue = null;
            }
            re.setPropertyValue("PATTERN", newValue);
        } else if (propertyName.equals("imageExpression")) {
            ((ImageReportElement)re).setImageExpression(newValue == null ? "" : "" + newValue);
        } else if (propertyName.equals("imageExpressionClass")) {
            ((ImageReportElement)re).setImageClass(newValue == null ? "" : "" + newValue);
        } else if (propertyName.equals("imageEvaluationTime")) {
            ((ImageReportElement)re).setEvaluationTime(newValue == null ? "" : "" + newValue);
            if (newValue != null && newValue.equals("Group")) {
                this.spImageEvaluationGroup.setReadOnly(false);
                ((ImageReportElement)re).setEvaluationGroup(this.spImageEvaluationGroup.getValue() + "");
            } else {
                this.spImageEvaluationGroup.setReadOnly(true);
                ((ImageReportElement)re).setEvaluationGroup("");
            }
            this.spImageEvaluationGroup.updateLabel();
        } else if (propertyName.equals("imageEvaluationGroup")) {
            ((ImageReportElement)re).setEvaluationGroup(newValue == null ? "" : "" + newValue);
        } else if (propertyName.equals("imageLazy")) {
            try {
                ((ImageReportElement)re).setIsLazy(Boolean.valueOf(newValue + ""));
            }
            catch (Exception ex) {}
        } else if (propertyName.equals("imageCache")) {
            re.setPropertyValue("USING_CACHE", newValue);
        } else if (propertyName.equals("imageScale")) {
            re.setPropertyValue("SCALE", newValue);
        } else if (propertyName.equals("imageError")) {
            ((ImageReportElement)re).setOnErrorType("" + newValue);
        } else if (propertyName.equals("imageVAlign")) {
            re.setPropertyValue("VERTICAL_ALIGN", newValue);
        } else if (propertyName.equals("imageHAlign")) {
            re.setPropertyValue("HORIZONTAL_ALIGN", newValue);
        } else if (propertyName.equals("barcodeType")) {
            System.out.println("Setting barcode type to" + newValue);
            ((BarcodeReportElement)re).setType(Integer.parseInt(newValue == null ? "13" : "" + newValue));
            ((BarcodeReportElement)re).update();
        } else if (propertyName.equals("barcodeBarWidth")) {
            ((BarcodeReportElement)re).setImageWidth(Integer.parseInt(newValue == null ? "1" : "" + newValue));
        } else if (propertyName.equals("barcodeBarHeight")) {
            ((BarcodeReportElement)re).setImageHeight(Integer.parseInt(newValue == null ? "1" : "" + newValue));
        } else if (propertyName.equals("barcodeExpression")) {
            ((BarcodeReportElement)re).setText(newValue == null ? "" : "" + newValue);
        } else if (propertyName.equals("barcodeAppIdentifierExpression")) {
            ((BarcodeReportElement)re).setApplicationIdentifier(newValue == null ? "" : "" + newValue);
        } else if (propertyName.equals("barcodeEvaluationTime")) {
            ((ImageReportElement)re).setEvaluationTime(newValue == null ? "" : "" + newValue);
            if (newValue != null && newValue.equals("Group")) {
                this.spBCEvaluationGroup.setReadOnly(false);
                ((ImageReportElement)re).setEvaluationGroup(this.spBCEvaluationGroup.getValue() + "");
            } else {
                this.spBCEvaluationGroup.setReadOnly(true);
                ((ImageReportElement)re).setEvaluationGroup("");
            }
            this.spBCEvaluationGroup.updateLabel();
        } else if (propertyName.equals("barcodeEvaluationGroup")) {
            ((ImageReportElement)re).setEvaluationGroup(newValue == null ? "" : "" + newValue);
        } else if (propertyName.equals("barcodeShowText")) {
            try {
                ((BarcodeReportElement)re).setShowText(Boolean.valueOf(newValue + ""));
            }
            catch (Exception ex) {}
        } else if (propertyName.equals("barcodeChecksum")) {
            try {
                ((BarcodeReportElement)re).setCheckSum(Boolean.valueOf(newValue + ""));
            }
            catch (Exception ex) {}
        } else if (propertyName.equals("barcodeScale")) {
            re.setPropertyValue("SCALE", newValue);
        } else if (propertyName.equals("barcodeError")) {
            ((ImageReportElement)re).setOnErrorType("" + newValue);
        } else if (propertyName.equals("barcodeVAlign")) {
            re.setPropertyValue("VERTICAL_ALIGN", newValue);
        } else if (propertyName.equals("barcodeHAlign")) {
            re.setPropertyValue("HORIZONTAL_ALIGN", newValue);
        } else if (propertyName.equals("chartEvaluationTime")) {
            ((ChartReportElement2)re).setEvaluationTime(newValue == null ? "" : "" + newValue);
            if (newValue != null && newValue.equals("Group")) {
                this.spChartEvaluationGroup.setReadOnly(false);
                ((ChartReportElement2)re).setEvaluationGroup(this.spChartEvaluationGroup.getValue() + "");
            } else {
                this.spChartEvaluationGroup.setReadOnly(true);
                ((ChartReportElement2)re).setEvaluationGroup("");
            }
            this.spChartEvaluationGroup.updateLabel();
        } else if (propertyName.equals("chartEvaluationGroup")) {
            ((ChartReportElement2)re).setEvaluationGroup(newValue == null ? "" : "" + newValue);
        }
    }

    public void reportElementsSelectionChanged(ReportElementsSelectionEvent evt) {
        this.updateSelection();
    }

    public void reportElementsChanged(ReportElementChangedEvent evt) {
        if (evt.getEventSource() == null || evt.getEventSource() != this) {
            if (evt.getType() == 3 && evt.getPropertyChanged() != null && !evt.getPropertyChanged().equals("textfieldEvaluationTime")) {
                this.setPropertyValue(evt.getPropertyChanged(), evt.getNewValue());
            } else {
                this.updateSelection();
            }
        }
    }

    public void reportBandChanged(ReportBandChangedEvent evt) {
        this.updateSelection();
    }

    protected void initSheetProperties() {
        this.spBands = new ComboBoxSheetProperty("band", I18n.getString("gui.elementpropertiessheet.band", "Band"));
        this.spBands.setShowResetButton(false);
        this.spLeft = new SheetProperty("left", I18n.getString("gui.elementpropertiessheet.left", "Left"), 6);
        this.spLeft.setShowResetButton(false);
        this.spTop = new SheetProperty("top", I18n.getString("gui.elementpropertiessheet.top", "Top"), 6);
        this.spTop.setShowResetButton(false);
        this.spWidth = new SheetProperty("width", I18n.getString("gui.elementpropertiessheet.width", "Width"), 6);
        this.spWidth.setShowResetButton(false);
        this.spHeight = new SheetProperty("height", I18n.getString("gui.elementpropertiessheet.height", "Height"), 6);
        this.spHeight.setShowResetButton(false);
        this.spFgColor = new SheetProperty("fgcolor", I18n.getString("gui.elementpropertiessheet.fgcolor", "Foreground"), 3);
        this.spBgColor = new SheetProperty("bgcolor", I18n.getString("gui.elementpropertiessheet.bgcolor", "Background"), 3);
        this.spMode = new SheetProperty("mode", I18n.getString("gui.elementpropertiessheet.mode", "Transparent"), 4);
        this.spPrintRepeatedValues = new SheetProperty("printRepeatedValues", I18n.getString("gui.elementpropertiessheet.printRepeatedValues", "Print repeated values"), 4);
        this.spPrintRepeatedValues.setShowResetButton(false);
        this.spPrintWhenDetailOverflows = new SheetProperty("printWhenDetailOverflows", I18n.getString("gui.elementpropertiessheet.printWhenDetailOverflows", "Print when detail overflows"), 4);
        this.spPrintWhenDetailOverflows.setShowResetButton(false);
        this.spPrintInFirstWholeBand = new SheetProperty("printInFirstWholeBand", I18n.getString("gui.elementpropertiessheet.printInFirstWholeBand", "Print in first whole band"), 4);
        this.spPrintInFirstWholeBand.setShowResetButton(false);
        this.spRemoveLineWhenBlank = new SheetProperty("removeLineWhenBlank", I18n.getString("gui.elementpropertiessheet.removeLineWhenBlank", "Remove line when blank"), 4);
        this.spRemoveLineWhenBlank.setShowResetButton(false);
        this.spPositionType = new SheetProperty("positionType", I18n.getString("gui.elementpropertiessheet.positionType", "Position type"), 2);
        this.spPositionType.setTags(new Tag[]{new Tag("FixRelativeToTop", I18n.getString("gui.elementpropertiessheet.positionType.FixRelativeToTop", "Fix relative to top")), new Tag("Float", I18n.getString("gui.elementpropertiessheet.positionType.Float", "Float")), new Tag("FixRelativeToBottom", I18n.getString("gui.elementpropertiessheet.positionType.FixRelativeToBottom", "Fix relative to bottom"))});
        this.spPositionType.setDefaultValue("FixRelativeToTop");
        this.spPositionType.setShowResetButton(false);
        this.spGroups = new ComboBoxSheetProperty("printWhenGroupChanges", I18n.getString("gui.elementpropertiessheet.printWhenGroupChanges", "Print when group changes"));
        this.spGroups.setShowResetButton(false);
        this.spElementKey = new SheetProperty("elementKey", I18n.getString("gui.elementpropertiessheet.elementKey", "Element key"), 0);
        this.spElementKey.setShowResetButton(false);
        this.spStretchType = new SheetProperty("stretchType", I18n.getString("gui.elementpropertiessheet.stretchType", "Stretch type"), 2);
        this.spStretchType.setTags(new Tag[]{new Tag("NoStretch", I18n.getString("gui.elementpropertiessheet.stretchType.NoStretch", "Fix relative to top")), new Tag("RelativeToTallestObject", I18n.getString("gui.elementpropertiessheet.stretchType.RelativeToTallestObject", "Float")), new Tag("RelativeToBandHeight", I18n.getString("gui.elementpropertiessheet.stretchType.RelativeToBandHeight", "Fix relative to bottom"))});
        this.spStretchType.setDefaultValue("NoStretch");
        this.spStretchType.setShowResetButton(false);
        this.spStyle = new ComboBoxSheetProperty("style", I18n.getString("gui.elementpropertiessheet.style", "Style"));
        this.spStyle.setShowResetButton(false);
        this.spStyle.setDefaultValue("");
        this.spPrintWhenExpression = new ExpressionSheetProperty("printWhenExpression", I18n.getString("gui.elementpropertiessheet.printWhenExpression", "Print When Expression"));
        this.spPrintWhenExpression.setShowResetButton(false);
        this.spPen = new SheetProperty("pen", I18n.getString("gui.elementpropertiessheet.pen", "Pen"), 2);
        this.spPen.setTags(new Tag[]{new Tag("", I18n.getString("gui.elementpropertiessheet.default", "Default")), new Tag("None", I18n.getString("gui.elementpropertiessheet.pen.None", "None")), new Tag("Thin", I18n.getString("gui.elementpropertiessheet.pen.Thin", "Thin")), new Tag("1Point", I18n.getString("gui.elementpropertiessheet.pen.1Point", "1Point")), new Tag("2Point", I18n.getString("gui.elementpropertiessheet.pen.2Point", "2Point")), new Tag("4Point", I18n.getString("gui.elementpropertiessheet.pen.4Point", "4Point")), new Tag("Dotted", I18n.getString("gui.elementpropertiessheet.pen.Dotted", "Dotted"))});
        this.spPen.setDefaultValue("");
        this.spFill = new SheetProperty("fill", I18n.getString("gui.elementpropertiessheet.fill", "Fill"), 2);
        this.spFill.setTags(new Tag[]{new Tag("", I18n.getString("gui.elementpropertiessheet.default", "Default")), new Tag("Solid", I18n.getString("gui.elementpropertiessheet.fill.Solid", "Solid"))});
        this.spFill.setDefaultValue("");
        this.spRadius = new SheetProperty("radius", I18n.getString("gui.elementpropertiessheet.radius", "Radius"), 1);
        try {
            ((JNumberField)this.spRadius.getEditor()).setDecimals(0);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.spDirection = new SheetProperty("direction", I18n.getString("gui.elementpropertiessheet.direction", "Direction"), 2);
        this.spDirection.setTags(new Tag[]{new Tag("TopDown", I18n.getString("gui.elementpropertiessheet.direction.TopDown", "Top-down (\\)")), new Tag("BottomUp", I18n.getString("gui.elementpropertiessheet.direction.BottomUp", "Bottom-up (/)"))});
        this.spDirection.setShowResetButton(false);
        this.spTextHAlign = new SheetProperty("hAlign", I18n.getString("gui.elementpropertiessheet.halign", "Align"), 2);
        this.spTextHAlign.setTags(new Tag[]{new Tag("Left", I18n.getString("gui.elementpropertiessheet.halign.Left", "Left")), new Tag("Center", I18n.getString("gui.elementpropertiessheet.halign.Center", "Center")), new Tag("Right", I18n.getString("gui.elementpropertiessheet.halign.Right", "Right")), new Tag("Justified", I18n.getString("gui.elementpropertiessheet.halign.Justified", "Justified"))});
        this.spTextHAlign.setDefaultValue("Left");
        this.spTextVAlign = new SheetProperty("vAlign", I18n.getString("gui.elementpropertiessheet.valign", "Vertical align"), 2);
        this.spTextVAlign.setTags(new Tag[]{new Tag("Top", I18n.getString("gui.elementpropertiessheet.valign.Top", "Top")), new Tag("Middle", I18n.getString("gui.elementpropertiessheet.valign.Middle", "Middle")), new Tag("Bottom", I18n.getString("gui.elementpropertiessheet.valign.Bottom", "Bottom"))});
        this.spTextVAlign.setDefaultValue("Top");
        this.spStyledText = new SheetProperty("styledText", I18n.getString("gui.elementpropertiessheet.styledText", "Styled text"), 4);
        this.spLineSpacing = new SheetProperty("lineSpacing", I18n.getString("gui.elementpropertiessheet.lineSpacing", "Line spacing"), 2);
        this.spLineSpacing.setTags(new Tag[]{new Tag("Single", I18n.getString("gui.elementpropertiessheet.lineSpacing.Single", "Single")), new Tag("1_1_2", I18n.getString("gui.elementpropertiessheet.lineSpacing.1_1_2", "1_1_2")), new Tag("Double", I18n.getString("gui.elementpropertiessheet.lineSpacing.Double", "Double"))});
        this.spLineSpacing.setDefaultValue("Single");
        this.spRotate = new SheetProperty("rotate", I18n.getString("gui.elementpropertiessheet.rotate", "Ratation"), 2);
        this.spRotate.setTags(new Tag[]{new Tag("None", I18n.getString("gui.elementpropertiessheet.rotate.None", "None")), new Tag("Left", I18n.getString("gui.elementpropertiessheet.rotate.Left", "Left")), new Tag("Right", I18n.getString("gui.elementpropertiessheet.rotate.Right", "Right"))});
        this.spRotate.setDefaultValue("None");
        this.spFontName = new SheetProperty("fontName", I18n.getString("gui.elementpropertiessheet.fontName", "Font"), 2);
        Vector<Tag> fontsVec = new Vector<Tag>();
        String[] fontFamilies = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < fontFamilies.length; ++i) {
            fontsVec.add(new Tag(fontFamilies[i]));
        }
        this.spFontName.setTags(fontsVec);
        this.spFontName.setDefaultValue("SansSerif");
        this.spFontSize = new NumberComboBoxSheetProperty("fontSize", I18n.getString("gui.elementpropertiessheet.fontSize", "Font size"));
        this.spFontSize.addEntry("3", 3);
        this.spFontSize.addEntry("5", 5);
        this.spFontSize.addEntry("8", 8);
        this.spFontSize.addEntry("10", 10);
        this.spFontSize.addEntry("12", 12);
        this.spFontSize.addEntry("14", 14);
        this.spFontSize.addEntry("18", 18);
        this.spFontSize.addEntry("24", 24);
        this.spFontSize.addEntry("36", 36);
        this.spFontSize.addEntry("48", 48);
        this.spPdfFontName = new SheetProperty("pdfFontName", I18n.getString("gui.elementpropertiessheet.pdfFontName", "PDF Font"), 2);
        fontsVec = new Vector();
        fontsVec.addElement(new Tag("Helvetica"));
        fontsVec.addElement(new Tag("Helvetica-Bold"));
        fontsVec.addElement(new Tag("Helvetica-BoldOblique"));
        fontsVec.addElement(new Tag("Helvetica-Oblique"));
        fontsVec.addElement(new Tag("Courier"));
        fontsVec.addElement(new Tag("Courier-Bold"));
        fontsVec.addElement(new Tag("Courier-BoldOblique"));
        fontsVec.addElement(new Tag("Courier-Oblique"));
        fontsVec.addElement(new Tag("Symbol"));
        fontsVec.addElement(new Tag("Times-Roman"));
        fontsVec.addElement(new Tag("Times-Bold"));
        fontsVec.addElement(new Tag("Times-BoldItalic"));
        fontsVec.addElement(new Tag("Times-Italic"));
        fontsVec.addElement(new Tag("ZapfDingbats"));
        fontsVec.addElement(new Tag("STSong-Light"));
        fontsVec.addElement(new Tag("MHei-Medium"));
        fontsVec.addElement(new Tag("MSung-Light"));
        fontsVec.addElement(new Tag("HeiseiKakuGo-W5"));
        fontsVec.addElement(new Tag("HeiseiMin-W3"));
        fontsVec.addElement(new Tag("HYGoThic-Medium"));
        fontsVec.addElement(new Tag("HYSMyeongJo-Medium"));
        Vector iRfonts = MainFrame.getMainInstance().getTtfFonts();
        for (int i_f = 0; i_f < iRfonts.size(); ++i_f) {
            fontsVec.addElement(new Tag(((IRFont)iRfonts.elementAt(i_f)).getFile(), iRfonts.elementAt(i_f) + ""));
        }
        this.spPdfFontName.setTags(fontsVec);
        this.spPdfFontName.setDefaultValue("Helvetica");
        ((JComboBox)this.spPdfFontName.getEditor()).setEditable(true);
        this.spBold = new SheetProperty("bold", I18n.getString("gui.elementpropertiessheet.Bold", "Bold"), 4);
        this.spItalic = new SheetProperty("italic", I18n.getString("gui.elementpropertiessheet.Italic", "Italic"), 4);
        this.spUnderline = new SheetProperty("underline", I18n.getString("gui.elementpropertiessheet.Underline", "Underline"), 4);
        this.spStriketrough = new SheetProperty("strikethrough", I18n.getString("gui.elementpropertiessheet.Strikethrough", "Strike through"), 4);
        this.spPdfEmbedded = new SheetProperty("pdfEmbedded", I18n.getString("gui.elementpropertiessheet.PdfEmbedded", "PDF embedded"), 4);
        this.spPdfEncoding = new SheetProperty("pdfEncoding", I18n.getString("gui.elementpropertiessheet.pdfEncoding", "PDF Encoding"), 2);
        fontsVec = new Vector();
        fontsVec.addElement(new Tag("Cp1250", "CP1250 (Central European)"));
        fontsVec.addElement(new Tag("Cp1251", "CP1251 (Cyrillic)"));
        fontsVec.addElement(new Tag("Cp1252", "CP1252 (Western European ANSI aka WinAnsi)"));
        fontsVec.addElement(new Tag("Cp1253", "CP1253 (Greek)"));
        fontsVec.addElement(new Tag("Cp1254", "CP1254 (Turkish)"));
        fontsVec.addElement(new Tag("Cp1255", "CP1255 (Hebrew)"));
        fontsVec.addElement(new Tag("Cp1256", "CP1256 (Arabic)"));
        fontsVec.addElement(new Tag("Cp1257", "CP1257 (Baltic)"));
        fontsVec.addElement(new Tag("Cp1258", "CP1258 (Vietnamese)"));
        fontsVec.addElement(new Tag("UniGB-UCS2-H", "UniGB-UCS2-H (Chinese Simplified)"));
        fontsVec.addElement(new Tag("UniGB-UCS2-V", "UniGB-UCS2-V (Chinese Simplified)"));
        fontsVec.addElement(new Tag("UniCNS-UCS2-H", "UniCNS-UCS2-H (Chinese traditional)"));
        fontsVec.addElement(new Tag("UniCNS-UCS2-V", "UniCNS-UCS2-V (Chinese traditional)"));
        fontsVec.addElement(new Tag("UniJIS-UCS2-H", "UniJIS-UCS2-H (Japanese)"));
        fontsVec.addElement(new Tag("UniJIS-UCS2-V", "UniJIS-UCS2-V (Japanese)"));
        fontsVec.addElement(new Tag("UniJIS-UCS2-HW-H", "UniJIS-UCS2-HW-H (Japanese)"));
        fontsVec.addElement(new Tag("UniJIS-UCS2-HW-V", "UniJIS-UCS2-HW-V (Japanese)"));
        fontsVec.addElement(new Tag("UniKS-UCS2-H", "UniKS-UCS2-H (Korean)"));
        fontsVec.addElement(new Tag("UniKS-UCS2-V", "UniKS-UCS2-V (Korean)"));
        fontsVec.addElement(new Tag("Identity-H", "Identity-H (Unicode with horizontal writing)"));
        fontsVec.addElement(new Tag("Identity-V", "Identity-V (Unicode with vertical writing)"));
        this.spPdfEncoding.setTags(fontsVec);
        ((JComboBox)this.spPdfEncoding.getEditor()).setEditable(true);
        this.spPdfEncoding.setDefaultValue("Cp1250");
        this.spStaticText = new ExpressionSheetProperty("text", I18n.getString("gui.elementpropertiessheet.text", "Text"));
        this.spStaticText.setPlainTextEditor(true);
        this.spStaticText.setShowResetButton(false);
        this.spTextfieldExpression = new ExpressionSheetProperty("textfieldExpression", I18n.getString("gui.elementpropertiessheet.textfieldExpression", "Expression"));
        this.spTextfieldExpression.setShowResetButton(false);
        this.spTextfieldExpressionClass = new SheetProperty("textfieldExpressionClass", I18n.getString("gui.elementpropertiessheet.textfieldExpressionClass", "Exp. class"), 2);
        fontsVec = new Vector();
        fontsVec.addElement(new Tag("java.lang.Boolean"));
        fontsVec.addElement(new Tag("java.lang.Byte"));
        fontsVec.addElement(new Tag("java.util.Date"));
        fontsVec.addElement(new Tag("java.sql.Timestamp"));
        fontsVec.addElement(new Tag("java.sql.Time"));
        fontsVec.addElement(new Tag("java.lang.Double"));
        fontsVec.addElement(new Tag("java.lang.Float"));
        fontsVec.addElement(new Tag("java.lang.Integer"));
        fontsVec.addElement(new Tag("java.lang.Long"));
        fontsVec.addElement(new Tag("java.lang.Short"));
        fontsVec.addElement(new Tag("java.math.BigDecimal"));
        fontsVec.addElement(new Tag("java.lang.String"));
        fontsVec.addElement(new Tag("java.lang.Number"));
        this.spTextfieldExpressionClass.setTags(fontsVec);
        this.spTextfieldExpressionClass.setDefaultValue("java.lang.String");
        this.spTextfieldExpressionClass.setShowResetButton(false);
        this.spTextfieldEvaluationTime = new SheetProperty("textfieldEvaluationTime", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime", "Eval. time"), 2);
        fontsVec = new Vector();
        fontsVec.addElement(new Tag("Now", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Now", "Now")));
        fontsVec.addElement(new Tag("Report", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Report", "Report")));
        fontsVec.addElement(new Tag("Page", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Page", "Page")));
        fontsVec.addElement(new Tag("Column", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Column", "Column")));
        fontsVec.addElement(new Tag("Group", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Group", "Group")));
        fontsVec.addElement(new Tag("Band", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Band", "Bans")));
        fontsVec.addElement(new Tag("Auto", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Auto", "Auto")));
        this.spTextfieldEvaluationTime.setTags(fontsVec);
        this.spTextfieldEvaluationTime.setDefaultValue("Now");
        this.spTextfieldEvaluationTime.setShowResetButton(false);
        this.spTextfieldEvaluationGroup = new ComboBoxSheetProperty("textfieldEvaluationGroup", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationGroup", "Eval. group"));
        this.spTextfieldEvaluationGroup.setShowResetButton(false);
        this.spStretchWithOverflow = new SheetProperty("stretchWithOverflow", I18n.getString("gui.elementpropertiessheet.stretchWithOverflow", "Stretch with overflow"), 4);
        this.spStretchWithOverflow.setShowResetButton(false);
        this.spTextfieldBlankWhenNull = new SheetProperty("blankWhenNull", I18n.getString("gui.elementpropertiessheet.blankWehnNull", "Blank when null"), 4);
        this.spTextfieldBlankWhenNull.setShowResetButton(false);
        this.spPattern = new PatternSheetProperty("pattern", I18n.getString("gui.elementpropertiessheet.Pattern", "Pattern"));
        this.spPattern.setDefaultValue("");
        this.spImageExpression = new ExpressionSheetProperty("imageExpression", I18n.getString("gui.elementpropertiessheet.imageExpression", "Image expression"));
        this.spImageExpression.setShowResetButton(false);
        this.spImageExpressionClass = new SheetProperty("imageExpressionClass", I18n.getString("gui.elementpropertiessheet.textfieldExpressionClass", "Exp. class"), 2);
        fontsVec = new Vector();
        fontsVec.addElement(new Tag("java.io.String"));
        fontsVec.addElement(new Tag("java.io.File"));
        fontsVec.addElement(new Tag("java.net.URL"));
        fontsVec.addElement(new Tag("java.io.InputStream"));
        fontsVec.addElement(new Tag("java.awt.Image"));
        fontsVec.addElement(new Tag("net.sf.jasperreports.engine.JRRenderable"));
        this.spImageExpressionClass.setTags(fontsVec);
        this.spImageExpressionClass.setShowResetButton(false);
        this.spImageEvaluationTime = new SheetProperty("imageEvaluationTime", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime", "Eval. time"), 2);
        fontsVec = new Vector();
        fontsVec.addElement(new Tag("Now", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Now", "Now")));
        fontsVec.addElement(new Tag("Report", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Report", "Report")));
        fontsVec.addElement(new Tag("Page", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Page", "Page")));
        fontsVec.addElement(new Tag("Column", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Column", "Column")));
        fontsVec.addElement(new Tag("Group", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Group", "Group")));
        fontsVec.addElement(new Tag("Band", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Band", "Bans")));
        fontsVec.addElement(new Tag("Auto", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Auto", "Auto")));
        this.spImageEvaluationTime.setTags(fontsVec);
        this.spImageEvaluationTime.setDefaultValue("Now");
        this.spImageEvaluationTime.setShowResetButton(false);
        this.spImageEvaluationGroup = new ComboBoxSheetProperty("imageEvaluationGroup", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationGroup", "Eval. group"));
        this.spImageEvaluationGroup.setShowResetButton(false);
        this.spImageScale = new SheetProperty("imageScale", I18n.getString("gui.elementpropertiessheet.imageScale", "Image scale"), 2);
        fontsVec = new Vector();
        fontsVec.addElement(new Tag("Clip", I18n.getString("gui.elementpropertiessheet.imageScale.Clip", "Clip")));
        fontsVec.addElement(new Tag("FillFrame", I18n.getString("gui.elementpropertiessheet.imageScale.FillFrame", "Fill frame")));
        fontsVec.addElement(new Tag("RetainShape", I18n.getString("gui.elementpropertiessheet.imageScale.RetainShape", "Retain shape")));
        this.spImageScale.setTags(fontsVec);
        this.spImageScale.setDefaultValue("FillFrame");
        this.spImageError = new SheetProperty("imageError", I18n.getString("gui.elementpropertiessheet.imageError", "On error type"), 2);
        fontsVec = new Vector();
        fontsVec.addElement(new Tag("Error", I18n.getString("gui.elementpropertiessheet.imageScale.Error", "Error")));
        fontsVec.addElement(new Tag("Blank", I18n.getString("gui.elementpropertiessheet.imageScale.Blank", "Blank")));
        fontsVec.addElement(new Tag("Icon", I18n.getString("gui.elementpropertiessheet.imageScale.Icon", "Icon")));
        this.spImageError.setTags(fontsVec);
        this.spImageError.setDefaultValue("Error");
        this.spImageError.setShowResetButton(false);
        this.spImageHAlign = new SheetProperty("imageHAlign", I18n.getString("gui.elementpropertiessheet.halign", "Align"), 2);
        this.spImageHAlign.setTags(new Tag[]{new Tag("Left", I18n.getString("gui.elementpropertiessheet.halign.Left", "Left")), new Tag("Center", I18n.getString("gui.elementpropertiessheet.halign.Center", "Center")), new Tag("Right", I18n.getString("gui.elementpropertiessheet.halign.Right", "Right"))});
        this.spImageHAlign.setDefaultValue("Left");
        this.spImageVAlign = new SheetProperty("imageVAlign", I18n.getString("gui.elementpropertiessheet.valign", "Vertical align"), 2);
        this.spImageVAlign.setTags(new Tag[]{new Tag("Top", I18n.getString("gui.elementpropertiessheet.valign.Top", "Top")), new Tag("Middle", I18n.getString("gui.elementpropertiessheet.valign.Middle", "Middle")), new Tag("Bottom", I18n.getString("gui.elementpropertiessheet.valign.Bottom", "Bottom"))});
        this.spImageVAlign.setDefaultValue("Top");
        this.spImageLazy = new SheetProperty("imageLazy", I18n.getString("gui.elementpropertiessheet.imageLazy", "Is lazy"), 4);
        this.spImageLazy.setShowResetButton(false);
        this.spImageCache = new SheetProperty("imageCache", I18n.getString("gui.elementpropertiessheet.imageCache", "Using cache"), 4);
        this.spBCExpression = new ExpressionSheetProperty("barcodeExpression", I18n.getString("gui.elementpropertiessheet.barcodeExpression", "Barcode expression"));
        this.spBCExpression.setShowResetButton(false);
        this.spBCApplicationIdentifier = new ExpressionSheetProperty("barcodeAppIdentifierExpression", I18n.getString("gui.elementpropertiessheet.barcodeApplicationIdentifier", "Applic. identifier"));
        this.spBCApplicationIdentifier.setShowResetButton(false);
        this.spBCBarWidth = new SheetProperty("barcodeBarWidth", I18n.getString("gui.elementpropertiessheet.barcodeBarWidth", "Bar width"), 6);
        this.spBCBarWidth.setShowResetButton(false);
        this.spBCBarHeight = new SheetProperty("barcodeBarHeight", I18n.getString("gui.elementpropertiessheet.barcodeBarHeight", "Bar height"), 6);
        this.spBCBarHeight.setShowResetButton(false);
        this.spBCType = new SheetProperty("barcodeType", I18n.getString("gui.elementpropertiessheet.barcodeType", "Type"), 2);
        fontsVec = new Vector();
        fontsVec.add(new Tag("1", "2of7"));
        fontsVec.add(new Tag("2", "3of9"));
        fontsVec.add(new Tag("3", "Bookland"));
        fontsVec.add(new Tag("4", "Codabar"));
        fontsVec.add(new Tag("5", "Code128"));
        fontsVec.add(new Tag("6", "Code128A"));
        fontsVec.add(new Tag("7", "Code128B"));
        fontsVec.add(new Tag("8", "Code128C"));
        fontsVec.add(new Tag("9", "Code39"));
        fontsVec.add(new Tag("26", "Code39 (Extended)"));
        fontsVec.add(new Tag("10", "EAN128"));
        fontsVec.add(new Tag("11", "EAN13"));
        fontsVec.add(new Tag("12", "GlobalTradeItemNumber"));
        fontsVec.add(new Tag("13", "Int2of5"));
        fontsVec.add(new Tag("14", "Monarch"));
        fontsVec.add(new Tag("15", "NW7"));
        fontsVec.add(new Tag("16", "PDF417"));
        fontsVec.add(new Tag("17", "SCC14ShippingCode"));
        fontsVec.add(new Tag("18", "ShipmentIdentificationNumber"));
        fontsVec.add(new Tag("19", "SSCC18"));
        fontsVec.add(new Tag("20", "Std2of5"));
        fontsVec.add(new Tag("21", "UCC128"));
        fontsVec.add(new Tag("22", "UPCA"));
        fontsVec.add(new Tag("23", "USD3"));
        fontsVec.add(new Tag("24", "USD4"));
        fontsVec.add(new Tag("25", "USPS"));
        this.spBCType.setTags(fontsVec);
        this.spBCType.setShowResetButton(false);
        this.spBCEvaluationTime = new SheetProperty("barcodeEvaluationTime", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime", "Eval. time"), 2);
        fontsVec = new Vector();
        fontsVec.addElement(new Tag("Now", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Now", "Now")));
        fontsVec.addElement(new Tag("Report", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Report", "Report")));
        fontsVec.addElement(new Tag("Page", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Page", "Page")));
        fontsVec.addElement(new Tag("Column", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Column", "Column")));
        fontsVec.addElement(new Tag("Group", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Group", "Group")));
        fontsVec.addElement(new Tag("Band", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Band", "Bans")));
        fontsVec.addElement(new Tag("Auto", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Auto", "Auto")));
        this.spBCEvaluationTime.setTags(fontsVec);
        this.spBCEvaluationTime.setDefaultValue("Now");
        this.spBCEvaluationTime.setShowResetButton(false);
        this.spBCEvaluationGroup = new ComboBoxSheetProperty("barcodeEvaluationGroup", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationGroup", "Eval. group"));
        this.spBCEvaluationGroup.setShowResetButton(false);
        this.spBCScale = new SheetProperty("barcodeScale", I18n.getString("gui.elementpropertiessheet.imageScale", "Image scale"), 2);
        fontsVec = new Vector();
        fontsVec.addElement(new Tag("Clip", I18n.getString("gui.elementpropertiessheet.imageScale.Clip", "Clip")));
        fontsVec.addElement(new Tag("FillFrame", I18n.getString("gui.elementpropertiessheet.imageScale.FillFrame", "Fill frame")));
        fontsVec.addElement(new Tag("RetainShape", I18n.getString("gui.elementpropertiessheet.imageScale.RetainShape", "Retain shape")));
        this.spBCScale.setTags(fontsVec);
        this.spBCScale.setDefaultValue("FillFrame");
        this.spBCError = new SheetProperty("barcodeError", I18n.getString("gui.elementpropertiessheet.imageError", "On error type"), 2);
        fontsVec = new Vector();
        fontsVec.addElement(new Tag("Error", I18n.getString("gui.elementpropertiessheet.imageScale.Error", "Error")));
        fontsVec.addElement(new Tag("Blank", I18n.getString("gui.elementpropertiessheet.imageScale.Blank", "Blank")));
        fontsVec.addElement(new Tag("Icon", I18n.getString("gui.elementpropertiessheet.imageScale.Icon", "Icon")));
        this.spBCError.setTags(fontsVec);
        this.spBCError.setDefaultValue("Error");
        this.spBCError.setShowResetButton(false);
        this.spBCHAlign = new SheetProperty("barcodeHAlign", I18n.getString("gui.elementpropertiessheet.halign", "Align"), 2);
        this.spBCHAlign.setTags(new Tag[]{new Tag("Left", I18n.getString("gui.elementpropertiessheet.halign.Left", "Left")), new Tag("Center", I18n.getString("gui.elementpropertiessheet.halign.Center", "Center")), new Tag("Right", I18n.getString("gui.elementpropertiessheet.halign.Right", "Right"))});
        this.spBCHAlign.setDefaultValue("Left");
        this.spBCVAlign = new SheetProperty("barcodeVAlign", I18n.getString("gui.elementpropertiessheet.valign", "Vertical align"), 2);
        this.spBCVAlign.setTags(new Tag[]{new Tag("Top", I18n.getString("gui.elementpropertiessheet.valign.Top", "Top")), new Tag("Middle", I18n.getString("gui.elementpropertiessheet.valign.Middle", "Middle")), new Tag("Bottom", I18n.getString("gui.elementpropertiessheet.valign.Bottom", "Bottom"))});
        this.spBCVAlign.setDefaultValue("Top");
        this.spBCChecksum = new SheetProperty("barcodeChecksum", I18n.getString("gui.elementpropertiessheet.barcodeChecksum", "Checksum"), 4);
        this.spBCChecksum.setShowResetButton(false);
        this.spBCShowText = new SheetProperty("barcodeShowText", I18n.getString("gui.elementpropertiessheet.barcodeShowText", "Show Text"), 4);
        this.spBCShowText.setShowResetButton(false);
        this.spChartEvaluationTime = new SheetProperty("chartEvaluationTime", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime", "Eval. time"), 2);
        fontsVec = new Vector();
        fontsVec.addElement(new Tag("Now", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Now", "Now")));
        fontsVec.addElement(new Tag("Report", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Report", "Report")));
        fontsVec.addElement(new Tag("Page", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Page", "Page")));
        fontsVec.addElement(new Tag("Column", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Column", "Column")));
        fontsVec.addElement(new Tag("Group", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Group", "Group")));
        fontsVec.addElement(new Tag("Band", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Band", "Bans")));
        fontsVec.addElement(new Tag("Auto", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationTime.Auto", "Auto")));
        this.spChartEvaluationTime.setTags(fontsVec);
        this.spChartEvaluationTime.setDefaultValue("Now");
        this.spChartEvaluationTime.setShowResetButton(false);
        this.spChartEvaluationGroup = new ComboBoxSheetProperty("chartEvaluationGroup", I18n.getString("gui.elementpropertiessheet.textfieldEvaluationGroup", "Eval. group"));
        this.spChartEvaluationGroup.setShowResetButton(false);
    }

    protected void updateAllComboBoxes() {
        if (this.jrf == null) {
            return;
        }
        Vector<String> group_names = new Vector<String>();
        Enumeration e = this.jrf.getReport().getGroups().elements();
        while (e.hasMoreElements()) {
            group_names.addElement("" + e.nextElement());
        }
        this.spTextfieldEvaluationGroup.updateValues(group_names, false);
        this.spImageEvaluationGroup.updateValues(group_names, false);
        this.spBCEvaluationGroup.updateValues(group_names, false);
        this.spChartEvaluationGroup.updateValues(group_names, false);
        group_names.insertElementAt("", 0);
        this.spGroups.updateValues(group_names, false);
        Vector styles = new Vector();
        e = this.jrf.getReport().getStyles().elements();
        while (e.hasMoreElements()) {
            styles.addElement(e.nextElement());
        }
        styles.insertElementAt("", 0);
        this.spStyle.updateValues(styles, true);
        this.updateBandsCell();
    }

    protected void updateBandsCell() {
        this.setInit(true);
        if (this.jrf.getSelectedCrosstabEditorPanel() == null) {
            this.spBands.setName(I18n.getString("gui.elementpropertiessheet.band", "Band"));
            Misc.updateComboBox((JComboBox)this.spBands.getEditor(), this.jrf.getReport().getBands(), false);
        } else {
            this.spBands.setName(I18n.getString("gui.elementpropertiessheet.cell", "Cell"));
            Misc.updateComboBox((JComboBox)this.spBands.getEditor(), this.jrf.getSelectedCrosstabEditorPanel().getCrosstabElement().getCells(), false);
        }
        this.setInit(false);
    }

    public boolean isInit() {
        return this.init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }

    protected boolean setComboBox(boolean firstTime, Object value, JComboBox comboField) {
        if (!firstTime && comboField.getSelectedItem() != value) {
            comboField.insertItemAt(I18n.getString("gui.elementpropertiessheet.differentValues", "<different values>"), 0);
            comboField.setSelectedIndex(0);
            return false;
        }
        try {
            comboField.setSelectedItem(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setTextArea(boolean firstTime, String value, SheetProperty textProperty) {
        if (!firstTime && !textProperty.getValue().equals(value)) {
            JComponent editor = textProperty.getEditor();
            if (editor instanceof ExpressionSheetPropertyComponent) {
                ((ExpressionSheetPropertyComponent)editor).setExpression("");
                ((ExpressionSheetPropertyComponent)editor).setText(I18n.getString("gui.elementpropertiessheet.differentValues", "<different values>"));
            }
            return false;
        }
        try {
            textProperty.setValue(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setTextPattern(boolean firstTime, Object value, SheetProperty textProperty) {
        if (!firstTime && !(textProperty.getValue() + "").equals(value)) {
            JComponent editor = textProperty.getEditor();
            if (editor instanceof PatternSheetPropertyComponent) {
                ((PatternSheetPropertyComponent)editor).setExpression("");
                ((PatternSheetPropertyComponent)editor).setText(I18n.getString("gui.elementpropertiessheet.differentValues", "<different values>"));
            }
            return false;
        }
        try {
            textProperty.setValue(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setTagComboBox(boolean firstTime, Object value, SheetProperty sp) {
        if (firstTime) {
            this.removeNullItem(sp);
            sp.setValue(value);
            return true;
        }
        Object s = sp.getValue();
        if (s == null && value == null) {
            return true;
        }
        if (s != null && s.equals(value)) {
            return true;
        }
        sp.setSetting(true);
        JComboBox combobox = (JComboBox)sp.getEditor();
        if (combobox.getItemCount() > 0) {
            Object obj = combobox.getItemAt(0);
            sp.setValue(null);
            if (!(obj + "").equals(I18n.getString("gui.elementpropertiessheet.differentValues", "<different values>"))) {
                ((JComboBox)sp.getEditor()).insertItemAt(new Tag(null, I18n.getString("gui.elementpropertiessheet.differentValues", "<different values>")), 0);
            }
        }
        ((JComboBox)sp.getEditor()).setSelectedIndex(0);
        sp.setSetting(false);
        return false;
    }

    protected boolean setElementNumber(boolean firstTime, double value, JNumberField numberField) {
        if (!firstTime && numberField.getValue() != value) {
            numberField.setText("");
            return false;
        }
        try {
            numberField.setValue(value);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setElementNumber(boolean firstTime, int defaultValue, Object value, NumberComboBoxSheetProperty sp) {
        if (!firstTime && !(sp.getValue() + "").equals("" + value)) {
            boolean setting = sp.isSetting();
            sp.setSetting(true);
            sp.setValue(null);
            sp.setSetting(setting);
            System.out.println("Setting value of editor to blank ");
            sp.setEditorValue(sp.getEditor(), "");
            return false;
        }
        try {
            boolean setting = sp.isSetting();
            sp.setSetting(true);
            sp.setValue(value);
            if (value == null) {
                if (!firstTime && !(((JNumberComboBox)sp.getEditor()).getSelectedItem() + "").equals("" + defaultValue)) {
                    sp.setEditorValue(sp.getEditor(), "");
                } else {
                    sp.setEditorValue(sp.getEditor(), new Integer(defaultValue));
                }
            }
            sp.setSetting(setting);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return true;
    }

    protected boolean setGenericSheetProperty(boolean firstTime, Object value, SheetProperty sp) {
        if (firstTime) {
            try {
                sp.setValue(value);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return true;
        }
        Object value2 = sp.getValue();
        if (value2 == value) {
            return true;
        }
        if (value2 != null && ("" + value2).equals(value + "")) {
            return true;
        }
        sp.setValue(null);
        return false;
    }

    protected boolean setColorProperty(boolean firstTime, Color color, SheetProperty sp) {
        if (firstTime) {
            try {
                sp.setValue(color);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return true;
        }
        Color c1 = (Color)sp.getValue();
        if (c1 == color) {
            return true;
        }
        if (c1 != null && color != null && c1.getRGB() == color.getRGB()) {
            return true;
        }
        sp.setValue(null);
        return false;
    }

    protected boolean setCheckBox(boolean firstTime, boolean value, boolean isNull, SheetProperty sp) {
        if (firstTime) {
            try {
                if (isNull) {
                    sp.setValue(null);
                    sp.setSetting(true);
                    ((JCheckBox)sp.getEditor()).setSelected(value);
                    sp.setSetting(false);
                } else {
                    sp.setValue("" + value);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return true;
        }
        if (sp.getValue() == null && isNull) {
            return true;
        }
        if (sp.getValue() != null && sp.getValue().equals("" + value)) {
            return true;
        }
        sp.setValue(null);
        return false;
    }

    public ComboBoxSheetProperty getSpBands() {
        return this.spBands;
    }

    public void setSpBands(ComboBoxSheetProperty spBands) {
        this.spBands = spBands;
    }

    public SheetProperty getSpTop() {
        return this.spTop;
    }

    public void setSpTop(SheetProperty spTop) {
        this.spTop = spTop;
    }

    public SheetProperty getSpLeft() {
        return this.spLeft;
    }

    public void setSpLeft(SheetProperty spLeft) {
        this.spLeft = spLeft;
    }

    public SheetProperty getSpHeight() {
        return this.spHeight;
    }

    public void setSpHeight(SheetProperty spHeight) {
        this.spHeight = spHeight;
    }

    public SheetProperty getSpWidth() {
        return this.spWidth;
    }

    public void setSpWidth(SheetProperty spWidth) {
        this.spWidth = spWidth;
    }

    public ComboBoxSheetProperty getSpGroups() {
        return this.spGroups;
    }

    public void setSpGroups(ComboBoxSheetProperty spGroups) {
        this.spGroups = spGroups;
    }

    public JReportFrame getJrf() {
        return this.jrf;
    }

    public void setJrf(JReportFrame jrf) {
        this.jrf = jrf;
    }

    public void repaintEditor() {
        if (this.jrf == null) {
            return;
        }
        if (this.jrf.getSelectedCrosstabEditorPanel() == null) {
            this.jrf.getJPanelReport().repaint();
        } else {
            this.jrf.getSelectedCrosstabEditorPanel().repaint();
        }
    }

    public Vector getElementSelection() {
        return this.elementSelection;
    }

    public void setElementSelection(Vector newElementSelection) {
        this.elementSelection.removeAllElements();
        if (newElementSelection == null) {
            return;
        }
        this.elementSelection.addAll(newElementSelection);
    }

    protected void updateReportFonts() {
        Object value = this.spPdfFontName.getValue();
        Vector<Tag> fontsVec = new Vector<Tag>();
        fontsVec.addElement(new Tag("Helvetica"));
        fontsVec.addElement(new Tag("Helvetica-Bold"));
        fontsVec.addElement(new Tag("Helvetica-BoldOblique"));
        fontsVec.addElement(new Tag("Helvetica-Oblique"));
        fontsVec.addElement(new Tag("Courier"));
        fontsVec.addElement(new Tag("Courier-Bold"));
        fontsVec.addElement(new Tag("Courier-BoldOblique"));
        fontsVec.addElement(new Tag("Courier-Oblique"));
        fontsVec.addElement(new Tag("Symbol"));
        fontsVec.addElement(new Tag("Times-Roman"));
        fontsVec.addElement(new Tag("Times-Bold"));
        fontsVec.addElement(new Tag("Times-BoldItalic"));
        fontsVec.addElement(new Tag("Times-Italic"));
        fontsVec.addElement(new Tag("ZapfDingbats"));
        fontsVec.addElement(new Tag("STSong-Light"));
        fontsVec.addElement(new Tag("MHei-Medium"));
        fontsVec.addElement(new Tag("MSung-Light"));
        fontsVec.addElement(new Tag("HeiseiKakuGo-W5"));
        fontsVec.addElement(new Tag("HeiseiMin-W3"));
        fontsVec.addElement(new Tag("HYGoThic-Medium"));
        fontsVec.addElement(new Tag("HYSMyeongJo-Medium"));
        Vector iRfonts = MainFrame.getMainInstance().getTtfFonts();
        for (int i_f = 0; i_f < iRfonts.size(); ++i_f) {
            fontsVec.addElement(new Tag(((IRFont)iRfonts.elementAt(i_f)).getFile(), iRfonts.elementAt(i_f) + ""));
        }
        Misc.updateComboBox((JComboBox)this.spPdfFontName.getEditor(), fontsVec);
        this.spPdfFontName.setEditorValue(this.spPdfFontName.getEditor(), value);
    }
}

