/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.Misc;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ReportClassLoader
extends ClassLoader {
    private ArrayList fPathItems = new ArrayList();
    private ArrayList fPathChachedItems = new ArrayList();
    private HashMap cachedClasses = new HashMap();

    public ReportClassLoader() {
        this.rescanLibDirectory();
    }

    public void rescanLibDirectory() {
        try {
            this.rescanAdditionalClasspath();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (MainFrame.getMainInstance() == null) {
            return;
        }
        MainFrame.getMainInstance();
        File lib_dir = new File(MainFrame.IREPORT_HOME_DIR, "lib");
        String classpath = Misc.nvl(System.getProperty("java.class.path"), "");
        if (!lib_dir.exists()) {
            StringBuffer stringBuffer = new StringBuffer().append("Cannot find lib in iReport home  directory (");
            MainFrame.getMainInstance();
            System.out.println(stringBuffer.append(MainFrame.IREPORT_HOME_DIR).append(")").toString());
            return;
        }
        File[] new_libs = lib_dir.listFiles();
        for (int i = 0; i < new_libs.length; ++i) {
            if (!new_libs[i].getName().toLowerCase().endsWith("jar") && !new_libs[i].getName().toLowerCase().endsWith("zip") || classpath.indexOf(new_libs[i].getName()) >= 0) continue;
            try {
                if (this.fPathChachedItems.contains(new_libs[i].getCanonicalPath())) continue;
                this.fPathChachedItems.add(new_libs[i].getCanonicalPath());
                continue;
            }
            catch (Exception ex) {
                System.out.println("Invalid path: " + new_libs[i]);
            }
        }
    }

    public List getCachedItems() {
        return this.fPathChachedItems;
    }

    public void clearCache() {
        this.cachedClasses.clear();
    }

    public void rescanAdditionalClasspath() {
        if (MainFrame.getMainInstance() == null) {
            return;
        }
        Vector cp = MainFrame.getMainInstance().getClasspath();
        for (int i = 0; i < cp.size(); ++i) {
            File f = new File(cp.elementAt(i) + "");
            if (!f.exists()) continue;
            try {
                if (this.fPathChachedItems.contains(f.getCanonicalPath())) continue;
                this.fPathChachedItems.add(f.getCanonicalPath());
                continue;
            }
            catch (Exception ex) {
                System.out.println("Invalid path: " + f);
            }
        }
    }

    public void addNoRelodablePath(String path) {
        if (!this.fPathChachedItems.contains(path)) {
            this.fPathChachedItems.add(path);
        }
    }

    public void setRelodablePaths(String classPath) {
        this.scanPath(classPath);
    }

    private void scanPath(String classPath) {
        String separator = System.getProperty("path.separator");
        this.fPathItems = new ArrayList(31);
        StringTokenizer st = new StringTokenizer(classPath, separator);
        while (st.hasMoreTokens()) {
            String pp = st.nextToken();
            this.fPathItems.add(pp);
        }
    }

    public URL getResource(String name) {
        return this.findResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        File f;
        InputStream is;
        String path;
        int i;
        for (i = 0; i < this.fPathChachedItems.size(); ++i) {
            path = (String)this.fPathChachedItems.get(i);
            if (this.isJar(path)) {
                is = this.getInputStreamFromJar(path, name);
                if (is == null) continue;
                return is;
            }
            f = new File(path, name);
            if (!f.exists()) continue;
            try {
                return new FileInputStream(f);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        for (i = 0; i < this.fPathItems.size(); ++i) {
            path = (String)this.fPathItems.get(i);
            if (this.isJar(path)) {
                is = this.getInputStreamFromJar(path, name);
                if (is == null) continue;
                return is;
            }
            f = new File(path, name);
            if (!f.exists()) continue;
            try {
                return new FileInputStream(f);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return ClassLoader.getSystemResourceAsStream(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getInputStreamFromJar(String archive_path, String fileName) {
        ZipFile zipFile = null;
        Object stream = null;
        File archive = new File(archive_path);
        if (!archive.exists()) {
            return null;
        }
        try {
            zipFile = new ZipFile(archive);
        }
        catch (IOException io) {
            return null;
        }
        ZipEntry entry = zipFile.getEntry(fileName);
        if (entry == null) {
            return null;
        }
        try {
            InputStream inputStream = zipFile.getInputStream(entry);
            return inputStream;
        }
        catch (IOException e) {
        }
        return null;
    }

    public synchronized Class findClass(String name) throws ClassNotFoundException {
        Class c = null;
        c = this.cachedClasses.containsKey(name) ? (Class)this.cachedClasses.get(name) : this.loadClassData(name);
        return c;
    }

    private Class loadClassData(String className) throws ClassNotFoundException {
        String fileName;
        String path;
        int i;
        byte[] data = null;
        if (!this.cachedClasses.containsKey(className)) {
            for (i = 0; i < this.fPathChachedItems.size(); ++i) {
                path = (String)this.fPathChachedItems.get(i);
                fileName = className.replace('.', File.separatorChar) + ".class";
                data = this.isJar(path) ? this.loadJarData(path, fileName.replace(File.separatorChar, '/')) : this.loadFileData(path, fileName.replace(File.separatorChar, '/'));
                if (data == null) continue;
                Class<?> c = this.defineClass(className, data, 0, data.length);
                this.cachedClasses.put(className, c);
                return c;
            }
        } else {
            return (Class)this.cachedClasses.get(className);
        }
        for (i = 0; i < this.fPathItems.size(); ++i) {
            path = (String)this.fPathItems.get(i);
            fileName = className.replace('.', File.separatorChar) + ".class";
            data = this.isJar(path) ? this.loadJarData(path, fileName) : this.loadFileData(path, fileName);
            if (data == null) continue;
            Class<?> c = this.defineClass(className, data, 0, data.length);
            return c;
        }
        throw new ClassNotFoundException(className);
    }

    boolean isJar(String pathEntry) {
        return pathEntry.toLowerCase().endsWith(".jar") || pathEntry.toLowerCase().endsWith(".zip");
    }

    private byte[] loadFileData(String path, String fileName) {
        File file = new File(path, fileName);
        if (file.exists()) {
            return this.getClassData(file);
        }
        return null;
    }

    private byte[] getClassData(File f) {
        try {
            int n;
            FileInputStream stream = new FileInputStream(f);
            ByteArrayOutputStream out = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = stream.read(b)) != -1) {
                out.write(b, 0, n);
            }
            stream.close();
            out.close();
            return out.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadJarData(String path, String fileName) {
        ZipFile zipFile = null;
        InputStream stream = null;
        File archive = new File(path);
        if (!archive.exists()) {
            return null;
        }
        try {
            zipFile = new ZipFile(archive);
        }
        catch (IOException io) {
            return null;
        }
        ZipEntry entry = zipFile.getEntry(fileName);
        if (entry == null) {
            return null;
        }
        int size = (int)entry.getSize();
        try {
            int n;
            stream = zipFile.getInputStream(entry);
            byte[] data = new byte[size];
            for (int pos = 0; pos < size; pos += n) {
                n = stream.read(data, pos, data.length - pos);
            }
            zipFile.close();
            byte[] byArray = data;
            return byArray;
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {}
        }
        return null;
    }

    public Enumeration findResources(String name) {
        String path;
        int i;
        Vector urls = new Vector();
        URL[] pathUrls = new URL[this.fPathChachedItems.size() + this.fPathItems.size()];
        for (i = 0; i < this.fPathChachedItems.size(); ++i) {
            path = (String)this.fPathChachedItems.get(i);
            try {
                pathUrls[i] = new File(path).toURL();
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        for (i = 0; i < this.fPathItems.size(); ++i) {
            path = (String)this.fPathItems.get(i);
            try {
                pathUrls[i + this.fPathChachedItems.size()] = new File(path).toURL();
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        URLClassLoader urlCl = new URLClassLoader(pathUrls, null);
        try {
            return urlCl.findResources(name);
        }
        catch (Exception ex) {
            return new Vector().elements();
        }
    }

    public URL findResource(String name) {
        String path;
        int i;
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        URL[] pathUrls = new URL[this.fPathChachedItems.size() + this.fPathItems.size()];
        for (i = 0; i < this.fPathChachedItems.size(); ++i) {
            path = (String)this.fPathChachedItems.get(i);
            try {
                pathUrls[i] = new File(path).toURL();
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        for (i = 0; i < this.fPathItems.size(); ++i) {
            path = (String)this.fPathItems.get(i);
            try {
                pathUrls[i + this.fPathChachedItems.size()] = new File(path).toURL();
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        URLClassLoader urlCl = new URLClassLoader(pathUrls, null);
        try {
            URL url = urlCl.findResource(name);
            if (url != null) {
                return url;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ClassLoader.getSystemResource(name);
    }
}

