/*
 * Decompiled with CFR 0.152.
 */
package groovy.xml;

import groovy.util.BuilderSupport;
import groovy.util.IndentPrinter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;

public class MarkupBuilder
extends BuilderSupport {
    private IndentPrinter out;
    private boolean nospace;
    private int state;
    private boolean nodeIsEmpty = true;

    public MarkupBuilder() {
        this(new IndentPrinter());
    }

    public MarkupBuilder(PrintWriter writer) {
        this(new IndentPrinter(writer));
    }

    public MarkupBuilder(Writer writer) {
        this(new IndentPrinter(new PrintWriter(writer)));
    }

    public MarkupBuilder(IndentPrinter out) {
        this.out = out;
    }

    protected void setParent(Object parent, Object child) {
    }

    protected Object createNode(Object name) {
        this.toState(1, name);
        return name;
    }

    protected Object createNode(Object name, Object value) {
        this.toState(2, name);
        this.out.print(">");
        this.out.print(this.transformValue(value.toString()));
        return name;
    }

    protected Object createNode(Object name, Map attributes, Object value) {
        this.toState(1, name);
        Iterator iter = attributes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.out.print(" ");
            this.print(this.transformName(entry.getKey().toString()));
            this.out.print("='");
            this.print(this.transformValue(entry.getValue().toString()));
            this.out.print("'");
        }
        if (value != null) {
            this.nodeIsEmpty = false;
            this.out.print(">" + this.transformValue(value.toString()) + "</" + name + ">");
        }
        return name;
    }

    protected Object createNode(Object name, Map attributes) {
        return this.createNode(name, attributes, null);
    }

    protected void nodeCompleted(Object parent, Object node) {
        this.toState(3, node);
        this.out.flush();
    }

    protected void print(Object node) {
        this.out.print(node == null ? "null" : node.toString());
    }

    protected Object getName(String methodName) {
        return super.getName(this.transformName(methodName));
    }

    protected String transformName(String name) {
        if (name.startsWith("_")) {
            name = name.substring(1);
        }
        return name.replace('_', '-');
    }

    protected String transformValue(String value) {
        if (value.matches(".*&.*")) {
            value = value.replaceAll("&", "&amp;");
        }
        if (value.matches(".*\\'.*")) {
            value = value.replaceAll("\\'", "&quot;");
        }
        if (value.matches(".*<.*")) {
            value = value.replaceAll("<", "&lt;");
        }
        if (value.matches(".*>.*")) {
            value = value.replaceAll(">", "&gt;");
        }
        return value;
    }

    private void toState(int next, Object name) {
        block0 : switch (this.state) {
            case 0: {
                switch (next) {
                    case 1: 
                    case 2: {
                        this.out.print("<");
                        this.print(name);
                        break block0;
                    }
                    case 3: {
                        throw new Error();
                    }
                }
                break;
            }
            case 1: {
                switch (next) {
                    case 1: 
                    case 2: {
                        this.out.print(">");
                        if (this.nospace) {
                            this.nospace = false;
                        } else {
                            this.out.println();
                            this.out.incrementIndent();
                            this.out.printIndent();
                        }
                        this.out.print("<");
                        this.print(name);
                        break;
                    }
                    case 3: {
                        if (!this.nodeIsEmpty) break;
                        this.out.print(" />");
                    }
                }
                break;
            }
            case 2: {
                switch (next) {
                    case 1: 
                    case 2: {
                        throw new Error();
                    }
                    case 3: {
                        this.out.print("</");
                        this.print(name);
                        this.out.print(">");
                    }
                }
                break;
            }
            case 3: {
                switch (next) {
                    case 1: 
                    case 2: {
                        if (this.nospace) {
                            this.nospace = false;
                        } else {
                            this.out.println();
                            this.out.printIndent();
                        }
                        this.out.print("<");
                        this.print(name);
                        break block0;
                    }
                    case 3: {
                        if (this.nospace) {
                            this.nospace = false;
                        } else {
                            this.out.println();
                            this.out.decrementIndent();
                            this.out.printIndent();
                        }
                        this.out.print("</");
                        this.print(name);
                        this.out.print(">");
                    }
                }
            }
        }
        this.state = next;
    }
}

