/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.hsqldb.util.DataAccessPoint;
import org.hsqldb.util.DataAccessPointException;
import org.hsqldb.util.JDBCTypes;
import org.hsqldb.util.Traceable;
import org.hsqldb.util.TransferResultSet;
import org.hsqldb.util.TransferTable;

class TransferSQLText
extends DataAccessPoint {
    String sFileName = null;
    BufferedWriter WTextWrite = null;
    BufferedReader WTextRead = null;
    protected boolean StructureAlreadyParsed = false;
    Hashtable DbStmts = null;
    protected JDBCTypes JDBCT = null;

    TransferSQLText(String string, Traceable traceable) throws DataAccessPointException {
        super(traceable);
        this.sFileName = string;
        this.JDBCT = new JDBCTypes();
        if (this.sFileName == null) {
            throw new DataAccessPointException("File name not initialized");
        }
    }

    boolean execute(String string) throws DataAccessPointException {
        if (this.WTextWrite == null) {
            try {
                this.WTextWrite = new BufferedWriter(new FileWriter(this.sFileName));
            }
            catch (IOException iOException) {
                throw new DataAccessPointException(iOException.getMessage());
            }
        }
        try {
            this.WTextWrite.write(string + "\n");
            this.WTextWrite.flush();
        }
        catch (IOException iOException) {
            throw new DataAccessPointException(iOException.getMessage());
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void putData(String string, TransferResultSet transferResultSet, int n) throws DataAccessPointException {
        int n2 = 0;
        if (transferResultSet == null) {
            return;
        }
        if (this.WTextWrite == null) {
            try {
                this.WTextWrite = new BufferedWriter(new FileWriter(this.sFileName));
            }
            catch (IOException iOException) {
                throw new DataAccessPointException(iOException.getMessage());
            }
        }
        try {
            try {
                while (transferResultSet.next()) {
                    if (n2 == 0) {
                        this.WTextWrite.write(string + "\n");
                        this.WTextWrite.flush();
                    }
                    this.transferRow(transferResultSet);
                    if (n == 0 || n2 != n) {
                        if (n == 0 && ++n2 % 100 != 0) continue;
                        this.tracer.trace("Transfered " + n2 + " rows");
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                throw new DataAccessPointException(exception.getMessage());
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (n2 <= 0) throw throwable;
                this.WTextWrite.write("\tNumber of Rows=" + n2 + "\n\n");
                this.WTextWrite.flush();
                throw throwable;
            }
            catch (IOException iOException) {
                throw new DataAccessPointException(iOException.getMessage());
            }
        }
        try {}
        catch (IOException iOException) {
            throw new DataAccessPointException(iOException.getMessage());
        }
        if (n2 <= 0) return;
        this.WTextWrite.write("\tNumber of Rows=" + n2 + "\n\n");
        this.WTextWrite.flush();
    }

    void close() throws DataAccessPointException {
        if (this.WTextWrite != null) {
            try {
                this.WTextWrite.flush();
                this.WTextWrite.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void transferRow(TransferResultSet transferResultSet) throws Exception {
        String string = "";
        int n = transferResultSet.getColumnCount();
        if (this.WTextWrite == null) {
            try {
                this.WTextWrite = new BufferedWriter(new FileWriter(this.sFileName));
            }
            catch (IOException iOException) {
                throw new DataAccessPointException(iOException.getMessage());
            }
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = transferResultSet.getColumnType(n2 + 1);
            string = "column=" + transferResultSet.getColumnName(n2 + 1) + " datatype=" + (String)this.helper.getSupportedTypes().get(new Integer(n3));
            Object object = transferResultSet.getObject(n2 + 1);
            if (object == null) {
                string = string + " value=<null>";
            } else {
                object = this.helper.convertColumnValue(object, n2 + 1, n3);
                string = string + " value='" + object.toString() + "'";
            }
            this.WTextWrite.write("\t" + string + "\n");
            this.WTextWrite.flush();
            ++n2;
        }
        this.WTextWrite.write("\n");
        this.WTextWrite.flush();
        string = "";
    }

    ColumnDef getColumnDef(String string, int n) {
        int n2 = 0;
        ColumnDef columnDef = new ColumnDef();
        columnDef.start = n;
        if (string == null || string.length() == 0 || n >= string.length()) {
            return new ColumnDef();
        }
        String string2 = string.substring(n);
        try {
            int n3 = 0;
            while (n3 < string2.length()) {
                char c = string2.charAt(n3);
                if (c != ',' && c != ' ' && c != ')' && c != ';') break;
                ++n3;
            }
            if (n3 == string2.length()) {
                return new ColumnDef();
            }
            columnDef.len += n3;
            string2 = string2.substring(n3);
            while (string2.charAt(n2) != ' ') {
                ++n2;
            }
            columnDef.columnName = string2.substring(0, n2);
            string2 = string2.substring(n2);
            columnDef.len += n2;
            n2 = 0;
            if (!columnDef.columnName.toUpperCase().equals("CONSTRAINT")) {
                n3 = 0;
                while (n3 < string2.length() && string2.charAt(n3) == ' ') {
                    ++n3;
                }
                string2 = string2.substring(n3);
                columnDef.len += n3;
                while (string2.charAt(n2) != '(' && string2.charAt(n2) != ',' && string2.charAt(n2) != ')' && string2.charAt(n2) != ';' && string2.charAt(n2) != ' ') {
                    ++n2;
                }
                columnDef.columnType = string2.substring(0, n2).toUpperCase();
                string2 = string2.substring(n2);
                columnDef.len += n2;
                n2 = 0;
            }
            while (string2.charAt(n2) != ',' && string2.charAt(n2) != ';' && n2 < string2.length() && string2.charAt(n2) != ')') {
                if (string2.charAt(n2) == '(') {
                    while (string2.charAt(n2) != ')') {
                        ++n2;
                    }
                }
                ++n2;
            }
            columnDef.options = string2.substring(0, n2);
            columnDef.len += n2;
        }
        catch (Exception exception) {
            columnDef = new ColumnDef();
        }
        return columnDef;
    }

    String translateTypes(String string, TransferTable transferTable, DataAccessPoint dataAccessPoint) throws DataAccessPointException {
        String string2 = "";
        JDBCTypes jDBCTypes = new JDBCTypes();
        int n = 0;
        String string3 = "";
        String string4 = "";
        int n2 = 0;
        n = string.indexOf(40) + 1;
        string2 = string.substring(0, n);
        while (true) {
            ColumnDef columnDef = this.getColumnDef(string, n);
            if (columnDef.len == 0) break;
            string3 = columnDef.columnName;
            string4 = columnDef.columnType;
            if (string3.toUpperCase().indexOf("CONSTRAINT") >= 0) {
                string2 = string2 + string.substring(n, n + columnDef.len) + ",";
                n += columnDef.len + 1;
                ++n2;
                continue;
            }
            string3 = dataAccessPoint.helper.formatIdentifier(string3) + " ";
            try {
                Integer n3 = new Integer(dataAccessPoint.helper.convertToType(jDBCTypes.toInt(string4)));
                string4 = (String)transferTable.hTypes.get(n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (columnDef.options != null) {
                string4 = string4 + columnDef.options;
            }
            try {
                string4 = dataAccessPoint.helper.fixupColumnDefWrite(transferTable, null, string4, null, n2);
            }
            catch (SQLException sQLException) {
                return string;
            }
            string2 = string2 + string3 + " " + string4 + ",";
            n += columnDef.len + 1;
            ++n2;
        }
        return string2.substring(0, string2.length() - 1) + ");";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void parseFileForTables() throws DataAccessPointException {
        if (this.WTextRead == null) {
            try {
                this.WTextRead = new BufferedReader(new FileReader(this.sFileName));
            }
            catch (IOException iOException) {
                throw new DataAccessPointException(iOException.getMessage());
            }
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        TransferTable transferTable = null;
        try {
            while (true) {
                if ((string = this.WTextRead.readLine()) == null) {
                    return;
                }
                string = string.trim() + ";";
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                try {
                    string2 = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {
                    continue;
                }
                if (string2 == null || !string2.toUpperCase().equals("CREATE") || !(string2 = stringTokenizer.nextToken().toUpperCase()).equals("TABLE") && !string2.equals("VIEW")) continue;
                try {
                    string3 = stringTokenizer.nextToken(" (;");
                    transferTable = new TransferTable(this, string3, "", string2, this.tracer);
                    transferTable.Stmts.bCreate = false;
                    transferTable.Stmts.bDelete = false;
                    transferTable.Stmts.bDrop = false;
                    transferTable.Stmts.bCreateIndex = false;
                    transferTable.Stmts.bDropIndex = false;
                    transferTable.Stmts.bInsert = false;
                    transferTable.Stmts.bAlter = false;
                    this.DbStmts.put(transferTable.Stmts.sSourceTable, transferTable);
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            throw new DataAccessPointException(exception.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void parseFileForTheRest(TransferTable transferTable, DataAccessPoint dataAccessPoint) throws DataAccessPointException {
        this.StructureAlreadyParsed = true;
        if (this.WTextRead == null) {
            try {
                this.WTextRead = new BufferedReader(new FileReader(this.sFileName));
            }
            catch (IOException iOException) {
                throw new DataAccessPointException(iOException.getMessage());
            }
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        TransferTable transferTable2 = null;
        try {
            while (true) {
                if ((string = this.WTextRead.readLine()) == null) {
                    return;
                }
                string = string.trim() + ";";
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                try {
                    string2 = stringTokenizer.nextToken();
                }
                catch (NoSuchElementException noSuchElementException) {
                    continue;
                }
                if (string2 == null) continue;
                if (string2.toUpperCase().equals("INSERT")) {
                    try {
                        if (!stringTokenizer.nextToken().toUpperCase().equals("INTO")) {
                            throw new DataAccessPointException("Error in INSERT statement: no INTO found");
                        }
                        string2 = stringTokenizer.nextToken();
                        transferTable2 = (TransferTable)this.DbStmts.get(string2);
                        if (transferTable2 == null) continue;
                        transferTable2.Stmts.bDelete = true;
                        transferTable2.Stmts.bInsert = true;
                        transferTable2.Stmts.sDestInsert = string;
                        transferTable2.Stmts.sDestDelete = "DELETE FROM " + transferTable2.Stmts.sSourceTable + ";";
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                    continue;
                }
                if (string2.toUpperCase().equals("ALTER")) {
                    try {
                        if (!stringTokenizer.nextToken().toUpperCase().equals("TABLE")) continue;
                        string3 = stringTokenizer.nextToken();
                        string2 = stringTokenizer.nextToken().toUpperCase();
                        if (!string2.equals("ADD")) continue;
                        while (!(string2 = stringTokenizer.nextToken().toUpperCase()).equals("CONSTRAINT")) {
                        }
                        transferTable2 = (TransferTable)this.DbStmts.get(string3);
                        if (transferTable2 == null) throw new DataAccessPointException("table not found");
                        if (transferTable2.Stmts.sDestAlter == null) {
                            transferTable2.Stmts.sDestAlter = "";
                        }
                        transferTable2.Stmts.bAlter = true;
                        transferTable2.Stmts.sDestAlter = transferTable2.Stmts.sDestAlter + string;
                        string2 = stringTokenizer.nextToken();
                        if (transferTable2.Stmts.sDestDrop == null) {
                            transferTable2.Stmts.sDestDrop = "";
                        }
                        transferTable2.Stmts.bDrop = true;
                        transferTable2.Stmts.sDestDrop = "ALTER TABLE " + string3 + " DROP CONSTRAINT " + string2 + ";" + transferTable2.Stmts.sDestDrop;
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                    continue;
                }
                if (!string2.toUpperCase().equals("CREATE")) continue;
                string2 = stringTokenizer.nextToken().toUpperCase();
                if (string2.equals("TABLE") || string2.equals("VIEW")) {
                    try {
                        string3 = stringTokenizer.nextToken(" (;");
                        if (!this.DbStmts.containsKey(string3)) {
                            throw new DataAccessPointException("error: index is created before the table");
                        }
                        transferTable2 = (TransferTable)this.DbStmts.get(string3);
                        transferTable2.Stmts.bCreate = true;
                        transferTable2.Stmts.bDrop = true;
                        transferTable2.Stmts.sDestCreate = this.translateTypes(string, transferTable, dataAccessPoint);
                        transferTable2.Stmts.sDestDrop = "DROP " + transferTable2.Stmts.sType + " " + string3 + ";";
                        this.DbStmts.put(transferTable2.Stmts.sSourceTable, transferTable2);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        continue;
                    }
                }
                if (!string2.equals("INDEX") && !string2.equals("UNIQUE")) continue;
                try {
                    while ((string2 = stringTokenizer.nextToken()).toUpperCase().equals("INDEX")) {
                    }
                    String string4 = "DROP INDEX " + string2 + " ;";
                    while ((string2 = stringTokenizer.nextToken(" (")).toUpperCase().equals("ON")) {
                    }
                    string3 = string2;
                    if (!this.DbStmts.containsKey(string2)) {
                        throw new DataAccessPointException("error: index is created before the table");
                    }
                    transferTable2 = (TransferTable)this.DbStmts.get(string2);
                    if (transferTable2.Stmts.sDestCreateIndex == null) {
                        transferTable2.Stmts.sDestCreateIndex = "";
                    }
                    if (transferTable2.Stmts.sDestDropIndex == null) {
                        transferTable2.Stmts.sDestDropIndex = "";
                    }
                    transferTable2.Stmts.bCreateIndex = true;
                    transferTable2.Stmts.bDropIndex = true;
                    transferTable2.Stmts.sDestCreateIndex = transferTable2.Stmts.sDestCreateIndex + string;
                    transferTable2.Stmts.sDestDropIndex = transferTable2.Stmts.sDestDropIndex + string4;
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
        }
        catch (IOException iOException) {
            throw new DataAccessPointException(iOException.getMessage());
        }
    }

    Vector getTables(String string, String[] stringArray) throws DataAccessPointException {
        Vector vector = new Vector();
        if (this.DbStmts == null) {
            this.DbStmts = new Hashtable();
        }
        if (this.WTextRead != null) {
            try {
                this.WTextRead.close();
                this.WTextRead = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.parseFileForTables();
        this.StructureAlreadyParsed = false;
        Enumeration enumeration = this.DbStmts.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    void getTableStructure(TransferTable transferTable, DataAccessPoint dataAccessPoint) throws DataAccessPointException {
        if (!this.StructureAlreadyParsed) {
            if (this.WTextRead != null) {
                try {
                    this.WTextRead.close();
                    this.WTextRead = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.parseFileForTheRest(transferTable, dataAccessPoint);
        }
    }

    TransferResultSet getData(String string) throws DataAccessPointException {
        String string2 = "";
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (!stringTokenizer.nextToken().toUpperCase().equals("FROM")) {
            }
            string2 = stringTokenizer.nextToken(" ;");
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new DataAccessPointException("Table name not found in statement: " + string);
        }
        if (this.WTextRead != null) {
            try {
                this.WTextRead.close();
                this.WTextRead = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.parseFileForData(string2);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    TransferResultSet parseFileForData(String var1_1) throws DataAccessPointException {
        var2_2 = new TransferResultSet();
        if (this.WTextRead == null) {
            try {
                this.WTextRead = new BufferedReader(new FileReader(this.sFileName));
            }
            catch (IOException var4_3) {
                throw new DataAccessPointException(var4_3.getMessage());
            }
        }
        var4_4 = "";
        try {
            block12: while (true) {
                if ((var4_4 = this.WTextRead.readLine()) == null) {
                    return var2_2;
                }
                var4_4 = var4_4.trim() + ";";
                var3_5 = new StringTokenizer(var4_4);
                try {
                    var5_6 = var3_5.nextToken();
                }
                catch (NoSuchElementException var6_7) {
                    continue;
                }
                if (var5_6 == null || !var5_6.toUpperCase().equals("INSERT")) continue;
                try {
                    if (!var3_5.nextToken().toUpperCase().equals("INTO")) {
                        throw new DataAccessPointException("Error in INSERT statement: no INTO found");
                    }
                    var5_6 = var3_5.nextToken();
                    if (!var5_6.equals(var1_1)) continue;
                    var6_8 = 0;
                    var7_11 = new Vector<String>();
                    var8_12 = new Vector<String>();
                    var9_13 = new Vector<Integer>();
lbl30:
                    // 2 sources

                    while (true) {
                        block22: {
                            if ((var4_4 = this.WTextRead.readLine()) == null) continue block12;
                            v0 = var10_14 = (var4_4 = var4_4.trim()).length() == 0;
                            if (!var10_14) break block22;
                            var11_15 = 0;
                            ++var6_8;
                            var11_15 = var7_11.size();
                            var12_16 = new String[var11_15 + 1];
                            var13_18 = new int[var11_15 + 1];
                            var14_20 = new Object[var11_15 + 1];
                            var15_21 = 0;
                            if (true) ** GOTO lbl83
                        }
                        var3_5 = new StringTokenizer(var4_4);
                        var5_6 = var3_5.nextToken("=");
                        if (var5_6.equals("Number of Rows")) {
                            var11_15 = Integer.parseInt(var3_5.nextToken());
                            if (var11_15 == var6_8) return var2_2;
                            throw new DataAccessPointException("Number of parsed rows (" + var6_8 + ") is different from the expected (" + var11_15 + ")");
                        }
                        if (var5_6.equals("column")) {
                            var5_6 = var3_5.nextToken(" =");
                            var7_11.addElement(var5_6);
                        }
                        if ((var5_6 = var3_5.nextToken(" =")).equals("datatype")) {
                            var5_6 = var3_5.nextToken(" =");
                            try {
                                var11_15 = this.JDBCT.toInt(var5_6.toUpperCase());
                            }
                            catch (Exception var12_17) {
                                throw new DataAccessPointException("Unknown type: " + var5_6);
                            }
                            var9_13.addElement(new Integer(var11_15));
                        }
                        if (!(var5_6 = var3_5.nextToken(" =")).equals("value")) continue;
                        var11_15 = var4_4.indexOf("value=") + 6;
                        var12_16 = var4_4.substring(var11_15).trim();
                        if (var12_16.indexOf("<null>") >= 0) {
                            var8_12.addElement(null);
                            continue;
                        }
                        var13_19 = var12_16.indexOf(39) + 1;
                        var14_20 = var12_16.substring(var13_19);
                        var13_19 = var14_20.lastIndexOf(39);
                        var14_20 = var14_20.substring(0, var13_19);
                        var5_6 = var14_20.toString();
                        var8_12.addElement(var5_6);
                        continue;
                        break;
                    }
                }
                catch (IndexOutOfBoundsException var6_9) {
                    // empty catch block
                    continue;
                }
                break;
            }
        }
        catch (IOException var6_10) {
            throw new DataAccessPointException(var6_10.getMessage());
        }
        do {
            var12_16[var15_21 + 1] = (String)var7_11.elementAt(var15_21);
            var13_18[var15_21 + 1] = (Integer)var9_13.elementAt(var15_21);
            var14_20[var15_21 + 1] = var8_12.elementAt(var15_21);
            ++var15_21;
lbl83:
            // 2 sources

        } while (var15_21 < var11_15);
        try {
            var2_2.addRow((String[])var12_16, var13_18, (Object[])var14_20, var11_15);
        }
        catch (Exception var16_22) {
            throw new DataAccessPointException(var16_22.getMessage());
        }
        var11_15 = 0;
        var7_11.removeAllElements();
        var8_12.removeAllElements();
        var9_13.removeAllElements();
        ** while (true)
    }

    class ColumnDef {
        String columnName = "";
        String columnType = "";
        String options = "";
        int start = 0;
        int len = 0;
    }
}

