/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.hsqldb.Column;
import org.hsqldb.HsqlProperties;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Trace;
import org.hsqldb.lib.AsciiStringInputStream;
import org.hsqldb.lib.StringInputStream;

public class jdbcResultSet
implements ResultSet,
ResultSetMetaData {
    private Result rResult;
    private Record nCurrent;
    private int iCurrentRow;
    private int iUpdateCount;
    private boolean bInit;
    private int iColumnCount;
    private boolean bWasNull;
    private boolean getColumnName = true;
    private boolean strictMetaData = false;
    private HsqlProperties connProperties;
    Statement sqlStatement;
    int rsType = 1003;

    public boolean next() throws SQLException {
        this.bWasNull = false;
        if (this.rResult == null) {
            return false;
        }
        if (this.rResult.rRoot == null) {
            return false;
        }
        if (!this.bInit) {
            this.nCurrent = this.rResult.rRoot;
            this.bInit = true;
            this.iCurrentRow = 1;
        } else {
            if (this.nCurrent == null) {
                return false;
            }
            this.nCurrent = this.nCurrent.next;
            ++this.iCurrentRow;
        }
        if (this.nCurrent == null) {
            this.iCurrentRow = 0;
            return false;
        }
        return true;
    }

    public void close() throws SQLException {
        this.iUpdateCount = -1;
        this.rResult = null;
    }

    public boolean wasNull() throws SQLException {
        return this.bWasNull;
    }

    public String getString(int n) throws SQLException {
        Object object;
        this.checkAvailable();
        try {
            object = this.nCurrent.data[--n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw Trace.error(28, ++n);
        }
        this.checkNull(object);
        return object == null ? null : object.toString();
    }

    public boolean getBoolean(int n) throws SQLException {
        Object object = this.getColumnInType(n, -7);
        return object == null ? false : (Boolean)object;
    }

    public byte getByte(int n) throws SQLException {
        Object object = this.getColumnInType(n, 5);
        return object == null ? (byte)0 : ((Number)object).byteValue();
    }

    public short getShort(int n) throws SQLException {
        Object object = this.getColumnInType(n, 5);
        return object == null ? (short)0 : ((Number)object).shortValue();
    }

    public int getInt(int n) throws SQLException {
        Object object = this.getColumnInType(n, 4);
        return object == null ? 0 : ((Number)object).intValue();
    }

    public long getLong(int n) throws SQLException {
        Object object = this.getColumnInType(n, -5);
        return object == null ? 0L : ((Number)object).longValue();
    }

    public float getFloat(int n) throws SQLException {
        Object object = this.getColumnInType(n, 7);
        return object == null ? 0.0f : ((Number)object).floatValue();
    }

    public double getDouble(int n) throws SQLException {
        Object object = this.getColumnInType(n, 8);
        return object == null ? 0.0 : ((Number)object).doubleValue();
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = (BigDecimal)this.getColumnInType(n, 3);
        if (n2 < 0) {
            throw Trace.error(62);
        }
        if (bigDecimal != null) {
            bigDecimal.setScale(n2, 5);
        }
        return bigDecimal;
    }

    public byte[] getBytes(int n) throws SQLException {
        Object object = this.getObject(n);
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return ((String)object).getBytes();
        }
        object = this.getColumnInType(--n, -2);
        return (byte[])object;
    }

    public Date getDate(int n) throws SQLException {
        return (Date)this.getColumnInType(n, 91);
    }

    public Time getTime(int n) throws SQLException {
        return (Time)this.getColumnInType(n, 92);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return (Timestamp)this.getColumnInType(n, 93);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new AsciiStringInputStream(string);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new StringInputStream(string);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        return this.wasNull() ? null : new ByteArrayInputStream(byArray);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return null;
    }

    public void clearWarnings() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
    }

    public String getCursorName() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this;
    }

    public Object getObject(int n) throws SQLException {
        Object object;
        this.checkAvailable();
        try {
            object = this.nCurrent.data[--n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw Trace.error(28, ++n);
        }
        this.checkNull(object);
        return object;
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace(string);
        }
        int n = 0;
        while (n < this.iColumnCount) {
            if (string.equalsIgnoreCase(this.rResult.sLabel[n])) {
                return n + 1;
            }
            ++n;
        }
        throw Trace.error(28);
    }

    public Reader getCharacterStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new StringReader(string);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return (BigDecimal)this.getColumnInType(n, 3);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public boolean isBeforeFirst() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return !this.bInit;
    }

    public boolean isAfterLast() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (!this.bInit) {
            return false;
        }
        return this.nCurrent == null;
    }

    public boolean isFirst() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return this.iCurrentRow == 1;
    }

    public boolean isLast() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (!this.bInit || this.nCurrent == null) {
            return false;
        }
        return this.nCurrent.next == null;
    }

    public void beforeFirst() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.getType() == 1003) {
            throw Trace.error(51);
        }
        this.bInit = false;
        this.nCurrent = null;
        this.iCurrentRow = 0;
    }

    public void afterLast() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.getType() == 1003) {
            throw Trace.error(51);
        }
        if (this.rResult != null && this.rResult.rRoot != null) {
            this.bInit = true;
            this.iCurrentRow = 0;
            this.nCurrent = null;
        }
    }

    public boolean first() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.getType() == 1003) {
            throw Trace.error(51);
        }
        if (this.rResult == null) {
            return false;
        }
        this.bInit = false;
        if (this.rResult.rRoot != null) {
            this.bInit = true;
            this.nCurrent = this.rResult.rRoot;
            this.iCurrentRow = 1;
        }
        return this.bInit;
    }

    public boolean last() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.getType() == 1003) {
            throw Trace.error(51);
        }
        if (this.rResult == null) {
            return false;
        }
        if (this.rResult.rRoot == null) {
            return false;
        }
        if (!this.bInit | this.nCurrent == null) {
            this.first();
        }
        while (this.nCurrent.next != null) {
            ++this.iCurrentRow;
            this.nCurrent = this.nCurrent.next;
        }
        return true;
    }

    public int getRow() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return this.iCurrentRow;
    }

    public boolean absolute(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.getType() == 1003) {
            throw Trace.error(51);
        }
        if (this.rResult == null) {
            return false;
        }
        if (this.rResult.rRoot == null || n == 0) {
            return false;
        }
        switch (n) {
            case 1: {
                return this.first();
            }
            case -1: {
                return this.last();
            }
        }
        if (n < 0) {
            this.last();
            n = this.iCurrentRow + n + 1;
            if (n <= 0) {
                this.beforeFirst();
                return false;
            }
        }
        if (n < this.iCurrentRow || this.iCurrentRow == 0) {
            this.beforeFirst();
        }
        while (n > this.iCurrentRow) {
            this.next();
            if (this.nCurrent == null) break;
        }
        return this.nCurrent != null;
    }

    /*
     * Unable to fully structure code
     */
    public boolean relative(int var1_1) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.getType() == 1003) {
            throw Trace.error(51);
        }
        if (this.rResult == null) {
            return false;
        }
        if (this.rResult.rRoot == null || this.bInit && this.iCurrentRow == 0) {
            return false;
        }
        if (var1_1 >= 0) ** GOTO lbl17
        var1_1 = this.iCurrentRow + var1_1;
        this.beforeFirst();
        if (var1_1 > 0) ** GOTO lbl17
        return false;
lbl-1000:
        // 1 sources

        {
            this.next();
            if (this.nCurrent == null) break;
lbl17:
            // 3 sources

            ** while (var1_1-- > 0)
        }
lbl18:
        // 2 sources

        return this.nCurrent != null;
    }

    public boolean previous() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.getType() == 1003) {
            throw Trace.error(51);
        }
        if (this.rResult == null) {
            return false;
        }
        if (this.rResult.rRoot == null || this.iCurrentRow == 0) {
            return false;
        }
        if (this.bInit && this.nCurrent == null) {
            return this.last();
        }
        int n = this.iCurrentRow - 1;
        if (n == 0) {
            this.beforeFirst();
            return false;
        }
        this.first();
        while (n != this.iCurrentRow) {
            this.nCurrent = this.nCurrent.next;
            ++this.iCurrentRow;
        }
        return this.nCurrent != null;
    }

    public void setFetchDirection(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace(n);
        }
        if (this.rsType == 1003 && n != 1000) {
            throw this.getNotSupported();
        }
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public void setFetchSize(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace(n);
        }
    }

    public int getFetchSize() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return 1;
    }

    public int getType() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return this.rsType;
    }

    public int getConcurrency() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return 1007;
    }

    public boolean rowUpdated() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return false;
    }

    public boolean rowInserted() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return false;
    }

    public void updateNull(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace(n);
        }
        throw this.getNotSupported();
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public void updateByte(int n, byte by) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public void updateShort(int n, short s) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public void updateInt(int n, int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public void updateLong(int n, long l) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public void updateFloat(int n, float f) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public void updateDouble(int n, double d) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public void updateString(int n, String string) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public void updateDate(int n, Date date) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public void updateTime(int n, Time time) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public void updateObject(int n, Object object) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void insertRow() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public void updateRow() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public void deleteRow() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public void refreshRow() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public void cancelRowUpdates() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public void moveToInsertRow() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public void moveToCurrentRow() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
    }

    public Statement getStatement() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return this.sqlStatement;
    }

    public Object getObject(int n, Map map) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public Ref getRef(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public Blob getBlob(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public Clob getClob(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public Array getArray(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public int getColumnCount() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        return this.iColumnCount;
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.strictMetaData) {
            throw this.getNotSupported();
        }
        return false;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.strictMetaData) {
            throw this.getNotSupported();
        }
        return true;
    }

    public boolean isSearchable(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.strictMetaData) {
            throw this.getNotSupported();
        }
        return true;
    }

    public boolean isCurrency(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkColumn(n);
        return false;
    }

    public int isNullable(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.strictMetaData) {
            return 2;
        }
        return 1;
    }

    public boolean isSigned(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkColumn(n);
        int n2 = this.rResult.colType[n - 1];
        int n3 = 0;
        while (n3 < Column.numericTypes.length) {
            if (n2 == Column.numericTypes[n3]) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkColumn(n);
        return 0;
    }

    public String getColumnLabel(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkColumn(n);
        return this.rResult.sLabel[--n];
    }

    public String getColumnName(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkColumn(n);
        if (this.getColumnName) {
            return this.rResult.sName[--n];
        }
        return this.rResult.sLabel[--n];
    }

    public String getSchemaName(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkColumn(n);
        return "";
    }

    public int getPrecision(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkColumn(n);
        return 0;
    }

    public int getScale(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkColumn(n);
        return 0;
    }

    public String getTableName(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkColumn(n);
        return this.rResult.sTable[--n];
    }

    public String getCatalogName(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkColumn(n);
        return "";
    }

    public int getColumnType(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkColumn(n);
        return this.rResult.colType[--n];
    }

    public String getColumnTypeName(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        this.checkColumn(n);
        return Column.getTypeString(this.rResult.colType[--n]);
    }

    public boolean isReadOnly(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.strictMetaData) {
            throw this.getNotSupported();
        }
        return false;
    }

    public boolean isWritable(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.strictMetaData) {
            throw this.getNotSupported();
        }
        return true;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.strictMetaData) {
            throw this.getNotSupported();
        }
        return true;
    }

    public String getColumnClassName(int n) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        throw this.getNotSupported();
    }

    private SQLException getNotSupported() {
        return Trace.error(20);
    }

    private SQLException getNotSupportedJDBC3() {
        return Trace.error(20, "JDBC3");
    }

    private void checkAvailable() throws SQLException {
        if (this.rResult == null || !this.bInit || this.nCurrent == null) {
            throw Trace.error(35);
        }
    }

    private void checkColumn(int n) throws SQLException {
        if (n < 1 || n > this.iColumnCount) {
            throw Trace.error(28, n);
        }
    }

    private void checkNull(Object object) {
        this.bWasNull = object == null;
    }

    private Object getColumnInType(int n, int n2) throws SQLException {
        Object object;
        int n3;
        this.checkAvailable();
        try {
            n3 = this.rResult.colType[--n];
            object = this.nCurrent.data[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw Trace.error(28, ++n);
        }
        this.checkNull(object);
        if (n2 == n3) {
            return object;
        }
        try {
            return Column.convertObject(object, n2);
        }
        catch (Exception exception) {
            String string = "type: " + Column.getTypeString(n3) + " (" + n3 + ") expected: " + Column.getTypeString(n2) + " value: " + object.toString();
            throw Trace.error(16, string);
        }
    }

    jdbcResultSet(Result result, HsqlProperties hsqlProperties) throws SQLException {
        this.connProperties = hsqlProperties;
        if (hsqlProperties != null) {
            this.getColumnName = hsqlProperties.isPropertyTrue("jdbc.get_column_name", true);
            this.strictMetaData = hsqlProperties.isPropertyTrue("jdbc.strict_md", false);
        }
        if (result.iMode == 0) {
            this.iUpdateCount = result.iUpdateCount;
        } else {
            if (result.iMode == 1) {
                throw Trace.getError(result.sError, result.errorCode);
            }
            this.iUpdateCount = -1;
            this.rResult = result;
            this.iColumnCount = result.getColumnCount();
        }
        this.bWasNull = false;
    }

    int getUpdateCount() {
        return this.iUpdateCount;
    }

    boolean isResult() {
        return this.rResult != null;
    }
}

