/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import org.hsqldb.StringConverter;
import org.hsqldb.Trace;

class ByteArray {
    private ByteArray() {
    }

    static byte[] hexToByteArray(String string) throws SQLException {
        return StringConverter.hexToByte(string);
    }

    static int compareTo(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        int n2 = byArray2.length;
        int n3 = 0;
        while (true) {
            int n4 = 0;
            int n5 = 0;
            if (n3 < n) {
                n4 = byArray[n3] & 0xFF;
            } else if (n3 >= n2) {
                return 0;
            }
            if (n3 < n2) {
                n5 = byArray2[n3] & 0xFF;
            }
            if (n4 > n5) {
                return 1;
            }
            if (n5 > n4) {
                return -1;
            }
            ++n3;
        }
    }

    static byte[] serialize(Object object) throws SQLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            throw Trace.error(18, exception.getMessage());
        }
    }

    static String serializeToString(Object object) throws SQLException {
        return StringConverter.byteToHex(ByteArray.serialize(object));
    }

    static Object deserialize(byte[] byArray) throws SQLException {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            return objectInputStream.readObject();
        }
        catch (Exception exception) {
            throw Trace.error(18, exception.getMessage());
        }
    }

    public static String toString(byte[] byArray) {
        return StringConverter.byteToHex(byArray);
    }
}

