/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.util.JRClassLoader;
import org.apache.commons.collections.ReferenceMap;

public class JRSingletonCache {
    private final ReferenceMap cache = new ReferenceMap();
    private final Class itf;

    public JRSingletonCache(Class itf) {
        this.itf = itf;
    }

    public synchronized Object getCachedInstance(String className) throws JRException {
        Object instance = this.cache.get((Object)className);
        if (instance == null) {
            try {
                Class clazz = JRClassLoader.loadClassForName(className);
                if (this.itf != null && !this.itf.isAssignableFrom(clazz)) {
                    throw new JRException("Class \"" + className + "\" should be compatible with \"" + this.itf.getName() + "\"");
                }
                instance = clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new JRException("Class " + className + " not found.", e);
            }
            catch (InstantiationException e) {
                throw new JRException("Error instantiating class " + className + ".", e);
            }
            catch (IllegalAccessException e) {
                throw new JRException("Error instantiating class " + className + ".", e);
            }
            this.cache.put((Object)className, instance);
        }
        return instance;
    }
}

