/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.VerifierCodeVisitor;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.parser.RuntimeParserException;
import org.objectweb.asm.Constants;

public class Verifier
implements GroovyClassVisitor,
Constants {
    public static final String __TIMESTAMP = "__timeStamp";
    private ClassNode classNode;
    private MethodNode methodNode;

    public ClassNode getClassNode() {
        return this.classNode;
    }

    public MethodNode getMethodNode() {
        return this.methodNode;
    }

    public void visitClass(ClassNode node) {
        this.classNode = node;
        this.addDefaultParameterMethods(node);
        if (!node.isDerivedFromGroovyObject()) {
            boolean addDelegateObject;
            node.addInterface(GroovyObject.class.getName());
            StaticMethodCallExpression initMetaClassCall = new StaticMethodCallExpression(ScriptBytecodeAdapter.class.getName(), "getMetaClass", VariableExpression.THIS_EXPRESSION);
            PropertyNode metaClassProperty = node.addProperty("metaClass", 1, MetaClass.class.getName(), initMetaClassCall, null, null);
            metaClassProperty.setSynthetic(true);
            FieldNode metaClassField = metaClassProperty.getField();
            metaClassField.setModifiers(metaClassField.getModifiers() | 0x80);
            FieldExpression metaClassVar = new FieldExpression(metaClassField);
            IfStatement initMetaClassField = new IfStatement(new BooleanExpression(new BinaryExpression(metaClassVar, Token.newSymbol(123, -1, -1), ConstantExpression.NULL)), new ExpressionStatement(new BinaryExpression(metaClassVar, Token.newSymbol(100, -1, -1), initMetaClassCall)), EmptyStatement.INSTANCE);
            node.addSyntheticMethod("getMetaClass", 1, MetaClass.class.getName(), Parameter.EMPTY_ARRAY, new BlockStatement(new Statement[]{initMetaClassField, new ReturnStatement(metaClassVar)}));
            String superClass = node.getSuperClass();
            boolean bl = node instanceof InnerClassNode && superClass.equals(Closure.class.getName()) || superClass.equals(GString.class.getName()) ? true : (addDelegateObject = false);
            if (!addDelegateObject) {
                node.addSyntheticMethod("invokeMethod", 1, Object.class.getName(), new Parameter[]{new Parameter(String.class.getName(), "method"), new Parameter(Object.class.getName(), "arguments")}, new BlockStatement(new Statement[]{initMetaClassField, new ReturnStatement(new MethodCallExpression(metaClassVar, "invokeMethod", new ArgumentListExpression(new Expression[]{VariableExpression.THIS_EXPRESSION, new VariableExpression("method"), new VariableExpression("arguments")})))}));
                if (!node.isScript()) {
                    node.addSyntheticMethod("getProperty", 1, Object.class.getName(), new Parameter[]{new Parameter(String.class.getName(), "property")}, new BlockStatement(new Statement[]{initMetaClassField, new ReturnStatement(new MethodCallExpression(metaClassVar, "getProperty", new ArgumentListExpression(new Expression[]{VariableExpression.THIS_EXPRESSION, new VariableExpression("property")})))}));
                    node.addSyntheticMethod("setProperty", 1, "void", new Parameter[]{new Parameter(String.class.getName(), "property"), new Parameter(Object.class.getName(), "value")}, new BlockStatement(new Statement[]{initMetaClassField, new ExpressionStatement(new MethodCallExpression(metaClassVar, "setProperty", new ArgumentListExpression(new Expression[]{VariableExpression.THIS_EXPRESSION, new VariableExpression("property"), new VariableExpression("value")})))}));
                }
            }
        }
        if (node.getDeclaredConstructors().isEmpty()) {
            ConstructorNode constructor = new ConstructorNode(1, null);
            constructor.setSynthetic(true);
            node.addConstructor(constructor);
        }
        if (!(node instanceof InnerClassNode)) {
            FieldNode timeTagField = new FieldNode(__TIMESTAMP, 9, "java.lang.Long", node.getName(), (Expression)new ConstantExpression(new Long(System.currentTimeMillis())));
            timeTagField.setSynthetic(true);
            node.addField(timeTagField);
        }
        this.addFieldInitialization(node);
        node.visitContents(this);
    }

    public void visitConstructor(ConstructorNode node) {
    }

    public void visitMethod(MethodNode node) {
        Parameter param;
        Parameter[] params;
        this.methodNode = node;
        Statement statement = node.getCode();
        if (!node.isVoidMethod()) {
            if (statement instanceof ExpressionStatement) {
                ExpressionStatement expStmt = (ExpressionStatement)statement;
                node.setCode(new ReturnStatement(expStmt.getExpression()));
            } else if (statement instanceof BlockStatement) {
                BlockStatement block = (BlockStatement)statement;
                ArrayList<ReturnStatement> list = new ArrayList<ReturnStatement>(block.getStatements());
                if (!list.isEmpty()) {
                    int idx = list.size() - 1;
                    Statement last = (Statement)list.get(idx);
                    if (last instanceof ExpressionStatement) {
                        ExpressionStatement expStmt = (ExpressionStatement)last;
                        list.set(idx, new ReturnStatement(expStmt.getExpression()));
                    } else if (!(last instanceof ReturnStatement)) {
                        list.add(new ReturnStatement(ConstantExpression.NULL));
                    }
                } else {
                    list.add(new ReturnStatement(ConstantExpression.NULL));
                }
                node.setCode(new BlockStatement(this.filterStatements(list)));
            }
        } else {
            BlockStatement newBlock = new BlockStatement();
            if (statement instanceof BlockStatement) {
                newBlock.addStatements(this.filterStatements(((BlockStatement)statement).getStatements()));
            } else {
                newBlock.addStatement(this.filterStatement(statement));
            }
            newBlock.addStatement(ReturnStatement.RETURN_NULL_OR_VOID);
            node.setCode(newBlock);
        }
        if (node.getName().equals("main") && node.isStatic() && (params = node.getParameters()).length == 1 && ((param = params[0]).getType() == null || param.getType().equals("java.lang.Object"))) {
            param.setType("java.lang.String[]");
        }
        node.getCode().visit(new VerifierCodeVisitor(this));
    }

    public void visitField(FieldNode node) {
    }

    public void visitProperty(PropertyNode node) {
        Statement setterBlock;
        String name = node.getName();
        FieldNode field = node.getField();
        String getterPrefix = "get";
        if ("boolean".equals(node.getType())) {
            getterPrefix = "is";
        }
        String getterName = getterPrefix + Verifier.capitalize(name);
        String setterName = "set" + Verifier.capitalize(name);
        Statement getterBlock = node.getGetterBlock();
        if (getterBlock == null && !node.isPrivate() && this.classNode.getGetterMethod(getterName) == null) {
            getterBlock = this.createGetterBlock(node, field);
        }
        if ((setterBlock = node.getGetterBlock()) == null && !node.isPrivate() && this.classNode.getSetterMethod(setterName) == null) {
            setterBlock = this.createSetterBlock(node, field);
        }
        if (getterBlock != null) {
            MethodNode getter = new MethodNode(getterName, node.getModifiers(), node.getType(), Parameter.EMPTY_ARRAY, getterBlock);
            getter.setSynthetic(true);
            this.classNode.addMethod(getter);
            this.visitMethod(getter);
            if ("java.lang.Boolean".equals(node.getType())) {
                String secondGetterName = "is" + Verifier.capitalize(name);
                MethodNode secondGetter = new MethodNode(secondGetterName, node.getModifiers(), node.getType(), Parameter.EMPTY_ARRAY, getterBlock);
                secondGetter.setSynthetic(true);
                this.classNode.addMethod(secondGetter);
                this.visitMethod(secondGetter);
            }
        }
        if (setterBlock != null) {
            Parameter[] setterParameterTypes = new Parameter[]{new Parameter(node.getType(), "value")};
            MethodNode setter = new MethodNode(setterName, node.getModifiers(), "void", setterParameterTypes, setterBlock);
            setter.setSynthetic(true);
            this.classNode.addMethod(setter);
            this.visitMethod(setter);
        }
    }

    protected void addDefaultParameterMethods(ClassNode node) {
        ArrayList methods = new ArrayList(node.getMethods());
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            MethodNode method = (MethodNode)iter.next();
            Parameter[] parameters = method.getParameters();
            int size = parameters.length;
            for (int i = 0; i < size; ++i) {
                Parameter parameter = parameters[i];
                Expression exp = parameter.getDefaultValue();
                if (exp == null) continue;
                this.addDefaultParameterMethod(node, method, parameters, i);
            }
        }
    }

    protected void addDefaultParameterMethod(ClassNode node, MethodNode method, Parameter[] parameters, int index) {
        Parameter[] newParams = new Parameter[index];
        System.arraycopy(parameters, 0, newParams, 0, index);
        ArgumentListExpression arguments = new ArgumentListExpression();
        int size = parameters.length;
        for (int i = 0; i < size; ++i) {
            if (i < index) {
                arguments.addExpression(new VariableExpression(parameters[i].getName()));
                continue;
            }
            Expression defaultValue = parameters[i].getDefaultValue();
            if (defaultValue == null) {
                throw new RuntimeParserException("The " + parameters[i].getName() + " parameter must have a default value", method);
            }
            arguments.addExpression(defaultValue);
        }
        MethodCallExpression expression = new MethodCallExpression(VariableExpression.THIS_EXPRESSION, method.getName(), arguments);
        Statement code = null;
        code = method.isVoidMethod() ? new ExpressionStatement(expression) : new ReturnStatement(expression);
        node.addMethod(method.getName(), method.getModifiers(), method.getReturnType(), newParams, code);
    }

    protected void addClosureCode(InnerClassNode node) {
    }

    protected void addFieldInitialization(ClassNode node) {
        Iterator iter = node.getDeclaredConstructors().iterator();
        while (iter.hasNext()) {
            this.addFieldInitialization(node, (ConstructorNode)iter.next());
        }
    }

    protected void addFieldInitialization(ClassNode node, ConstructorNode constructorNode) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        ArrayList staticStatements = new ArrayList();
        Iterator iter = node.getFields().iterator();
        while (iter.hasNext()) {
            this.addFieldInitialization(statements, staticStatements, constructorNode, (FieldNode)iter.next());
        }
        if (!statements.isEmpty()) {
            Statement code = constructorNode.getCode();
            ArrayList<Statement> otherStatements = new ArrayList<Statement>();
            if (code instanceof BlockStatement) {
                BlockStatement block = (BlockStatement)code;
                otherStatements.addAll(block.getStatements());
            } else if (code != null) {
                otherStatements.add(code);
            }
            if (!otherStatements.isEmpty()) {
                Statement first = (Statement)otherStatements.get(0);
                if (this.isSuperMethodCall(first)) {
                    otherStatements.remove(0);
                    statements.add(0, first);
                }
                statements.addAll(otherStatements);
            }
            constructorNode.setCode(new BlockStatement(statements));
        }
        if (!staticStatements.isEmpty()) {
            node.addStaticInitializerStatements(staticStatements);
        }
    }

    protected void addFieldInitialization(List list, List staticList, ConstructorNode constructorNode, FieldNode fieldNode) {
        Expression expression = fieldNode.getInitialValueExpression();
        if (expression != null) {
            ExpressionStatement statement = new ExpressionStatement(new BinaryExpression(new FieldExpression(fieldNode), Token.newSymbol(100, fieldNode.getLineNumber(), fieldNode.getColumnNumber()), expression));
            if (fieldNode.isStatic()) {
                staticList.add(statement);
            } else {
                list.add(statement);
            }
        }
    }

    protected boolean isSuperMethodCall(Statement first) {
        ExpressionStatement exprStmt;
        Expression expr;
        if (first instanceof ExpressionStatement && (expr = (exprStmt = (ExpressionStatement)first).getExpression()) instanceof MethodCallExpression) {
            return MethodCallExpression.isSuperMethodCall((MethodCallExpression)expr);
        }
        return false;
    }

    public static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1, name.length());
    }

    protected Statement createGetterBlock(PropertyNode propertyNode, FieldNode field) {
        FieldExpression expression = new FieldExpression(field);
        return new ReturnStatement(expression);
    }

    protected Statement createSetterBlock(PropertyNode propertyNode, FieldNode field) {
        FieldExpression expression = new FieldExpression(field);
        return new ExpressionStatement(new BinaryExpression(expression, Token.newSymbol(100, 0, 0), new VariableExpression("value")));
    }

    protected List filterStatements(List list) {
        ArrayList<Statement> answer = new ArrayList<Statement>(list.size());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            answer.add(this.filterStatement((Statement)iter.next()));
        }
        return answer;
    }

    protected Statement filterStatement(Statement statement) {
        ClosureExpression closureExp;
        ExpressionStatement expStmt;
        Expression expression;
        if (statement instanceof ExpressionStatement && (expression = (expStmt = (ExpressionStatement)statement).getExpression()) instanceof ClosureExpression && !(closureExp = (ClosureExpression)expression).isParameterSpecified()) {
            return closureExp.getCode();
        }
        return statement;
    }
}

