/*
 * Decompiled with CFR 0.152.
 */
package groovy.xml;

import groovy.util.BuilderSupport;
import groovy.xml.QName;
import java.io.IOException;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOMBuilder
extends BuilderSupport {
    Document document;
    DocumentBuilder documentBuilder;

    public static DOMBuilder newInstance() throws ParserConfigurationException, FactoryConfigurationError {
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = (DocumentBuilder)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ParserConfigurationException {
                    return DocumentBuilderFactory.newInstance().newDocumentBuilder();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ParserConfigurationException) {
                throw (ParserConfigurationException)e;
            }
            throw new RuntimeException(e);
        }
        return new DOMBuilder(documentBuilder);
    }

    public static Document parse(Reader reader) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = (DocumentBuilder)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ParserConfigurationException {
                    return DocumentBuilderFactory.newInstance().newDocumentBuilder();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ParserConfigurationException) {
                throw (ParserConfigurationException)e;
            }
            throw new RuntimeException(e);
        }
        return documentBuilder.parse(new InputSource(reader));
    }

    public DOMBuilder(Document document) {
        this.document = document;
    }

    public DOMBuilder(DocumentBuilder documentBuilder) {
        this.documentBuilder = documentBuilder;
    }

    protected void setParent(Object parent, Object child) {
        Node current = (Node)parent;
        Node node = (Node)child;
        current.appendChild(node);
    }

    protected Object createNode(Object name) {
        if (this.document == null) {
            this.document = this.createDocument();
        }
        if (name instanceof QName) {
            QName qname = (QName)name;
            return this.document.createElementNS(qname.getNamespaceURI(), qname.getQualifiedName());
        }
        return this.document.createElement(name.toString());
    }

    protected Document createDocument() {
        if (this.documentBuilder == null) {
            throw new IllegalArgumentException("No Document or DOMImplementation available so cannot create Document");
        }
        return this.documentBuilder.newDocument();
    }

    protected Object createNode(Object name, Object value) {
        Element element = (Element)this.createNode(name);
        element.appendChild(this.document.createTextNode(value.toString()));
        return element;
    }

    protected Object createNode(Object name, Map attributes, Object value) {
        Element element = (Element)this.createNode(name, attributes);
        element.appendChild(this.document.createTextNode(value.toString()));
        return element;
    }

    protected Object createNode(Object name, Map attributes) {
        Element element = (Element)this.createNode(name);
        Iterator iter = attributes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String attrName = entry.getKey().toString();
            Object value = entry.getValue();
            if ("xmlns".equals(attrName)) {
                if (value instanceof Map) {
                    this.appendNamespaceAttributes(element, (Map)value);
                    continue;
                }
                throw new IllegalArgumentException("The value of the xmlns attribute must be a Map of QNames to String URIs");
            }
            element.setAttribute(attrName, value.toString());
        }
        return element;
    }

    protected void appendNamespaceAttributes(Element element, Map attributes) {
        Iterator iter = attributes.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                throw new IllegalArgumentException("The value of key: " + key + " cannot be null");
            }
            if (key instanceof String) {
                String prefix = (String)key;
                element.setAttributeNS("", prefix, value.toString());
                continue;
            }
            if (key instanceof QName) {
                QName qname = (QName)key;
                element.setAttributeNS(qname.getNamespaceURI(), qname.getQualifiedName(), value.toString());
                continue;
            }
            throw new IllegalArgumentException("The key: " + key + " should be an instanceof of " + QName.class);
        }
    }
}

