/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks;

import com.jgoodies.looks.FontPolicy;
import com.jgoodies.looks.FontSet;
import com.jgoodies.looks.FontSets;
import com.jgoodies.looks.Fonts;
import com.jgoodies.looks.LookUtils;
import java.awt.Font;
import javax.swing.UIDefaults;
import javax.swing.plaf.FontUIResource;

public final class FontPolicies {
    private FontPolicies() {
    }

    public static FontPolicy createFixedPolicy(FontSet fontSet) {
        return new FixedPolicy(fontSet);
    }

    public static FontPolicy customSettingsPolicy(FontPolicy defaultPolicy) {
        return new CustomSettingsPolicy(defaultPolicy);
    }

    public static FontPolicy getDefaultPlasticOnWindowsPolicy() {
        return new DefaultPlasticOnWindowsPolicy();
    }

    public static FontPolicy getDefaultPlasticPolicy() {
        if (LookUtils.IS_OS_WINDOWS) {
            return FontPolicies.getDefaultPlasticOnWindowsPolicy();
        }
        return FontPolicies.getLogicalFontsPolicy();
    }

    public static FontPolicy getDefaultWindowsPolicy() {
        return new DefaultWindowsPolicy();
    }

    public static FontPolicy getLogicalFontsPolicy() {
        return FontPolicies.createFixedPolicy(FontSets.getLogicalFontSet());
    }

    public static FontPolicy getLooks1xPlasticPolicy() {
        Font controlFont;
        Font menuFont = controlFont = Fonts.getDefaultGUIFontWesternModernWindowsNormal();
        Font titleFont = controlFont.deriveFont(1);
        FontSet fontSet = FontSets.createDefaultFontSet(controlFont, menuFont, titleFont);
        return FontPolicies.createFixedPolicy(fontSet);
    }

    public static FontPolicy getLooks1xWindowsPolicy() {
        Font controlFont = Fonts.getLooks1xWindowsControlFont();
        FontSet fontSet = FontSets.createDefaultFontSet(controlFont);
        return FontPolicies.createFixedPolicy(fontSet);
    }

    public static FontPolicy getTransitionalPlasticPolicy() {
        return LookUtils.IS_OS_WINDOWS ? FontPolicies.getDefaultPlasticOnWindowsPolicy() : FontPolicies.getLooks1xPlasticPolicy();
    }

    private static FontSet getCustomFontSet(String lafName) {
        String controlFontKey = lafName + ".controlFont";
        String menuFontKey = lafName + ".menuFont";
        String decodedControlFont = LookUtils.getSystemProperty(controlFontKey);
        if (decodedControlFont == null) {
            return null;
        }
        Font controlFont = Font.decode(decodedControlFont);
        String decodedMenuFont = LookUtils.getSystemProperty(menuFontKey);
        Font menuFont = decodedMenuFont != null ? Font.decode(decodedMenuFont) : null;
        Font titleFont = "Plastic".equals(lafName) ? controlFont.deriveFont(1) : controlFont;
        return FontSets.createDefaultFontSet(controlFont, menuFont, titleFont);
    }

    private static FontPolicy getCustomPolicy(String lafName) {
        return null;
    }

    private static final class FixedPolicy
    implements FontPolicy {
        private final FontSet fontSet;

        FixedPolicy(FontSet fontSet) {
            this.fontSet = fontSet;
        }

        public FontSet getFontSet(String lafName, UIDefaults table) {
            return this.fontSet;
        }
    }

    private static final class DefaultWindowsPolicy
    implements FontPolicy {
        private DefaultWindowsPolicy() {
        }

        public FontSet getFontSet(String lafName, UIDefaults table) {
            FontUIResource controlFont = new FontUIResource(Fonts.getWindowsControlFont());
            FontUIResource menuFont = table == null ? controlFont : (FontUIResource)table.getFont("Menu.font");
            FontUIResource titleFont = controlFont;
            FontUIResource messageFont = table == null ? controlFont : (FontUIResource)table.getFont("OptionPane.font");
            FontUIResource smallFont = table == null ? new FontUIResource(controlFont.deriveFont(controlFont.getSize() - 2)) : (FontUIResource)table.getFont("ToolTip.font");
            FontUIResource windowTitleFont = table == null ? controlFont : (FontUIResource)table.getFont("InternalFrame.titleFont");
            return FontSets.createDefaultFontSet(controlFont, menuFont, titleFont, messageFont, smallFont, windowTitleFont);
        }
    }

    private static final class DefaultPlasticOnWindowsPolicy
    implements FontPolicy {
        private DefaultPlasticOnWindowsPolicy() {
        }

        public FontSet getFontSet(String lafName, UIDefaults table) {
            Font controlFont = Fonts.getWindowsControlFont();
            Font menuFont = table == null ? controlFont : (FontUIResource)table.getFont("Menu.font");
            Font titleFont = controlFont.deriveFont(1);
            return FontSets.createDefaultFontSet(controlFont, menuFont, titleFont);
        }
    }

    private static final class CustomSettingsPolicy
    implements FontPolicy {
        private final FontPolicy wrappedPolicy;

        CustomSettingsPolicy(FontPolicy wrappedPolicy) {
            this.wrappedPolicy = wrappedPolicy;
        }

        public FontSet getFontSet(String lafName, UIDefaults table) {
            FontPolicy customPolicy = FontPolicies.getCustomPolicy(lafName);
            if (customPolicy != null) {
                return customPolicy.getFontSet(null, table);
            }
            FontSet customFontSet = FontPolicies.getCustomFontSet(lafName);
            if (customFontSet != null) {
                return customFontSet;
            }
            return this.wrappedPolicy.getFontSet(null, table);
        }
    }
}

