/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.pe.res;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Enumeration;
import java.util.Hashtable;
import net.charabia.jsmoothgen.pe.PEFile;

public class ResIcon {
    public long Size;
    public long Width;
    public long Height;
    public int Planes;
    public int BitsPerPixel;
    public long Compression;
    public long SizeOfBitmap;
    public long HorzResolution;
    public long VertResolution;
    public long ColorsUsed;
    public long ColorsImportant;
    public PaletteElement[] Palette;
    public short[] BitmapXOR;
    public short[] BitmapAND;

    public ResIcon(ByteBuffer in) {
        this.Size = in.getInt();
        this.Width = in.getInt();
        this.Height = in.getInt();
        this.Planes = in.getShort();
        this.BitsPerPixel = in.getShort();
        this.Compression = in.getInt();
        this.SizeOfBitmap = in.getInt();
        this.HorzResolution = in.getInt();
        this.VertResolution = in.getInt();
        this.ColorsUsed = in.getInt();
        this.ColorsImportant = in.getInt();
        int cols = (int)this.ColorsUsed;
        if (cols == 0) {
            cols = 1 << this.BitsPerPixel;
        }
        this.Palette = new PaletteElement[cols];
        for (int i = 0; i < this.Palette.length; ++i) {
            PaletteElement el = new PaletteElement();
            el.Blue = in.get();
            el.Green = in.get();
            el.Red = in.get();
            el.Reserved = in.get();
            this.Palette[i] = el;
        }
        int xorbytes = (int)this.Height / 2 * (int)this.Width;
        this.BitmapXOR = new short[xorbytes];
        block5: for (int i = 0; i < this.BitmapXOR.length; ++i) {
            switch (this.BitsPerPixel) {
                case 4: {
                    byte pix = in.get();
                    this.BitmapXOR[i] = (short)(pix >> 4 & 0xF);
                    this.BitmapXOR[++i] = (short)(pix & 0xF);
                    continue block5;
                }
                case 8: {
                    this.BitmapXOR[i] = in.get();
                }
            }
        }
        int height = (int)(this.Height / 2L);
        int rowsize = (int)this.Width / 8;
        if (rowsize % 4 > 0) {
            rowsize += 4 - rowsize % 4;
        }
        int andbytes = height * rowsize;
        this.BitmapAND = new short[andbytes];
        for (int i = 0; i < this.BitmapAND.length; ++i) {
            this.BitmapAND[i] = in.get();
        }
    }

    public ResIcon(Image img) throws Exception {
        int width = img.getWidth(null);
        int height = img.getHeight(null);
        if (width % 8 != 0) {
            width += 7 - width % 8;
        }
        if (height % 8 != 0) {
            height += 7 - height % 8;
        }
        if (img instanceof BufferedImage) {
            BufferedImage result = (BufferedImage)img;
            for (int y = 0; y < result.getHeight(); ++y) {
                for (int x = 0; x < result.getWidth(); ++x) {
                    int rgb = result.getRGB(x, y);
                    if ((rgb >> 24 & 0xFF) <= 0) continue;
                }
            }
        }
        int[] pixelbuffer = new int[width * height];
        PixelGrabber grabber = new PixelGrabber(img, 0, 0, width, height, pixelbuffer, 0, width);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            throw new Exception("Can't load the image provided", e);
        }
        Hashtable colors = this.calculateColorCount(pixelbuffer);
        this.BitsPerPixel = 8;
        this.Palette = new PaletteElement[1 << this.BitsPerPixel];
        Enumeration e = colors.keys();
        while (e.hasMoreElements()) {
            Integer pixi = (Integer)e.nextElement();
            int pix = pixi;
            int index = (Integer)colors.get(pixi);
            this.Palette[index] = new PaletteElement();
            this.Palette[index].Blue = pix & 0xFF;
            this.Palette[index].Green = pix >> 8 & 0xFF;
            this.Palette[index].Red = pix >> 16 & 0xFF;
        }
        for (int i = 0; i < this.Palette.length; ++i) {
            if (this.Palette[i] != null) continue;
            this.Palette[i] = new PaletteElement();
        }
        this.Size = 40L;
        this.Width = width;
        this.Height = height * 2;
        this.Planes = 1;
        this.Compression = 0L;
        this.SizeOfBitmap = 0L;
        this.HorzResolution = 0L;
        this.VertResolution = 0L;
        this.ColorsUsed = 0L;
        this.ColorsImportant = 0L;
        int rowsize = width / 8;
        if (rowsize % 4 > 0) {
            rowsize += 4 - rowsize % 4;
        }
        this.BitmapXOR = new short[(int)this.Height / 2 * (int)this.Width * this.BitsPerPixel / 8];
        this.BitmapAND = new short[(int)this.Height / 2 * rowsize];
        int bxl = this.BitmapXOR.length - 1;
        int bal = this.BitmapAND.length - 1;
        for (int i = 0; i < pixelbuffer.length; ++i) {
            int col = i % width;
            int line = i / width;
            bxl = width * height - (i / width + 1) * width + i % width;
            bal = rowsize * height - (line + 1) * rowsize + col / 8;
            if ((pixelbuffer[i] >> 24 & 0xFF) == 0) {
                int n = bal;
                this.BitmapAND[n] = (short)(this.BitmapAND[n] | 1 << 7 - i % 8);
                this.BitmapXOR[bxl] = 255;
                continue;
            }
            int pixel = pixelbuffer[i] & 0xFFFFFF;
            Integer icol = (Integer)colors.get(new Integer(pixel));
            if (icol == null) continue;
            int palindex = icol;
            this.BitmapXOR[bxl] = (short)palindex;
        }
    }

    private int getBrightest() {
        int result = 0;
        int averesult = 0;
        for (int i = 0; i < this.Palette.length; ++i) {
            int ave1 = (this.Palette[0].Red + this.Palette[0].Green + this.Palette[0].Blue) / 3;
            if (ave1 <= averesult) continue;
            averesult = ave1;
            result = i;
        }
        return result;
    }

    private Hashtable calculateColorCount(int[] pixels) {
        Hashtable<Integer, Integer> result = new Hashtable<Integer, Integer>();
        int colorindex = 0;
        for (int i = 0; i < pixels.length; ++i) {
            Integer pixi;
            Object o;
            int pix = pixels[i];
            if ((pix >> 24 & 0xFF) <= 0 || (o = result.get(pixi = new Integer(pix &= 0xFFFFFF))) != null) continue;
            result.put(pixi, new Integer(colorindex++));
        }
        return result;
    }

    public ByteBuffer getData() {
        int i;
        int rowsize;
        int cols = (int)this.ColorsUsed;
        if (cols == 0) {
            cols = 1 << this.BitsPerPixel;
        }
        if ((rowsize = (int)this.Width / 8) % 4 > 0) {
            rowsize += 4 - rowsize % 4;
        }
        ByteBuffer buf = ByteBuffer.allocate((int)((long)(40 + cols * 4) + this.Width * (this.Height / 2L) * (long)this.BitsPerPixel / 8L + (long)rowsize * (this.Height / 2L)));
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.position(0);
        buf.putInt((int)this.Size);
        buf.putInt((int)this.Width);
        buf.putInt((int)this.Height);
        buf.putShort((short)this.Planes);
        buf.putShort((short)this.BitsPerPixel);
        buf.putInt((int)this.Compression);
        buf.putInt((int)this.SizeOfBitmap);
        buf.putInt((int)this.HorzResolution);
        buf.putInt((int)this.VertResolution);
        buf.putInt((int)this.ColorsUsed);
        buf.putInt((int)this.ColorsImportant);
        for (i = 0; i < this.Palette.length; ++i) {
            PaletteElement el = this.Palette[i];
            buf.put((byte)el.Blue);
            buf.put((byte)el.Green);
            buf.put((byte)el.Red);
            buf.put((byte)el.Reserved);
        }
        switch (this.BitsPerPixel) {
            case 4: {
                for (i = 0; i < this.BitmapXOR.length; i += 2) {
                    short v1 = this.BitmapXOR[i];
                    short v2 = this.BitmapXOR[i + 1];
                    buf.put((byte)(v1 << 4 | v2));
                }
                break;
            }
            case 8: {
                for (i = 0; i < this.BitmapXOR.length; ++i) {
                    buf.put((byte)this.BitmapXOR[i]);
                }
                break;
            }
            default: {
                throw new RuntimeException("BitRes " + this.BitsPerPixel + " not supported!");
            }
        }
        for (i = 0; i < this.BitmapAND.length; ++i) {
            buf.put((byte)this.BitmapAND[i]);
        }
        buf.position(0);
        return buf;
    }

    public String toString() {
        int i;
        StringBuffer out = new StringBuffer();
        out.append("Size: " + this.Size);
        out.append("\nWidth: " + this.Width);
        out.append("\nHeight: " + this.Height);
        out.append("\nPlanes: " + this.Planes);
        out.append("\nBitsPerPixel: " + this.BitsPerPixel);
        out.append("\nCompression: " + this.Compression);
        out.append("\nSizeOfBitmap: " + this.SizeOfBitmap);
        out.append("\nHorzResolution: " + this.HorzResolution);
        out.append("\nVertResolution: " + this.VertResolution);
        out.append("\nColorsUsed: " + this.ColorsUsed);
        out.append("\nColorsImportant: " + this.ColorsImportant);
        out.append("\nBitmapXOR[" + this.BitmapXOR.length + "]={");
        for (i = 0; i < this.BitmapXOR.length; ++i) {
            out.append((byte)this.BitmapXOR[i]);
        }
        out.append("}\nBitmapAnd[" + this.BitmapAND.length + "]={");
        for (i = 0; i < this.BitmapAND.length; ++i) {
            out.append((byte)this.BitmapAND[i]);
        }
        return out.toString();
    }

    public static void main(String[] args) throws Exception {
        PEFile.main(args);
    }

    public class PaletteElement {
        public int Blue;
        public int Green;
        public int Red;
        public int Reserved;

        public String toString() {
            return "{" + this.Blue + "," + this.Green + "," + this.Red + "," + this.Reserved + "}";
        }
    }
}

