/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.application.gui.editors;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import javax.swing.JComboBox;
import net.charabia.jsmoothgen.application.JSmoothModelBean;
import net.charabia.jsmoothgen.application.gui.Editor;
import net.charabia.jsmoothgen.application.gui.Main;
import net.charabia.jsmoothgen.application.gui.util.HTMLPane;
import net.charabia.jsmoothgen.application.gui.util.PanelLayout;
import net.charabia.jsmoothgen.skeleton.SkeletonBean;

public class SkeletonChooser
extends Editor
implements JSmoothModelBean.SkeletonChangedListener {
    private JComboBox m_skelcombo = new JComboBox();
    private HTMLPane m_skeldesc = new HTMLPane(){

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            if (d.height < 100) {
                d.height = 100;
            }
            return d;
        }
    };

    public SkeletonChooser() {
        PanelLayout pl = new PanelLayout();
        this.setLayout(pl);
        this.m_skelcombo.addItem("<none>");
        Iterator i = Main.SKELETONS.getIteratorNoDebugName();
        while (i.hasNext()) {
            this.m_skelcombo.addItem(i.next().toString());
        }
        this.add(this.m_skelcombo);
        this.add(this.m_skeldesc);
        this.m_skelcombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SkeletonChooser.this.updateModel();
                SkeletonChooser.this.doLayout();
                SkeletonChooser.this.validate();
                SkeletonChooser.this.repaint();
            }
        });
    }

    private void updateSkeletonData() {
        String skelname = (String)this.m_skelcombo.getSelectedItem();
        if (skelname == null) {
            return;
        }
        SkeletonBean skel = Main.SKELETONS.getSkeleton(skelname);
        System.out.println("SKEL: " + skel.toString());
        if (skel != null) {
            this.m_skeldesc.setText(skel.getDescription());
        }
    }

    public void dataChanged() {
        String skelname = this.m_model.getSkeletonName();
        if (skelname != null) {
            SkeletonBean skel = Main.SKELETONS.getSkeleton(skelname);
            if (skel != null) {
                this.m_skeldesc.setText(skel.getDescription());
                this.m_skelcombo.setSelectedItem(skelname);
            } else {
                this.m_skelcombo.setSelectedItem("");
                this.m_skeldesc.setText("");
            }
        } else {
            this.m_skelcombo.setSelectedItem("");
            this.m_skeldesc.setText("<none>");
        }
    }

    public void updateModel() {
        String skelname = (String)this.m_skelcombo.getSelectedItem();
        if (skelname == null) {
            return;
        }
        if (skelname.equals("<none>")) {
            skelname = "<none>";
        }
        this.m_model.setSkeletonName(skelname);
    }

    public String getLabel() {
        return "SKELETONCHOOSER_LABEL";
    }

    public String getDescription() {
        return "SKELETONCHOOSER_HELP";
    }

    public void skeletonChanged() {
        this.dataChanged();
    }
}

