/*
 * Decompiled with CFR 0.152.
 */
package net.charabia.jsmoothgen.ant;

import java.io.File;
import net.charabia.jsmoothgen.application.ExeCompiler;
import net.charabia.jsmoothgen.application.JSmoothModelBean;
import net.charabia.jsmoothgen.application.JSmoothModelPersistency;
import net.charabia.jsmoothgen.skeleton.SkeletonBean;
import net.charabia.jsmoothgen.skeleton.SkeletonList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class JSmoothGen
extends Task {
    private File m_prjfile;
    private File m_skeletonRoot;
    private boolean verbose;

    public void setProject(File prjfile) {
        this.m_prjfile = prjfile;
    }

    public void setSkeletonRoot(File skeletonRoot) {
        this.m_skeletonRoot = skeletonRoot;
    }

    public void setVerbose(boolean val) {
        this.verbose = val;
    }

    public void execute() throws BuildException {
        if (this.m_prjfile == null) {
            throw new BuildException("Project file not set");
        }
        if (this.m_skeletonRoot == null) {
            throw new BuildException("Skeleton Root dir file not set");
        }
        File prj = this.m_prjfile;
        if (!prj.exists()) {
            prj = new File(prj.toString() + ".jsmooth");
        }
        if (!prj.exists()) {
            throw new BuildException("Project file " + prj + " not found");
        }
        try {
            JSmoothModelBean model = JSmoothModelPersistency.load(prj);
            File basedir = prj.getParentFile();
            SkeletonList skelList = new SkeletonList(this.m_skeletonRoot);
            File out = new File(basedir, model.getExecutableName());
            SkeletonBean skel = skelList.getSkeleton(model.getSkeletonName());
            File skelroot = skelList.getDirectory(skel);
            ExeCompiler compiler = new ExeCompiler();
            if (this.verbose) {
                compiler.addListener(new ExeCompiler.StepListener(){

                    public void complete() {
                    }

                    public void failed() {
                    }

                    public void setNewState(int percentComplete, String state) {
                        JSmoothGen.this.log("jsmooth: " + state + " ( " + percentComplete + "%)");
                    }
                });
            }
            if (compiler.compile(skelroot, skel, basedir, model, out)) {
                this.log("Java application wrapped in " + model.getExecutableName());
            } else {
                this.log("jsmoothgen failed: " + compiler.getErrors());
            }
        }
        catch (Exception exc) {
            throw new BuildException("Error building the jsmooth wrapper", (Throwable)exc);
        }
    }
}

