/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel.borders;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.controlpanel.DrawRoutines;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;

public class TinyTextFieldBorder
extends AbstractBorder
implements UIResource {
    private Insets insets;

    public TinyTextFieldBorder() {
        this.insets = Theme.textInsets[Theme.style];
    }

    public TinyTextFieldBorder(Insets insets) {
        this.insets = insets;
    }

    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinyBorder(c, g, x, y, w, h);
                break;
            }
            case 1: {
                this.drawWinBorder(c, g, x, y, w, h);
                break;
            }
            case 2: {
                this.drawXpBorder(c, g, x, y, w, h);
            }
        }
    }

    private void drawTinyBorder(Component c, Graphics g, int x, int y, int w, int h) {
    }

    private void drawWinBorder(Component c, Graphics g, int x, int y, int w, int h) {
        if (!c.isEnabled()) {
            g.setColor(Theme.textBorderDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.textBorderColor[Theme.style].getColor());
        }
        g.drawLine(x + 1, y + 1, x + w - 3, y + 1);
        g.drawLine(x + 1, y + 2, x + 1, y + h - 3);
        if (!c.isEnabled()) {
            g.setColor(Theme.textBorderDarkDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.textBorderDarkColor[Theme.style].getColor());
        }
        g.drawLine(x, y, x + w - 2, y);
        g.drawLine(x, y + 1, x, y + h - 2);
        g.setColor(Theme.backColor[Theme.style].getColor());
        g.drawLine(x + 1, y + h - 2, x + w - 2, y + h - 2);
        g.drawLine(x + w - 2, y + 1, x + w - 2, y + h - 2);
        if (!c.isEnabled()) {
            g.setColor(Theme.textBorderLightDisabledColor[Theme.style].getColor());
        } else {
            g.setColor(Theme.textBorderLightColor[Theme.style].getColor());
        }
        g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
        g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
    }

    private void drawXpBorder(Component c, Graphics g, int x, int y, int w, int h) {
        if (!c.isEnabled()) {
            DrawRoutines.drawBorder(g, Theme.textBorderDisabledColor[Theme.style].getColor(), x, y, w, h);
        } else {
            DrawRoutines.drawBorder(g, Theme.textBorderColor[Theme.style].getColor(), x, y, w, h);
        }
    }
}

