/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.SpecialUIButton;
import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyRootPaneUI;
import de.muntjak.tinylookandfeel.TinyWindowButtonUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;

class TinyTitlePane
extends JComponent {
    static int count = 0;
    private static final Border handyEmptyBorder = new EmptyBorder(0, 0, 0, 0);
    private static final int IMAGE_HEIGHT = 16;
    private static final int IMAGE_WIDTH = 16;
    private static TinyWindowButtonUI iconButtonUI;
    private static TinyWindowButtonUI maxButtonUI;
    private static TinyWindowButtonUI closeButtonUI;
    private PropertyChangeListener propertyChangeListener;
    private JMenuBar menuBar;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    private JButton toggleButton;
    private JButton iconifyButton;
    private JButton closeButton;
    private WindowListener windowListener;
    private ComponentListener windowMoveListener;
    private Window window;
    private JRootPane rootPane;
    private int buttonsWidth;
    private int state;
    private TinyRootPaneUI rootPaneUI;

    public TinyTitlePane(JRootPane root, TinyRootPaneUI ui) {
        this.rootPane = root;
        this.rootPaneUI = ui;
        this.state = -1;
        this.installSubcomponents();
        this.installDefaults();
        this.setLayout(this.createLayout());
    }

    private void uninstall() {
        this.uninstallListeners();
        this.window = null;
        this.removeAll();
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = this.createWindowListener();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = this.createWindowPropertyChangeListener();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
            this.windowMoveListener = new WindowMoveListener();
            this.window.addComponentListener(this.windowMoveListener);
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window.removePropertyChangeListener(this.propertyChangeListener);
            this.window.removeComponentListener(this.windowMoveListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            this.setActive(this.window.isActive());
            this.installListeners();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.window = null;
    }

    private void installSubcomponents() {
        if (this.getWindowDecorationStyle() == 1) {
            this.createActions();
            this.menuBar = this.createMenuBar();
            this.add(this.menuBar);
            this.createButtons();
            this.add(this.iconifyButton);
            this.add(this.toggleButton);
            this.add(this.closeButton);
            this.iconifyButton.putClientProperty("externalFrameButton", Boolean.TRUE);
            this.toggleButton.putClientProperty("externalFrameButton", Boolean.TRUE);
            this.closeButton.putClientProperty("externalFrameButton", Boolean.TRUE);
        } else if (this.getWindowDecorationStyle() != 0) {
            this.createActions();
            this.createButtons();
            this.add(this.closeButton);
            this.closeButton.putClientProperty("externalFrameButton", Boolean.FALSE);
        }
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont", this.getLocale()));
    }

    private void uninstallDefaults() {
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new SystemMenuBar();
        this.menuBar.setFocusable(false);
        this.menuBar.setBorderPainted(true);
        this.menuBar.add(this.createMenu());
        return this.menuBar;
    }

    private void close() {
        Window window = this.getWindow();
        if (window != null) {
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    private void iconify() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(frame.getExtendedState() | 1);
        }
    }

    private void maximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            this.setMaximizeBounds(frame);
            frame.setExtendedState(frame.getExtendedState() | 6);
        }
    }

    protected void setMaximizeBounds(Frame frame) {
        if (frame.getMaximizedBounds() != null) {
            return;
        }
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(frame.getGraphicsConfiguration());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = screenInsets.top;
        int y = screenInsets.left;
        int w = screenSize.width - x - screenInsets.right;
        int h = screenSize.height - y - screenInsets.bottom;
        Rectangle maxBounds = new Rectangle(x, y, w, h);
        frame.setMaximizedBounds(maxBounds);
    }

    private void restore() {
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if ((frame.getExtendedState() & 1) == 1) {
            frame.setExtendedState(this.state & 0xFFFFFFFE);
        } else {
            frame.setExtendedState(this.state & 0xFFFFFFF9);
        }
    }

    private void createActions() {
        this.closeAction = new CloseAction();
        this.iconifyAction = new IconifyAction();
        this.restoreAction = new RestoreAction();
        this.maximizeAction = new MaximizeAction();
    }

    private JMenu createMenu() {
        JMenu menu = new JMenu("");
        if (this.getWindowDecorationStyle() == 1) {
            this.addMenuItems(menu);
            menu.putClientProperty("isSystemMenu", Boolean.TRUE);
        }
        return menu;
    }

    private void addMenuItems(JMenu menu) {
        this.getRootPane().getLocale();
        JMenuItem mi = menu.add(this.restoreAction);
        int mnemonic = this.getInt("MetalTitlePane.restoreMnemonic", -1);
        if (mnemonic != -1) {
            mi.setMnemonic(mnemonic);
        }
        mi = menu.add(this.iconifyAction);
        mnemonic = this.getInt("MetalTitlePane.iconifyMnemonic", -1);
        if (mnemonic != -1) {
            mi.setMnemonic(mnemonic);
        }
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            mi = menu.add(this.maximizeAction);
            mnemonic = this.getInt("MetalTitlePane.maximizeMnemonic", -1);
            if (mnemonic != -1) {
                mi.setMnemonic(mnemonic);
            }
        }
        menu.addSeparator();
        mi = menu.add(this.closeAction);
        mnemonic = this.getInt("MetalTitlePane.closeMnemonic", -1);
        if (mnemonic != -1) {
            mi.setMnemonic(mnemonic);
        }
    }

    protected void createButtons() {
        if (iconButtonUI == null) {
            iconButtonUI = TinyWindowButtonUI.createButtonUIForType(2);
            maxButtonUI = TinyWindowButtonUI.createButtonUIForType(1);
            closeButtonUI = TinyWindowButtonUI.createButtonUIForType(0);
        }
        this.iconifyButton = new SpecialUIButton(iconButtonUI);
        this.iconifyButton.setAction(this.iconifyAction);
        this.iconifyButton.setRolloverEnabled(true);
        this.toggleButton = new SpecialUIButton(maxButtonUI);
        this.toggleButton.setAction(this.maximizeAction);
        this.toggleButton.setRolloverEnabled(true);
        this.closeButton = new SpecialUIButton(closeButtonUI);
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setRolloverEnabled(true);
        this.closeButton.getAccessibleContext().setAccessibleName("Close");
        this.iconifyButton.getAccessibleContext().setAccessibleName("Iconify");
        this.toggleButton.getAccessibleContext().setAccessibleName("Maximize");
    }

    private LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean isActive) {
        if (this.getWindowDecorationStyle() == 1) {
            Boolean activeB = isActive ? Boolean.TRUE : Boolean.FALSE;
            this.iconifyButton.putClientProperty("paintActive", activeB);
            this.closeButton.putClientProperty("paintActive", activeB);
            this.toggleButton.putClientProperty("paintActive", activeB);
            this.iconifyButton.setEnabled(isActive);
            this.closeButton.setEnabled(isActive);
            this.toggleButton.setEnabled(isActive);
        }
        this.getRootPane().repaint();
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    private void setState(int state, boolean updateRegardless) {
        Window w = this.getWindow();
        if (w != null && this.getWindowDecorationStyle() == 1) {
            if (this.state == state && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                JRootPane rootPane = this.getRootPane();
                if ((state & 6) != 6 || rootPane.getBorder() != null && !(rootPane.getBorder() instanceof UIResource) || !frame.isShowing()) {
                    // empty if block
                }
                if (frame.isResizable()) {
                    if ((state & 4) == 4 || (state & 2) == 2) {
                        this.updateToggleButton(this.restoreAction);
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        this.updateToggleButton(this.maximizeAction);
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.toggleButton.getParent() == null || this.iconifyButton.getParent() == null) {
                        this.add(this.toggleButton);
                        this.add(this.iconifyButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.toggleButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.toggleButton.getParent() != null) {
                        this.remove(this.toggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.toggleButton);
                this.remove(this.iconifyButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = state;
        }
    }

    private void updateToggleButton(Action action) {
        this.toggleButton.setAction(action);
        this.toggleButton.setText(null);
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private Window getWindow() {
        return this.window;
    }

    private String getTitle() {
        Window w = this.getWindow();
        if (w instanceof Frame) {
            return ((Frame)w).getTitle();
        }
        if (w instanceof Dialog) {
            return ((Dialog)w).getTitle();
        }
        return null;
    }

    public boolean isSelected() {
        Window window = this.getWindow();
        return window == null ? true : window.isActive();
    }

    public boolean isFrameMaximized() {
        Frame frame = this.getFrame();
        if (frame != null) {
            return (frame.getExtendedState() & 6) == 6;
        }
        return false;
    }

    public void paintComponent(Graphics g) {
        String theTitle;
        int xOffset;
        Window window;
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        boolean leftToRight = (window = this.getWindow()) == null ? this.getRootPane().getComponentOrientation().isLeftToRight() : window.getComponentOrientation().isLeftToRight();
        boolean isSelected = window == null ? true : window.isActive();
        int width = this.getWidth();
        int height = this.getHeight();
        int n = xOffset = leftToRight ? 5 : width - 5;
        if (this.getWindowDecorationStyle() == 1) {
            xOffset += leftToRight ? 21 : -21;
        }
        if ((theTitle = this.getTitle()) != null) {
            UIManager.getFont("InternalFrame.normalTitleFont");
            FontMetrics fm = g.getFontMetrics();
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            Rectangle rect = new Rectangle(0, 0, 0, 0);
            if (this.iconifyButton != null && this.iconifyButton.getParent() != null) {
                rect = this.iconifyButton.getBounds();
            }
            if (leftToRight) {
                if (rect.x == 0) {
                    rect.x = window.getWidth() - window.getInsets().right - 2;
                }
                int titleW = rect.x - xOffset - 4;
                theTitle = this.clippedText(theTitle, fm, titleW);
            } else {
                int titleW = xOffset - rect.x - rect.width - 4;
                theTitle = this.clippedText(theTitle, fm, titleW);
                xOffset -= SwingUtilities.computeStringWidth(fm, theTitle);
            }
            int titleLength = SwingUtilities.computeStringWidth(fm, theTitle);
            if (isSelected) {
                g.setColor(Theme.frameTitleColor[Theme.style].getColor());
                g.drawString(theTitle, xOffset, yOffset);
            } else {
                g.setColor(Theme.frameTitleDisabledColor[Theme.style].getColor());
                g.drawString(theTitle, xOffset, yOffset);
            }
            xOffset += leftToRight ? titleLength + 5 : -5;
        }
    }

    private String clippedText(String text, FontMetrics fm, int availTextWidth) {
        if (text == null || text.equals("")) {
            return "";
        }
        int textWidth = SwingUtilities.computeStringWidth(fm, text);
        String clipString = "...";
        if (textWidth > availTextWidth) {
            int totalWidth = SwingUtilities.computeStringWidth(fm, clipString);
            int nChars = 0;
            while (nChars < text.length()) {
                if ((totalWidth += fm.charWidth(text.charAt(nChars))) > availTextWidth) break;
                ++nChars;
            }
            text = String.valueOf(text.substring(0, nChars)) + clipString;
        }
        return text;
    }

    private int getInt(Object key, int defaultValue) {
        Object value = UIManager.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(UIManager.getString((Object)"MetalTitlePane.closeTitle", TinyTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e) {
            TinyTitlePane.this.close();
        }
    }

    private class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(UIManager.getString((Object)"MetalTitlePane.iconifyTitle", TinyTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e) {
            TinyTitlePane.this.iconify();
        }
    }

    private class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(UIManager.getString((Object)"MetalTitlePane.restoreTitle", TinyTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e) {
            TinyTitlePane.this.restore();
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(UIManager.getString((Object)"MetalTitlePane.maximizeTitle", TinyTitlePane.this.getLocale()));
        }

        public void actionPerformed(ActionEvent e) {
            TinyTitlePane.this.maximize();
        }
    }

    private class SystemMenuBar
    extends JMenuBar {
        SystemMenuBar() {
        }

        public void paint(Graphics g) {
            Image image;
            Frame frame = TinyTitlePane.this.getFrame();
            Image image2 = image = frame != null ? frame.getIconImage() : null;
            if (image != null) {
                g.drawImage(image, 0, 0, 16, 16, null);
            } else {
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                if (icon != null) {
                    icon.paintIcon(this, g, 0, 0);
                }
            }
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Icon icon = UIManager.getIcon("InternalFrame.icon");
            if (icon != null) {
                return new Dimension(icon.getIconWidth(), icon.getIconHeight());
            }
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(16, size.width), Math.max(size.height, 16));
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        TitlePaneLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(104, this.computeHeight());
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        private int computeHeight() {
            if (TinyTitlePane.this.getFrame() instanceof JFrame) {
                TinyTitlePane.this.setMaximizeBounds(TinyTitlePane.this.getFrame());
                return Theme.frameTitleHeight[Theme.derivedStyle[Theme.style]];
            }
            return Theme.frameInternalTitleHeight[Theme.derivedStyle[Theme.style]];
        }

        public void layoutContainer(Container c) {
            int buttonWidth;
            int buttonHeight;
            if (TinyTitlePane.this.getWindowDecorationStyle() == 0) {
                TinyTitlePane.this.buttonsWidth = 0;
                return;
            }
            boolean leftToRight = TinyTitlePane.this.window == null ? TinyTitlePane.this.getRootPane().getComponentOrientation().isLeftToRight() : TinyTitlePane.this.window.getComponentOrientation().isLeftToRight();
            int w = TinyTitlePane.this.getWidth();
            if (TinyTitlePane.this.closeButton != null) {
                buttonHeight = ((TinyTitlePane)TinyTitlePane.this).closeButton.getPreferredSize().height;
                buttonWidth = ((TinyTitlePane)TinyTitlePane.this).closeButton.getPreferredSize().width;
            } else {
                buttonHeight = 16;
                buttonWidth = 16;
            }
            int y = (TinyTitlePane.this.getHeight() - buttonHeight) / 2 + 1;
            if (Theme.derivedStyle[Theme.style] == 1) {
                ++y;
            }
            int x = leftToRight ? w : 0;
            int spacing = 5;
            int n = x = leftToRight ? spacing : w - buttonWidth - spacing;
            if (TinyTitlePane.this.menuBar != null) {
                TinyTitlePane.this.menuBar.setBounds(x, y, buttonWidth, buttonHeight);
            }
            x = leftToRight ? w : 0;
            spacing = 2;
            x += leftToRight ? -spacing - buttonWidth : spacing;
            if (TinyTitlePane.this.closeButton != null) {
                TinyTitlePane.this.closeButton.setBounds(x, y, buttonWidth, buttonHeight);
            }
            if (!leftToRight) {
                x += buttonWidth;
            }
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && TinyTitlePane.this.toggleButton.getParent() != null) {
                TinyTitlePane.this.toggleButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            if (TinyTitlePane.this.iconifyButton != null && TinyTitlePane.this.iconifyButton.getParent() != null) {
                TinyTitlePane.this.iconifyButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            TinyTitlePane.this.buttonsWidth = leftToRight ? w - x : x;
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("resizable".equals(name) || "state".equals(name)) {
                Frame frame = TinyTitlePane.this.getFrame();
                if (frame != null) {
                    TinyTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(name)) {
                    TinyTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                TinyTitlePane.this.repaint();
            } else if ("componentOrientation".equals(name)) {
                TinyTitlePane.this.revalidate();
                TinyTitlePane.this.repaint();
            }
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowActivated(WindowEvent ev) {
            TinyTitlePane.this.setActive(true);
        }

        public void windowDeactivated(WindowEvent ev) {
            TinyTitlePane.this.setActive(false);
        }
    }

    class WindowMoveListener
    extends ComponentAdapter {
        WindowMoveListener() {
        }

        public void componentMoved(ComponentEvent e) {
            if (TinyTitlePane.this.getWindowDecorationStyle() == 0) {
                return;
            }
            Window w = TinyTitlePane.this.getWindow();
            if (!w.isShowing()) {
                return;
            }
            w.repaint(0, 0, w.getWidth(), 5);
        }

        public void componentResized(ComponentEvent e) {
            if (TinyTitlePane.this.getWindowDecorationStyle() == 0) {
                return;
            }
            Window w = TinyTitlePane.this.getWindow();
            if (!w.isShowing()) {
                return;
            }
            w.repaint(0, 0, w.getWidth(), 5);
        }
    }
}

