/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.barbecue;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.barbecue.Barcode;
import net.sourceforge.barbecue.output.OutputException;

public final class BarcodeImageHandler {
    private BarcodeImageHandler() {
    }

    public static BufferedImage getImage(Barcode barcode) throws OutputException {
        BufferedImage bufferedImage = new BufferedImage(barcode.getWidth(), barcode.getHeight(), 13);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        barcode.draw(graphics2D, 0, 0);
        bufferedImage.flush();
        return bufferedImage;
    }

    public static void outputBarcodeAsJPEGImage(Barcode barcode, OutputStream outputStream) throws OutputException {
        BarcodeImageHandler.outputImage(barcode, outputStream);
    }

    private static void outputImage(Barcode barcode, OutputStream outputStream) throws OutputException {
        BufferedImage bufferedImage = BarcodeImageHandler.getImage(barcode);
        JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)outputStream);
        try {
            jPEGImageEncoder.encode(bufferedImage, jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage));
        }
        catch (IOException iOException) {
            throw new OutputException(iOException.getMessage(), iOException);
        }
    }
}

