/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.command;

import it.businesslogic.ireport.IReportFont;
import it.businesslogic.ireport.TextReportElement;
import it.businesslogic.ireport.TransformationType;
import it.businesslogic.ireport.gui.command.FormatCommand;
import it.businesslogic.ireport.util.PageSize;
import java.awt.Point;

public class FormatCommandShrink
extends FormatCommand {
    double reduction;
    String formatOneDown;

    FormatCommandShrink() {
        this.operationType = 44;
    }

    FormatCommandShrink(int operationType) {
        this.operationType = operationType;
        this.setTreatAllElements(true);
    }

    void preparation() {
        double marginSpace = this.jrf.getReport().getLeftMargin();
        marginSpace += (double)this.jrf.getReport().getRightMargin();
        int pageWidth = this.jrf.getReport().getWidth();
        int pageHeight = this.jrf.getReport().getHeight();
        this.formatOneDown = PageSize.findOneDown(pageWidth, pageHeight);
        int newWidth = PageSize.getFormatSize((String)this.formatOneDown).x;
        pageWidth = this.jrf.getReport().getWidth() < this.jrf.getReport().getHeight() ? this.jrf.getReport().getWidth() : this.jrf.getReport().getHeight();
        this.reduction = ((double)newWidth - marginSpace) / ((double)pageWidth - marginSpace);
    }

    void modify() {
        int newWidth;
        double innerX = this.re.getPosition().x - this.jrf.getReport().getLeftMargin() - 10;
        double innerY = this.re.getPosition().y - this.jrf.getReport().getBandYLocation(this.re.band) - 10;
        innerX = innerX * this.reduction + (double)this.jrf.getReport().getLeftMargin() + 10.0;
        innerY = innerY * this.reduction + (double)this.jrf.getReport().getBandYLocation(this.re.band) + 10.0;
        if (this.re.getPosition().x + this.re.getWidth() - 10 == this.jrf.getReport().getWidth() - this.jrf.getReport().getRightMargin()) {
            int oneDownWidth = PageSize.getFormatSize((String)this.formatOneDown).x;
            int oneDownHeight = PageSize.getFormatSize((String)this.formatOneDown).y;
            int width = this.jrf.getReport().getWidth() < this.jrf.getReport().getHeight() ? oneDownWidth : oneDownHeight;
            newWidth = width - this.jrf.getReport().getRightMargin() - (int)innerX + 10;
        } else {
            newWidth = (int)((double)this.re.getWidth() * this.reduction);
        }
        int newHeight = (int)((double)this.re.getHeight() * this.reduction);
        this.re.setPosition(new Point((int)innerX, (int)innerY));
        this.re.trasform(new Point(newWidth - this.re.getWidth(), newHeight - this.re.getHeight()), TransformationType.TRANSFORMATION_RESIZE_SE);
        if (this.re instanceof TextReportElement) {
            IReportFont iReportFont = ((TextReportElement)this.re).getIReportFont();
            int fontSize = iReportFont.getFontSize();
            fontSize = Math.max(1, (int)((double)fontSize * this.reduction));
            iReportFont.setFontSize(fontSize);
            ((TextReportElement)this.re).setIReportFont(iReportFont);
        }
    }

    void executeDeeper() {
        this.resetEnumeration();
        this.preparation();
        this.processElements();
        if (this.jrf.getReport().getElements().size() == this.getSelectedElements().size() && !this.formatOneDown.equals("Custom")) {
            this.undoOp.addElement(this.jrf);
            this.jrf.getReport().setReportFormat(this.formatOneDown);
            int oneDownWidth = PageSize.getFormatSize((String)this.formatOneDown).x;
            int oneDownHeight = PageSize.getFormatSize((String)this.formatOneDown).y;
            if (this.jrf.getReport().getOrientation().equals("Portrait")) {
                this.jrf.getReport().setWidth(oneDownWidth);
                this.jrf.getReport().setHeight(oneDownHeight);
                this.jrf.getReport().recalcColumnWidth();
            } else {
                this.jrf.getReport().setWidth(oneDownHeight);
                this.jrf.getReport().setHeight(oneDownWidth);
                this.jrf.getReport().recalcColumnWidth();
            }
            this.undoOp.captureUniqueModified(this.jrf);
        }
    }
}

