/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.box;

import it.businesslogic.ireport.Box;
import it.businesslogic.ireport.ReportElement;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import javax.swing.JPanel;

public class SampleBoxPanel
extends JPanel {
    private Box box;

    public SampleBoxPanel() {
        this.initComponents();
        this.setBackground(Color.WHITE);
        this.setBox(new Box());
    }

    public Box getBox() {
        return this.box;
    }

    public void setBox(Box box) {
        this.box = box;
        this.invalidate();
        this.repaint();
    }

    public void refresh() {
        this.invalidate();
        this.repaint();
    }

    public void paint(Graphics g2) {
        Stroke stroke;
        Graphics2D g = (Graphics2D)g2;
        g.clearRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.LIGHT_GRAY);
        Stroke oldStroke = g.getStroke();
        Color oldColor = g.getColor();
        g.fillRect(10, 10, this.getWidth() - 20, this.getHeight() - 20);
        if (!this.getBox().getLeftBorder().equals("None")) {
            stroke = ReportElement.getPenStroke(this.getBox().getLeftBorder(), 1.0);
            g.setStroke(stroke);
            g.setColor(this.getBox().getLeftBorderColor());
            g.drawLine(10, 10, 10, this.getHeight() - 10);
        }
        if (!this.getBox().getRightBorder().equals("None")) {
            stroke = ReportElement.getPenStroke(this.getBox().getRightBorder(), 1.0);
            g.setStroke(stroke);
            g.setColor(this.getBox().getRightBorderColor());
            g.drawLine(this.getWidth() - 10, 10, this.getWidth() - 10, this.getHeight() - 10);
        }
        if (!this.getBox().getTopBorder().equals("None")) {
            stroke = ReportElement.getPenStroke(this.getBox().getTopBorder(), 1.0);
            g.setStroke(stroke);
            g.setColor(this.getBox().getTopBorderColor());
            g.drawLine(10, 10, this.getWidth() - 10, 10);
        }
        if (!this.getBox().getBottomBorder().equals("None")) {
            stroke = ReportElement.getPenStroke(this.getBox().getBottomBorder(), 1.0);
            g.setStroke(stroke);
            g.setColor(this.getBox().getBottomBorderColor());
            g.drawLine(10, this.getHeight() - 10, this.getWidth() - 10, this.getHeight() - 10);
        }
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

