/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.type.BooleanType;

public abstract class CharBooleanType
extends BooleanType {
    protected abstract String getTrueString();

    protected abstract String getFalseString();

    public Object get(ResultSet rs, String name) throws SQLException {
        String code = rs.getString(name);
        if (code == null || code.length() == 0) {
            return null;
        }
        return this.getTrueString().equalsIgnoreCase(code.trim()) ? Boolean.TRUE : Boolean.FALSE;
    }

    public void set(PreparedStatement st, Object value, int index) throws SQLException {
        st.setString(index, this.toCharacter(value));
    }

    public int sqlType() {
        return 1;
    }

    private String toCharacter(Object value) {
        return (Boolean)value != false ? this.getTrueString() : this.getFalseString();
    }

    public String objectToSQLString(Object value) throws Exception {
        return "'" + this.toCharacter(value) + "'";
    }

    public Object stringToObject(String xml) throws Exception {
        if (this.getTrueString().equalsIgnoreCase(xml)) {
            return Boolean.TRUE;
        }
        if (this.getFalseString().equalsIgnoreCase(xml)) {
            return Boolean.FALSE;
        }
        throw new HibernateException("Could not interpret: " + xml);
    }
}

