/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Properties;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.hibernate.HibernateException;
import org.hibernate.transaction.TransactionManagerLookup;
import org.hibernate.util.NamingHelper;

public class WebSphereExtendedJTATransactionLookup
implements TransactionManagerLookup {
    public TransactionManager getTransactionManager(Properties props) throws HibernateException {
        return new TransactionManagerAdapter(props);
    }

    public String getUserTransactionName() {
        return "java:comp/UserTransaction";
    }

    public static class TransactionManagerAdapter
    implements TransactionManager {
        private final Properties properties;
        private final Class synchronizationCallbackClass;
        private final Method registerSynchronizationMethod;
        private final Method getLocalIdMethod;

        private TransactionManagerAdapter(Properties props) {
            this.properties = props;
            try {
                this.synchronizationCallbackClass = Class.forName("com.ibm.websphere.jtaextensions.SynchronizationCallback");
                Class<?> extendedJTATransactionClass = Class.forName("com.ibm.websphere.jtaextensions.ExtendedJTATransaction");
                this.registerSynchronizationMethod = extendedJTATransactionClass.getMethod("registerSynchronizationCallbackForCurrentTran", this.synchronizationCallbackClass);
                this.getLocalIdMethod = extendedJTATransactionClass.getMethod("getLocalId", null);
            }
            catch (ClassNotFoundException cnfe) {
                throw new HibernateException(cnfe);
            }
            catch (NoSuchMethodException nsme) {
                throw new HibernateException(nsme);
            }
        }

        public void begin() throws NotSupportedException, SystemException {
            throw new UnsupportedOperationException();
        }

        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            throw new UnsupportedOperationException();
        }

        public int getStatus() throws SystemException {
            throw new UnsupportedOperationException();
        }

        public Transaction getTransaction() throws SystemException {
            return new TransactionAdapter(this.properties);
        }

        public void resume(Transaction txn) throws InvalidTransactionException, IllegalStateException, SystemException {
            throw new UnsupportedOperationException();
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            throw new UnsupportedOperationException();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            throw new UnsupportedOperationException();
        }

        public void setTransactionTimeout(int i) throws SystemException {
            throw new UnsupportedOperationException();
        }

        public Transaction suspend() throws SystemException {
            throw new UnsupportedOperationException();
        }

        public class TransactionAdapter
        implements Transaction {
            private final Object extendedJTATransaction;

            private TransactionAdapter(Properties props) {
                try {
                    this.extendedJTATransaction = NamingHelper.getInitialContext(props).lookup("java:comp/websphere/ExtendedJTATransaction");
                }
                catch (NamingException ne) {
                    throw new HibernateException(ne);
                }
            }

            public void registerSynchronization(final Synchronization synchronization) throws RollbackException, IllegalStateException, SystemException {
                InvocationHandler ih = new InvocationHandler(){

                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if ("afterCompletion".equals(method.getName())) {
                            int status = args[2].equals(Boolean.TRUE) ? 3 : 5;
                            synchronization.afterCompletion(status);
                        } else if ("beforeCompletion".equals(method.getName())) {
                            synchronization.beforeCompletion();
                        } else if ("toString".equals(method.getName())) {
                            return synchronization.toString();
                        }
                        return null;
                    }
                };
                Object synchronizationCallback = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{TransactionManagerAdapter.this.synchronizationCallbackClass}, ih);
                try {
                    TransactionManagerAdapter.this.registerSynchronizationMethod.invoke(this.extendedJTATransaction, synchronizationCallback);
                }
                catch (Exception e) {
                    throw new HibernateException(e);
                }
            }

            public int hashCode() {
                return this.getLocalId().hashCode();
            }

            public boolean equals(Object other) {
                if (!(other instanceof TransactionAdapter)) {
                    return false;
                }
                TransactionAdapter that = (TransactionAdapter)other;
                return this.getLocalId().equals(that.getLocalId());
            }

            private Object getLocalId() {
                try {
                    return TransactionManagerAdapter.this.getLocalIdMethod.invoke(this.extendedJTATransaction, null);
                }
                catch (Exception e) {
                    throw new HibernateException(e);
                }
            }

            public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
                throw new UnsupportedOperationException();
            }

            public boolean delistResource(XAResource resource, int i) throws IllegalStateException, SystemException {
                throw new UnsupportedOperationException();
            }

            public boolean enlistResource(XAResource resource) throws RollbackException, IllegalStateException, SystemException {
                throw new UnsupportedOperationException();
            }

            public int getStatus() throws SystemException {
                return new Integer(0).equals(this.getLocalId()) ? 6 : 0;
            }

            public void rollback() throws IllegalStateException, SystemException {
                throw new UnsupportedOperationException();
            }

            public void setRollbackOnly() throws IllegalStateException, SystemException {
                throw new UnsupportedOperationException();
            }
        }
    }
}

