/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader;

import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.loader.DefaultEntityAliases;
import org.hibernate.loader.EntityAliases;
import org.hibernate.loader.GeneratedCollectionAliases;
import org.hibernate.loader.Loader;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.Loadable;

public abstract class BasicLoader
extends Loader {
    protected static final String[] NO_SUFFIX = new String[]{""};
    private EntityAliases[] descriptors;
    private CollectionAliases[] collectionDescriptors;

    public BasicLoader(SessionFactoryImplementor factory) {
        super(factory);
    }

    protected final EntityAliases[] getEntityAliases() {
        return this.descriptors;
    }

    protected final CollectionAliases[] getCollectionAliases() {
        return this.collectionDescriptors;
    }

    protected abstract String[] getSuffixes();

    protected abstract String[] getCollectionSuffixes();

    protected void postInstantiate() {
        Loadable[] persisters = this.getEntityPersisters();
        String[] suffixes = this.getSuffixes();
        this.descriptors = new EntityAliases[persisters.length];
        for (int i = 0; i < this.descriptors.length; ++i) {
            this.descriptors[i] = new DefaultEntityAliases(persisters[i], suffixes[i]);
        }
        CollectionPersister[] collectionPersisters = this.getCollectionPersisters();
        if (collectionPersisters != null) {
            String[] collectionSuffixes = this.getCollectionSuffixes();
            this.collectionDescriptors = new CollectionAliases[collectionPersisters.length];
            for (int i = 0; i < collectionPersisters.length; ++i) {
                this.collectionDescriptors[i] = new GeneratedCollectionAliases(collectionPersisters[i], collectionSuffixes[i]);
            }
        } else {
            this.collectionDescriptors = null;
        }
    }

    public static String[] generateSuffixes(int length) {
        return BasicLoader.generateSuffixes(0, length);
    }

    public static String[] generateSuffixes(int seed, int length) {
        if (length == 0) {
            return NO_SUFFIX;
        }
        String[] suffixes = new String[length];
        for (int i = 0; i < length; ++i) {
            suffixes[i] = Integer.toString(i + seed) + "_";
        }
        return suffixes;
    }
}

