/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentifierGeneratorFactory;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public class IncrementGenerator
implements IdentifierGenerator,
Configurable {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$id$IncrementGenerator == null ? (class$org$hibernate$id$IncrementGenerator = IncrementGenerator.class$("org.hibernate.id.IncrementGenerator")) : class$org$hibernate$id$IncrementGenerator));
    private long next;
    private String sql;
    private Class returnClass;
    static /* synthetic */ Class class$org$hibernate$id$IncrementGenerator;

    public synchronized Serializable generate(SessionImplementor session, Object object) throws HibernateException {
        if (this.sql != null) {
            this.getNext(session);
        }
        return IdentifierGeneratorFactory.createNumber(this.next++, this.returnClass);
    }

    public void configure(Type type, Properties params, Dialect d) throws MappingException {
        String tableList = params.getProperty("tables");
        if (tableList == null) {
            tableList = params.getProperty("identity_tables");
        }
        String[] tables = StringHelper.split(", ", tableList);
        String column = params.getProperty("column");
        if (column == null) {
            column = params.getProperty("target_column");
        }
        String schema = params.getProperty("schema");
        String catalog = params.getProperty("catalog");
        this.returnClass = type.getReturnedClass();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < tables.length; ++i) {
            if (tables.length > 1) {
                buf.append("select ").append(column).append(" from ");
            }
            buf.append(Table.qualify(catalog, schema, tables[i], d.getSchemaSeparator()));
            if (i >= tables.length - 1) continue;
            buf.append(" union ");
        }
        if (tables.length > 1) {
            buf.insert(0, "( ").append(" ) ids_");
            column = "ids_." + column;
        }
        this.sql = "select max(" + column + ") from " + buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getNext(SessionImplementor session) {
        Connection conn = session.connection();
        log.debug((Object)("fetching initial value: " + this.sql));
        try {
            PreparedStatement st;
            block8: {
                PersistentIdentifierGenerator.SQL.debug((Object)this.sql);
                st = conn.prepareStatement(this.sql);
                ResultSet rs = null;
                try {
                    rs = st.executeQuery();
                    if (rs.next()) {
                        this.next = rs.getLong(1) + 1L;
                        if (rs.wasNull()) {
                            this.next = 1L;
                        }
                    } else {
                        this.next = 1L;
                    }
                    this.sql = null;
                    log.debug((Object)("first free id: " + this.next));
                    Object var6_6 = null;
                    if (rs == null) break block8;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (rs != null) {
                        rs.close();
                    }
                    st.close();
                    throw throwable;
                }
                rs.close();
            }
            st.close();
            {
            }
        }
        catch (SQLException sqle) {
            throw JDBCExceptionHelper.convert(session.getFactory().getSQLExceptionConverter(), sqle, "could not fetch initial value", this.sql);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

