/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.VersionType;

public final class Versioning {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$engine$Versioning == null ? (class$org$hibernate$engine$Versioning = Versioning.class$("org.hibernate.engine.Versioning")) : class$org$hibernate$engine$Versioning));
    public static final int OPTIMISTIC_LOCK_NONE = -1;
    public static final int OPTIMISTIC_LOCK_ALL = 2;
    public static final int OPTIMISTIC_LOCK_DIRTY = 1;
    public static final int OPTIMISTIC_LOCK_VERSION = 0;
    static /* synthetic */ Class class$org$hibernate$engine$Versioning;

    private Versioning() {
    }

    public static Object increment(Object version, VersionType versionType) {
        Object next = versionType.next(version);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Incrementing: " + version + " to " + next));
        }
        return next;
    }

    private static Object seed(VersionType versionType) {
        Object seed = versionType.seed();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Seeding: " + seed));
        }
        return seed;
    }

    public static boolean seedVersion(Object[] fields, int versionProperty, VersionType versionType) {
        Object initialVersion = fields[versionProperty];
        if (initialVersion == null || initialVersion instanceof Number && ((Number)initialVersion).longValue() < 0L) {
            fields[versionProperty] = Versioning.seed(versionType);
            return true;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("using initial version: " + initialVersion));
        }
        return false;
    }

    private static Object getVersion(Object[] fields, int versionProperty) {
        return fields[versionProperty];
    }

    private static void setVersion(Object[] fields, Object version, int versionProperty) {
        fields[versionProperty] = version;
    }

    public static void setVersion(Object[] fields, Object version, EntityPersister persister) {
        Versioning.setVersion(fields, version, persister.getVersionProperty());
    }

    public static Object getVersion(Object[] fields, EntityPersister persister) throws HibernateException {
        return persister.isVersioned() ? Versioning.getVersion(fields, persister.getVersionProperty()) : null;
    }

    public static boolean isVersionIncrementRequired(int[] dirtyProperties, boolean hasDirtyCollections, boolean[] propertyVersionability) {
        if (hasDirtyCollections) {
            return true;
        }
        for (int i = 0; i < dirtyProperties.length; ++i) {
            if (!propertyVersionability[dirtyProperties[i]]) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

