/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.entry;

import java.io.Serializable;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.PreLoadEvent;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ArrayHelper;

public final class CacheEntry
implements Serializable {
    private final Serializable[] disassembledState;
    private final String subclass;
    private final boolean lazyPropertiesAreUnfetched;

    public String getSubclass() {
        return this.subclass;
    }

    public boolean areLazyPropertiesUnfetched() {
        return this.lazyPropertiesAreUnfetched;
    }

    public CacheEntry(Object[] state, EntityPersister persister, boolean unfetched, SessionImplementor session, Object owner) throws HibernateException {
        this.disassembledState = TypeFactory.disassemble(state, persister.getPropertyTypes(), session, owner);
        this.subclass = persister.getEntityName();
        this.lazyPropertiesAreUnfetched = unfetched;
    }

    CacheEntry(Serializable[] state, String subclass, boolean unfetched) {
        this.disassembledState = state;
        this.subclass = subclass;
        this.lazyPropertiesAreUnfetched = unfetched;
    }

    public Object[] assemble(Object instance, Serializable id, EntityPersister persister, Interceptor interceptor, SessionImplementor session) throws HibernateException {
        if (!persister.getEntityName().equals(this.subclass)) {
            throw new AssertionFailure("Tried to assemble a different subclass instance");
        }
        return CacheEntry.assemble(this.disassembledState, instance, id, persister, interceptor, session);
    }

    private static Object[] assemble(Serializable[] values, Object result, Serializable id, EntityPersister persister, Interceptor interceptor, SessionImplementor session) throws HibernateException {
        Object[] assembledProps = TypeFactory.assemble(values, persister.getPropertyTypes(), session, result);
        PreLoadEvent preLoadEvent = new PreLoadEvent(session).setEntity(result).setState(assembledProps).setId(id).setPersister(persister);
        session.getListeners().getPreLoadEventListener().onPreLoad(preLoadEvent);
        persister.setPropertyValues(result, assembledProps, session.getEntityMode());
        return assembledProps;
    }

    public Serializable[] getDisassembledState() {
        return this.disassembledState;
    }

    public String toString() {
        return "CacheEntry(" + this.subclass + ')' + ArrayHelper.toString(this.disassembledState);
    }
}

