/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import mondrian.olap.EnumeratedValues;
import mondrian.olap.Util;
import mondrian.util.SAXHandler;
import mondrian.xmla.Enumeration;
import mondrian.xmla.PropertyDefinition;
import mondrian.xmla.RowsetDefinition;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

abstract class Rowset {
    private static final Logger LOGGER = Logger.getLogger((Class)Rowset.class);
    private final RowsetDefinition rowsetDefinition;
    protected final HashMap restrictions;
    protected final Properties properties;
    private final RowsetDefinition.Column[] restrictedColumns;

    Rowset(RowsetDefinition definition, HashMap restrictions, Properties properties) {
        this.rowsetDefinition = definition;
        this.restrictions = restrictions;
        this.properties = properties;
        ArrayList list = new ArrayList();
        Iterator restrictionsIter = restrictions.keySet().iterator();
        while (restrictionsIter.hasNext()) {
            String restrictedColumn = (String)restrictionsIter.next();
            RowsetDefinition.Column column = definition.lookupColumn(restrictedColumn);
            if (column == null) {
                throw Util.newError("Rowset '" + definition.name + "' does not contain column '" + restrictedColumn + "'");
            }
            if (!column.restriction) {
                throw Util.newError("Rowset '" + definition.name + "' column '" + restrictedColumn + "' does not allow restrictions");
            }
            Object requiredValue = restrictions.get(column.name);
            if (!(requiredValue instanceof String)) {
                if (requiredValue instanceof String[]) {
                    RowsetDefinition.Type type = column.type;
                    switch (type.ordinal) {
                        case 1: 
                        case 4: 
                        case 7: {
                            break;
                        }
                        default: {
                            throw Util.newError("Rowset '" + definition.name + "' column '" + restrictedColumn + "' can only be restricted on one value at a time");
                        }
                    }
                } else {
                    throw Util.newInternal("Bad type of restricted value" + requiredValue);
                }
            }
            list.add(column);
        }
        list = this.pruneRestrictions(list);
        this.restrictedColumns = list.toArray(new RowsetDefinition.Column[0]);
    }

    protected void initialize() {
        Iterator<Object> propertiesIter = this.properties.keySet().iterator();
        while (propertiesIter.hasNext()) {
            String propertyName = (String)propertiesIter.next();
            PropertyDefinition propertyDef = PropertyDefinition.getValue(propertyName);
            if (propertyDef == null) {
                throw Util.newError("Rowset '" + this.rowsetDefinition.name + "' does not support property '" + propertyName + "'");
            }
            String propertyValue = this.properties.getProperty(propertyName);
            this.setProperty(propertyDef, propertyValue);
        }
    }

    protected ArrayList pruneRestrictions(ArrayList list) {
        return list;
    }

    protected void setProperty(PropertyDefinition propertyDef, String value) {
        switch (propertyDef.ordinal) {
            case 7: {
                Enumeration.Format format = Enumeration.Format.getValue(value);
                if (format == Enumeration.Format.Tabular) break;
                throw Util.newError("<Format> value '" + format + "' not supported");
            }
            case 5: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                LOGGER.warn((Object)("Warning: Rowset '" + this.rowsetDefinition.name + "' does not support property '" + propertyDef.name + "' (value is '" + value + "')"));
            }
        }
    }

    public void unparse(SAXHandler saxHandler) throws SAXException {
        this.initialize();
        this.unparseImpl(saxHandler);
    }

    protected abstract void unparseImpl(SAXHandler var1) throws SAXException;

    private static boolean haveCommonMember(String[] a, String[] b) {
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < b.length; ++j) {
                if (!a[i].equals(b[j])) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected void emit(Row row, SAXHandler saxHandler) throws SAXException {
        Object value;
        RowsetDefinition.Column column;
        int i;
        for (i = 0; i < this.restrictedColumns.length; ++i) {
            void var8_10;
            String[] values;
            String[] requiredValues;
            column = this.restrictedColumns[i];
            value = row.get(column.name);
            if (value == null) {
                return;
            }
            Object requiredValue = this.restrictions.get(column.name);
            if (requiredValue instanceof String) {
                requiredValues = new String[]{(String)requiredValue};
            } else if (requiredValue instanceof String[]) {
                requiredValues = (String[])requiredValue;
            } else {
                throw Util.newInternal("Restriction value is of wrong type: " + requiredValue);
            }
            if (value instanceof String) {
                values = new String[]{(String)value};
            } else if (value instanceof String[]) {
                values = (String[])value;
            } else {
                throw Util.newInternal("Unexpected value type: " + value);
            }
            if (Rowset.haveCommonMember(requiredValues, (String[])var8_10)) continue;
            return;
        }
        saxHandler.startElement("row");
        for (i = 0; i < this.rowsetDefinition.columnDefinitions.length; ++i) {
            int j;
            column = this.rowsetDefinition.columnDefinitions[i];
            value = row.get(column.name);
            if (value == null) {
                if (column.nullable) continue;
                throw Util.newInternal("Value required for column " + column.name + " of rowset " + this.rowsetDefinition.name);
            }
            if (value instanceof XmlElement[]) {
                XmlElement[] elements = (XmlElement[])value;
                for (j = 0; j < elements.length; ++j) {
                    this.emitXmlElement(saxHandler, elements[j]);
                }
                continue;
            }
            if (value instanceof Object[]) {
                Object[] values = (Object[])value;
                for (j = 0; j < values.length; ++j) {
                    saxHandler.startElement(column.name);
                    saxHandler.characters(values[j].toString());
                    saxHandler.endElement();
                }
                continue;
            }
            saxHandler.startElement(column.name);
            saxHandler.characters(value.toString());
            saxHandler.endElement();
        }
        saxHandler.endElement();
    }

    private void emitXmlElement(SAXHandler saxHandler, XmlElement element) throws SAXException {
        if (element.attributes == null) {
            saxHandler.startElement(element.tag);
        } else {
            saxHandler.startElement(element.tag, element.attributes);
        }
        if (element.text == null) {
            for (int i = 0; i < element.children.length; ++i) {
                this.emitXmlElement(saxHandler, element.children[i]);
            }
        } else {
            saxHandler.characters(element.text);
        }
        saxHandler.endElement();
    }

    private static boolean contains(String[] strings, String value) {
        for (int i = 0; i < strings.length; ++i) {
            if (!strings[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    protected void emit(Object row, SAXHandler saxHandler) throws SAXException {
        Object value;
        RowsetDefinition.Column column;
        int i;
        for (i = 0; i < this.restrictedColumns.length; ++i) {
            column = this.restrictedColumns[i];
            value = column.get(row);
            if (value == null) {
                return;
            }
            Object requiredValue = this.restrictions.get(column.name);
            if (requiredValue instanceof String) {
                if (value.equals(requiredValue)) continue;
                return;
            }
            if (requiredValue instanceof String[]) {
                if (Rowset.contains((String[])requiredValue, value.toString())) continue;
                return;
            }
            throw Util.newInternal("Restriction value is of wrong type: " + requiredValue);
        }
        saxHandler.startElement("row");
        for (i = 0; i < this.rowsetDefinition.columnDefinitions.length; ++i) {
            column = this.rowsetDefinition.columnDefinitions[i];
            value = column.get(row);
            if (value == null) continue;
            saxHandler.startElement(column.name);
            saxHandler.characters(value.toString());
            saxHandler.endElement();
        }
        saxHandler.endElement();
    }

    protected void emit(EnumeratedValues enumeration, SAXHandler saxHandler) throws SAXException {
        List valuesSortedByName = enumeration.getValuesSortedByName();
        for (int i = 0; i < valuesSortedByName.size(); ++i) {
            EnumeratedValues.Value value = (EnumeratedValues.Value)valuesSortedByName.get(i);
            this.emit(value, saxHandler);
        }
    }

    protected boolean passesRestriction(RowsetDefinition.Column column, String value) {
        Object requiredValue = this.restrictions.get(column.name);
        if (requiredValue == null) {
            return true;
        }
        return requiredValue.equals(value);
    }

    protected boolean isRestricted(RowsetDefinition.Column column) {
        return this.restrictions.get(column.name) != null;
    }

    protected class XmlElement {
        private final String tag;
        private final String[] attributes;
        private final String text;
        private final XmlElement[] children;

        XmlElement(String tag, String[] attributes) {
            this(tag, attributes, null, null);
        }

        XmlElement(String tag, String[] attributes, String text) {
            this(tag, attributes, text, null);
        }

        XmlElement(String tag, String[] attributes, XmlElement[] children) {
            this(tag, attributes, null, children);
        }

        private XmlElement(String tag, String[] attributes, String text, XmlElement[] children) {
            this.tag = tag;
            this.attributes = attributes;
            this.text = text;
            this.children = children;
        }
    }

    protected class Row {
        private final ArrayList names = new ArrayList();
        private final ArrayList values = new ArrayList();

        protected Row() {
        }

        void set(String name, Object value) {
            if (value != null) {
                this.names.add(name);
                this.values.add(value);
            }
        }

        void set(String name, int value) {
            this.set(name, Integer.toString(value));
        }

        void set(String name, boolean value) {
            this.set(name, value ? "true" : "false");
        }

        public Object get(String name) {
            int i = this.names.indexOf(name);
            if (i < 0) {
                return null;
            }
            return this.values.get(i);
        }
    }
}

