/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import mondrian.rolap.RolapStar;
import mondrian.rolap.agg.ColumnConstraint;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.SqlQuery;
import org.apache.log4j.Logger;

class AggQuerySpec {
    private static final Logger LOGGER = Logger.getLogger((Class)AggQuerySpec.class);
    private final AggStar aggStar;
    private final Segment[] segments;
    private final boolean isDistinct;

    AggQuerySpec(AggStar aggStar, Segment[] segments, boolean isDistinct) {
        this.aggStar = aggStar;
        this.segments = segments;
        this.isDistinct = isDistinct;
    }

    protected SqlQuery newSqlQuery() {
        return this.getStar().getSqlQuery();
    }

    public RolapStar getStar() {
        return this.aggStar.getStar();
    }

    public int getMeasureCount() {
        return this.segments.length;
    }

    public AggStar.Table.Column getMeasureAsColumn(int i) {
        int bitPos = this.segments[i].measure.getBitPosition();
        return this.aggStar.lookupColumn(bitPos);
    }

    public String getMeasureAlias(int i) {
        return "m" + Integer.toString(i);
    }

    public int getColumnCount() {
        return this.segments[0].aggregation.getColumns().length;
    }

    public AggStar.Table.Column getColumn(int i) {
        RolapStar.Column[] columns = this.segments[0].aggregation.getColumns();
        int bitPos = columns[i].getBitPosition();
        AggStar.Table.Column column = this.aggStar.lookupColumn(bitPos);
        if (column == null) {
            LOGGER.error((Object)("column null for bitPos=" + bitPos));
        }
        return column;
    }

    public String getColumnAlias(int i) {
        return "c" + Integer.toString(i);
    }

    public ColumnConstraint[] getConstraints(int i) {
        return this.segments[0].axes[i].getConstraints();
    }

    public String generateSqlQuery() {
        SqlQuery sqlQuery = this.newSqlQuery();
        this.generateSql(sqlQuery);
        return sqlQuery.toString();
    }

    protected boolean hasDistinct() {
        return this.isDistinct;
    }

    protected void addMeasure(int i, SqlQuery sqlQuery) {
        AggStar.Table.Column column = this.getMeasureAsColumn(i);
        column.getTable().addToFrom(sqlQuery, false, true);
        String alias = this.getMeasureAlias(i);
        String expr = column.getExpression(sqlQuery);
        sqlQuery.addSelect(expr, alias);
    }

    protected void generateSql(SqlQuery sqlQuery) {
        int i;
        int columnCnt = this.getColumnCount();
        for (i = 0; i < columnCnt; ++i) {
            AggStar.Table.Column column = this.getColumn(i);
            AggStar.Table table = column.getTable();
            table.addToFrom(sqlQuery, false, true);
            String expr = column.getExpression(sqlQuery);
            ColumnConstraint[] constraints = this.getConstraints(i);
            if (constraints != null) {
                sqlQuery.addWhere(RolapStar.Column.createInExpr(expr, constraints, column.isNumeric()));
            }
            if (sqlQuery.getDialect().isAS400()) {
                sqlQuery.addSelect(expr, null);
            } else {
                sqlQuery.addSelect(expr, this.getColumnAlias(i));
            }
            if (this.hasDistinct()) continue;
            sqlQuery.addGroupBy(expr);
        }
        int count = this.getMeasureCount();
        for (i = 0; i < count; ++i) {
            this.addMeasure(i, sqlQuery);
        }
    }
}

