/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStar;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.ColumnConstraint;
import mondrian.rolap.sql.SqlQuery;

public class SqlConstraintUtils {
    static final /* synthetic */ boolean $assertionsDisabled;

    private SqlConstraintUtils() {
    }

    public static void addContextConstraint(SqlQuery sqlQuery, Evaluator e, boolean strict) {
        Member[] members = e.getMembers();
        if (strict) {
            if (!$assertionsDisabled && SqlConstraintUtils.containsCalculatedMember(members)) {
                throw new AssertionError((Object)"addContextConstraint: can not restrict SQL to calculated Members");
            }
        } else {
            members = SqlConstraintUtils.removeCalculatedMembers(members);
        }
        CellRequest request = RolapAggregationManager.makeRequest(members, false);
        RolapStar.Column[] columns = request.getColumns();
        Object[] values = request.getSingleValues();
        int arity = columns.length;
        for (int i = 0; i < arity; ++i) {
            RolapStar.Column column = columns[i];
            RolapStar.Table table = column.getTable();
            table.addToFrom(sqlQuery, false, true);
            String expr = column.getExpression(sqlQuery);
            String value = sqlQuery.quote(column.isNumeric(), values[i]);
            sqlQuery.addWhere(expr, " = ", value);
        }
    }

    private static Member[] removeCalculatedMembers(Member[] members) {
        ArrayList<Member> result = new ArrayList<Member>();
        for (int i = 0; i < members.length; ++i) {
            if (members[i].isCalculated()) continue;
            result.add(members[i]);
        }
        return result.toArray(new Member[result.size()]);
    }

    private static boolean containsCalculatedMember(Member[] members) {
        for (int i = 0; i < members.length; ++i) {
            if (!members[i].isCalculated()) continue;
            return true;
        }
        return false;
    }

    public static void joinLevelTableToFactTable(SqlQuery sqlQuery, RolapCube cube, RolapLevel level) {
        RolapStar star = cube.getStar();
        Map mapLevelToColumnMap = star.getMapLevelToColumn(cube);
        RolapStar.Column starColumn = (RolapStar.Column)mapLevelToColumnMap.get(level);
        RolapStar.Table table = starColumn.getTable();
        table.addToFrom(sqlQuery, false, true);
    }

    public static void addMemberConstraint(SqlQuery sqlQuery, RolapMember parent, boolean strict) {
        ArrayList<RolapMember> list = new ArrayList<RolapMember>(1);
        list.add(parent);
        SqlConstraintUtils.addMemberConstraint(sqlQuery, list, strict);
    }

    public static void addMemberConstraint(SqlQuery sqlQuery, List parents, boolean strict) {
        if (parents.size() == 0) {
            return;
        }
        Collection c = parents;
        while (!c.isEmpty()) {
            RolapMember m = (RolapMember)c.iterator().next();
            if (!m.isAll()) {
                if (m.isCalculated()) {
                    if (strict) {
                        throw Util.newInternal("addMemberConstraint: cant restrict SQL to calculated member");
                    }
                } else {
                    RolapLevel level = m.getRolapLevel();
                    RolapHierarchy hierarchy = (RolapHierarchy)level.getHierarchy();
                    hierarchy.addToFrom(sqlQuery, level.getKeyExp());
                    String q = level.getKeyExp().getExpression(sqlQuery);
                    ColumnConstraint[] cc = SqlConstraintUtils.getColumnConstraints(c);
                    String cond = RolapStar.Column.createInExpr(q, cc, level.isNumeric());
                    sqlQuery.addWhere(cond);
                    if (level.isUnique()) break;
                }
            }
            c = SqlConstraintUtils.getUniqueParentMembers(c);
        }
    }

    private static ColumnConstraint[] getColumnConstraints(Collection members) {
        ColumnConstraint[] constraints = new ColumnConstraint[members.size()];
        Iterator it = members.iterator();
        for (int i = 0; i < constraints.length; ++i) {
            RolapMember m = (RolapMember)it.next();
            constraints[i] = new ColumnConstraint(m);
        }
        return constraints;
    }

    private static Collection getUniqueParentMembers(Collection members) {
        HashSet<RolapMember> set = new HashSet<RolapMember>();
        Iterator it = members.iterator();
        while (it.hasNext()) {
            RolapMember m = (RolapMember)it.next();
            if ((m = (RolapMember)m.getParentMember()) == null) continue;
            set.add(m);
        }
        return set;
    }

    static {
        $assertionsDisabled = !SqlConstraintUtils.class.desiredAssertionStatus();
    }
}

