/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.olap.Cube;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.NamedSet;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.OlapElement;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlConstraintFactory;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;
import org.apache.log4j.Logger;

public abstract class RolapSchemaReader
implements SchemaReader {
    private final Role role;
    private final Map hierarchyReaders;
    private final RolapSchema schema;
    private final SqlConstraintFactory sqlConstraintFactory = SqlConstraintFactory.instance();
    private static final Logger LOGGER;
    static final /* synthetic */ boolean $assertionsDisabled;

    RolapSchemaReader(Role role, RolapSchema schema) {
        if (!$assertionsDisabled && role == null) {
            throw new AssertionError((Object)"precondition: role != null");
        }
        this.role = role;
        this.schema = schema;
        this.hierarchyReaders = new HashMap();
    }

    public Role getRole() {
        return this.role;
    }

    public Member[] getHierarchyRootMembers(Hierarchy hierarchy) {
        Level firstLevel;
        Role.HierarchyAccess hierarchyAccess = this.role.getAccessDetails(hierarchy);
        if (hierarchyAccess == null) {
            firstLevel = hierarchy.getLevels()[0];
        } else {
            firstLevel = hierarchyAccess.getTopLevel();
            if (firstLevel == null) {
                firstLevel = hierarchy.getLevels()[0];
            }
        }
        return this.getLevelMembers(firstLevel);
    }

    synchronized MemberReader getMemberReader(Hierarchy hierarchy) {
        MemberReader memberReader = (MemberReader)this.hierarchyReaders.get(hierarchy);
        if (memberReader == null) {
            memberReader = ((RolapHierarchy)hierarchy).getMemberReader(this.role);
            this.hierarchyReaders.put(hierarchy, memberReader);
        }
        return memberReader;
    }

    public void getMemberRange(Level level, Member startMember, Member endMember, List list) {
        this.getMemberReader(level.getHierarchy()).getMemberRange((RolapLevel)level, (RolapMember)startMember, (RolapMember)endMember, list);
    }

    public int compareMembersHierarchically(Member m1, Member m2) {
        RolapHierarchy hierarchy = (RolapHierarchy)m1.getHierarchy();
        Util.assertPrecondition(hierarchy == m2.getHierarchy());
        return this.getMemberReader(hierarchy).compare((RolapMember)m1, (RolapMember)m2, true);
    }

    public Member getMemberParent(Member member) {
        Role.HierarchyAccess hierarchyAccess;
        Member parentMember;
        for (parentMember = member.getParentMember(); parentMember != null && parentMember.isHidden(); parentMember = parentMember.getParentMember()) {
        }
        if (parentMember != null && (hierarchyAccess = this.role.getAccessDetails(member.getHierarchy())) != null && hierarchyAccess.getAccess(parentMember) == 1) {
            return null;
        }
        return parentMember;
    }

    public int getMemberDepth(Member member) {
        Role.HierarchyAccess hierarchyAccess = this.role.getAccessDetails(member.getHierarchy());
        if (hierarchyAccess != null) {
            int memberDepth = member.getLevel().getDepth();
            Level topLevel = hierarchyAccess.getTopLevel();
            if (topLevel != null) {
                memberDepth -= topLevel.getDepth();
            }
            return memberDepth;
        }
        if (((RolapLevel)member.getLevel()).getParentExp() != null) {
            int depth = 0;
            for (Member m = member.getParentMember(); m != null; m = m.getParentMember()) {
                ++depth;
            }
            return depth;
        }
        return member.getLevel().getDepth();
    }

    public Member[] getMemberChildren(Member member) {
        return this.getMemberChildren(member, null);
    }

    public Member[] getMemberChildren(Member member, Evaluator context) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(context);
        return this.internalGetMemberChildren(member, constraint);
    }

    private Member[] internalGetMemberChildren(Member member, MemberChildrenConstraint constraint) {
        ArrayList children = new ArrayList();
        Hierarchy hierarchy = member.getHierarchy();
        MemberReader memberReader = this.getMemberReader(hierarchy);
        memberReader.getMemberChildren((RolapMember)member, children, constraint);
        return RolapUtil.toArray(children);
    }

    public int getChildrenCountFromCache(Member member) {
        Hierarchy hierarchy = member.getHierarchy();
        MemberReader memberReader = this.getMemberReader(hierarchy);
        if (!(memberReader instanceof MemberCache)) {
            return -1;
        }
        List list = ((MemberCache)((Object)memberReader)).getChildrenFromCache((RolapMember)member, null);
        if (list == null) {
            return -1;
        }
        return list.size();
    }

    public int getLevelCardinalityFromCache(Level level) {
        Hierarchy hierarchy = level.getHierarchy();
        MemberReader memberReader = this.getMemberReader(hierarchy);
        if (!(memberReader instanceof MemberCache)) {
            return -1;
        }
        List list = ((MemberCache)((Object)memberReader)).getLevelMembersFromCache((RolapLevel)level, null);
        if (list == null) {
            return -1;
        }
        return list.size();
    }

    public Member[] getMemberChildren(Member[] members) {
        return this.getMemberChildren(members, null);
    }

    public Member[] getMemberChildren(Member[] members, Evaluator context) {
        if (members.length == 0) {
            return RolapUtil.emptyMemberArray;
        }
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(context);
        Hierarchy hierarchy = members[0].getHierarchy();
        MemberReader memberReader = this.getMemberReader(hierarchy);
        ArrayList children = new ArrayList();
        memberReader.getMemberChildren(Arrays.asList(members), children, constraint);
        return RolapUtil.toArray(children);
    }

    public abstract Cube getCube();

    public OlapElement getElementChild(OlapElement parent, String name) {
        return parent.lookupChild(this, name);
    }

    public Member getMemberByUniqueName(String[] uniqueNameParts, boolean failIfNotFound) {
        return null;
    }

    public OlapElement lookupCompound(OlapElement parent, String[] names, boolean failIfNotFound, int category) {
        return Util.lookupCompound(this, parent, names, failIfNotFound, category);
    }

    public Member lookupMemberChildByName(Member parent, String childName) {
        LOGGER.debug((Object)("looking for child \"" + childName + "\" of " + parent));
        try {
            MemberChildrenConstraint constraint = this.sqlConstraintFactory.getChildByNameConstraint((RolapMember)parent, childName);
            Member[] children = this.internalGetMemberChildren(parent, constraint);
            for (int i = 0; i < children.length; ++i) {
                Member child = children[i];
                if (!Util.equalName(child.getName(), childName)) continue;
                return child;
            }
        }
        catch (NumberFormatException e) {
            LOGGER.debug((Object)("NumberFormatException in lookupMemberChildByName for parent = \"" + parent + "\", childName=\"" + childName + "\", exception: " + e.getMessage()));
        }
        return null;
    }

    public Member getCalculatedMember(String[] nameParts) {
        return null;
    }

    public NamedSet getNamedSet(String[] nameParts) {
        if (nameParts.length != 1) {
            return null;
        }
        String name = nameParts[0];
        return this.schema.getNamedSet(name);
    }

    public Member getLeadMember(Member member, int n) {
        return this.getMemberReader(member.getHierarchy()).getLeadMember((RolapMember)member, n);
    }

    public Member[] getLevelMembers(Level level) {
        return this.getLevelMembers(level, null);
    }

    public Member[] getLevelMembers(Level level, Evaluator context) {
        TupleConstraint constraint = this.sqlConstraintFactory.getLevelMembersConstraint(context);
        MemberReader memberReader = this.getMemberReader(level.getHierarchy());
        List membersInLevel = memberReader.getMembersInLevel((RolapLevel)level, 0, Integer.MAX_VALUE, constraint);
        return RolapUtil.toArray(membersInLevel);
    }

    public Level[] getHierarchyLevels(Hierarchy hierarchy) {
        Util.assertPrecondition(hierarchy != null, "hierarchy != null");
        Role.HierarchyAccess hierarchyAccess = this.role.getAccessDetails(hierarchy);
        Level[] levels = hierarchy.getLevels();
        if (hierarchyAccess == null) {
            return levels;
        }
        Level topLevel = hierarchyAccess.getTopLevel();
        Level bottomLevel = hierarchyAccess.getBottomLevel();
        if (topLevel == null && bottomLevel == null) {
            return levels;
        }
        if (topLevel == null) {
            topLevel = levels[0];
        }
        if (bottomLevel == null) {
            bottomLevel = levels[levels.length - 1];
        }
        int levelCount = bottomLevel.getDepth() - topLevel.getDepth() + 1;
        Level[] restrictedLevels = new Level[levelCount];
        System.arraycopy(levels, topLevel.getDepth(), restrictedLevels, 0, levelCount);
        Util.assertPostcondition(restrictedLevels.length >= 1, "return.length >= 1");
        return restrictedLevels;
    }

    public Member getHierarchyDefaultMember(Hierarchy hierarchy) {
        Util.assertPrecondition(hierarchy != null, "hierarchy != null");
        if (this.role.getAccess(hierarchy) == 1) {
            return hierarchy.getDefaultMember();
        }
        Member[] rootMembers = this.getHierarchyRootMembers(hierarchy);
        return rootMembers.length > 0 ? rootMembers[0] : null;
    }

    public boolean isDrillable(Member member) {
        RolapLevel level = (RolapLevel)member.getLevel();
        if (level.getParentExp() != null) {
            return this.getMemberChildren(member).length > 0;
        }
        Level childLevel = level.getChildLevel();
        return childLevel != null && this.role.getAccess(childLevel) != 1;
    }

    public boolean isVisible(Member member) {
        return !member.isHidden() && this.role.canAccess(member);
    }

    public Cube[] getCubes() {
        Cube[] cubes = this.schema.getCubes();
        ArrayList<Cube> visibleCubes = new ArrayList<Cube>(cubes.length);
        for (int idx = 0; idx < cubes.length; ++idx) {
            if (!this.role.canAccess(cubes[idx])) continue;
            visibleCubes.add(cubes[idx]);
        }
        Cube[] result = new Cube[visibleCubes.size()];
        visibleCubes.toArray(result);
        return result;
    }

    public List getCalculatedMembers(Hierarchy hierarchy) {
        return Collections.EMPTY_LIST;
    }

    public List getCalculatedMembers(Level level) {
        return Collections.EMPTY_LIST;
    }

    public List getCalculatedMembers() {
        return Collections.EMPTY_LIST;
    }

    public NativeEvaluator getNativeSetEvaluator(FunDef fun, Evaluator evaluator, Exp[] args) {
        RolapEvaluator revaluator = (RolapEvaluator)evaluator;
        return this.schema.getNativeRegistry().createEvaluator(revaluator, fun, args);
    }

    DataSource getDataSource() {
        return this.schema.getInternalConnection().getDataSource();
    }

    RolapSchema getSchema() {
        return this.schema;
    }

    static {
        $assertionsDisabled = !RolapSchemaReader.class.desiredAssertionStatus();
        LOGGER = Logger.getLogger((Class)RolapSchemaReader.class);
    }
}

