/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.olap.Util;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;

class RolapConnectionPool {
    private static final RolapConnectionPool instance = new RolapConnectionPool();
    private final Map mapConnectKeyToPool = new HashMap();

    public static RolapConnectionPool instance() {
        return instance;
    }

    private RolapConnectionPool() {
    }

    public synchronized DataSource getPoolingDataSource(Object key, ConnectionFactory connectionFactory) {
        ObjectPool connectionPool = this.getPool(key, connectionFactory);
        return new PoolingDataSource(connectionPool);
    }

    void clearPool() {
        this.mapConnectKeyToPool.clear();
    }

    private synchronized ObjectPool getPool(Object key, ConnectionFactory connectionFactory) {
        ObjectPool connectionPool = (ObjectPool)this.mapConnectKeyToPool.get(key);
        if (connectionPool == null) {
            connectionPool = new GenericObjectPool(null, 50, 1, 3000L, 10, false, false, 60000L, 5, 30000L, true);
            AbandonedConfig abandonedConfig = new AbandonedConfig();
            abandonedConfig.setRemoveAbandoned(true);
            abandonedConfig.setRemoveAbandonedTimeout(300);
            abandonedConfig.setLogAbandoned(true);
            PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory(connectionFactory, connectionPool, null, null, false, true, abandonedConfig);
            Util.discard((Object)poolableConnectionFactory);
            this.mapConnectKeyToPool.put(key, connectionPool);
        }
        return connectionPool;
    }
}

