/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.type;

import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Util;
import mondrian.olap.type.Type;

public class LevelType
implements Type {
    private final Hierarchy hierarchy;
    private final Level level;

    public LevelType(Hierarchy hierarchy, Level level) {
        this.hierarchy = hierarchy;
        this.level = level;
        if (level != null) {
            Util.assertPrecondition(hierarchy != null, "hierarchy != null");
            Util.assertPrecondition(level.getHierarchy() == hierarchy, "level.getHierarchy() == hierarchy");
        }
    }

    public boolean usesDimension(Dimension dimension) {
        return this.hierarchy != null && this.hierarchy.getDimension() == dimension;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public Level getLevel() {
        return this.level;
    }
}

