/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import mondrian.olap.Axis;
import mondrian.olap.AxisOrdinal;
import mondrian.olap.Category;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.DelegatingSchemaReader;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.FunCall;
import mondrian.olap.FunTable;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Literal;
import mondrian.olap.Member;
import mondrian.olap.MemberProperty;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Parameter;
import mondrian.olap.Property;
import mondrian.olap.QueryAxis;
import mondrian.olap.QueryPart;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.Walkable;
import mondrian.olap.Walker;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ParameterFunDef;
import mondrian.olap.type.DecimalType;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;

public class Query
extends QueryPart {
    public Formula[] formulas;
    public QueryAxis[] axes;
    public Exp slicer;
    private Parameter[] parameters;
    private final QueryPart[] cellProps;
    private final Cube cube;
    private final Connection connection;

    public Query(Connection connection, Formula[] formulas, QueryAxis[] axes, String cube, Exp slicer, QueryPart[] cellProps) {
        this(connection, connection.getSchema().lookupCube(cube, true), formulas, axes, slicer, cellProps, new Parameter[0]);
    }

    public Query(Connection connection, Cube mdxCube, Formula[] formulas, QueryAxis[] axes, Exp slicer, QueryPart[] cellProps, Parameter[] parameters) {
        this.connection = connection;
        this.cube = mdxCube;
        this.formulas = formulas;
        this.axes = axes;
        this.normalizeAxes();
        this.setSlicer(slicer);
        this.cellProps = cellProps;
        this.parameters = parameters;
        this.resolve();
    }

    public void addFormula(String[] names, Exp exp) {
        Formula newFormula = new Formula(names, exp);
        int nFor = 0;
        if (this.formulas.length > 0) {
            nFor = this.formulas.length;
        }
        Formula[] newFormulas = new Formula[nFor + 1];
        for (int i = 0; i < nFor; ++i) {
            newFormulas[i] = this.formulas[i];
        }
        newFormulas[nFor] = newFormula;
        this.formulas = newFormulas;
        this.resolve();
    }

    public void addFormula(String[] names, Exp exp, MemberProperty[] memberProperties) {
        Formula newFormula = new Formula(names, exp, memberProperties);
        int nFor = 0;
        if (this.formulas.length > 0) {
            nFor = this.formulas.length;
        }
        Formula[] newFormulas = new Formula[nFor + 1];
        for (int i = 0; i < nFor; ++i) {
            newFormulas[i] = this.formulas[i];
        }
        newFormulas[nFor] = newFormula;
        this.formulas = newFormulas;
        this.resolve();
    }

    public Validator createValidator() {
        return new StackValidator(this.connection.getSchema().getFunTable());
    }

    public Object clone() throws CloneNotSupportedException {
        return new Query(this.connection, this.cube, Formula.cloneArray(this.formulas), QueryAxis.cloneArray(this.axes), this.slicer == null ? null : (Exp)this.slicer.clone(), this.cellProps, Parameter.cloneArray(this.parameters));
    }

    public Query safeClone() {
        try {
            return (Query)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Util.newInternal(e, "Query.clone() failed");
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getQueryString() {
        return this.toMdx();
    }

    private void normalizeAxes() {
        block0: for (int i = 0; i < this.axes.length; ++i) {
            AxisOrdinal correctOrdinal = AxisOrdinal.get(i);
            if (this.axes[i].getAxisOrdinal() == correctOrdinal) continue;
            for (int j = i + 1; j < this.axes.length; ++j) {
                if (this.axes[j].getAxisOrdinal() != correctOrdinal) continue;
                QueryAxis temp = this.axes[i];
                this.axes[i] = this.axes[j];
                this.axes[j] = temp;
                continue block0;
            }
        }
    }

    public void resolve() {
        this.resolve(this.createValidator());
    }

    void resolve(Validator validator) {
        int i;
        if (this.formulas != null) {
            for (i = 0; i < this.formulas.length; ++i) {
                this.formulas[i].createElement(validator.getQuery());
            }
            for (i = 0; i < this.formulas.length; ++i) {
                validator.validate(this.formulas[i]);
            }
        }
        if (this.axes != null) {
            for (i = 0; i < this.axes.length; ++i) {
                validator.validate(this.axes[i]);
            }
        }
        if (this.slicer != null) {
            this.setSlicer(validator.validate(this.slicer, false));
        }
        for (i = 0; i < this.parameters.length; ++i) {
            this.parameters[i] = validator.validate(this.parameters[i]);
        }
        this.resolveParameters();
        Dimension[] dimensions = this.getCube().getDimensions();
        for (int i2 = 0; i2 < dimensions.length; ++i2) {
            Dimension dimension = dimensions[i2];
            int useCount = 0;
            for (int j = -1; j < this.axes.length; ++j) {
                Exp axisExp;
                if (j < 0) {
                    if (this.slicer == null) continue;
                    axisExp = this.slicer;
                } else {
                    axisExp = this.axes[j].set;
                }
                if (!axisExp.getTypeX().usesDimension(dimension)) continue;
                ++useCount;
            }
            if (useCount <= true) continue;
            throw MondrianResource.instance().DimensionInIndependentAxes.ex(dimension.getUniqueName());
        }
    }

    public void unparse(PrintWriter pw) {
        int i;
        if (this.formulas != null) {
            for (i = 0; i < this.formulas.length; ++i) {
                if (i == 0) {
                    pw.print("with ");
                } else {
                    pw.print("  ");
                }
                this.formulas[i].unparse(pw);
                pw.println();
            }
        }
        pw.print("select ");
        if (this.axes != null) {
            for (i = 0; i < this.axes.length; ++i) {
                this.axes[i].unparse(pw);
                if (i < this.axes.length - 1) {
                    pw.println(",");
                    pw.print("  ");
                    continue;
                }
                pw.println();
            }
        }
        if (this.cube != null) {
            pw.println("from [" + this.cube.getName() + "]");
        }
        if (this.slicer != null) {
            pw.print("where ");
            this.slicer.unparse(pw);
            pw.println();
        }
    }

    public String toMdx() {
        StringWriter sw = new StringWriter();
        QueryPrintWriter pw = new QueryPrintWriter(sw);
        this.unparse(pw);
        return sw.toString();
    }

    public String toString() {
        this.resolve();
        return this.toMdx();
    }

    public Object[] getChildren() {
        int i;
        ArrayList<Object> list = new ArrayList<Object>();
        for (i = 0; i < this.axes.length; ++i) {
            list.add(this.axes[i]);
        }
        if (this.slicer != null) {
            list.add(this.slicer);
        }
        for (i = 0; i < this.formulas.length; ++i) {
            list.add(this.formulas[i]);
        }
        return list.toArray();
    }

    public void replaceChild(int i, QueryPart with) {
        int i0 = i;
        if (i < this.axes.length) {
            if (with == null) {
                QueryAxis[] oldAxes = this.axes;
                this.axes = new QueryAxis[oldAxes.length - 1];
                for (int j = 0; j < this.axes.length; ++j) {
                    this.axes[j] = oldAxes[j < i ? j : j + 1];
                }
            } else {
                this.axes[i] = (QueryAxis)with;
            }
            return;
        }
        if ((i -= this.axes.length) == 0) {
            this.setSlicer((Exp)((Object)with));
            return;
        }
        if (--i < this.formulas.length) {
            if (with == null) {
                Formula[] oldFormulas = this.formulas;
                this.formulas = new Formula[oldFormulas.length - 1];
                for (int j = 0; j < this.formulas.length; ++j) {
                    this.formulas[j] = oldFormulas[j < i ? j : j + 1];
                }
            } else {
                this.formulas[i] = (Formula)with;
            }
            return;
        }
        throw Util.newInternal("Query child ordinal " + i0 + " out of range (there are " + this.axes.length + " axes, " + this.formulas.length + " formula)");
    }

    public void setSlicer(Exp exp) {
        this.slicer = exp;
        if (this.slicer instanceof Level || this.slicer instanceof Hierarchy || this.slicer instanceof Dimension) {
            this.slicer = new FunCall("DefaultMember", Syntax.Property, new Exp[]{this.slicer});
        }
        if (!(this.slicer == null || this.slicer instanceof FunCall && ((FunCall)this.slicer).isCallToTuple())) {
            this.slicer = new FunCall("()", Syntax.Parentheses, new Exp[]{this.slicer});
        }
    }

    public Exp getSlicer() {
        return this.slicer;
    }

    public Iterator unusedDimensions() {
        Dimension[] mdxDimensions = this.cube.getDimensions();
        return Arrays.asList(mdxDimensions).iterator();
    }

    public void addLevelToAxis(int axis, Level level) {
        Util.assertPrecondition(AxisOrdinal.enumeration.isValid(axis), "AxisOrdinal.enumeration.isValid(axis)");
        Util.assertPrecondition(axis < this.axes.length, "axis < axes.length");
        this.axes[axis].addLevel(level);
    }

    private Hierarchy[] collectHierarchies(Exp queryPart) {
        Type type = queryPart.getTypeX();
        if (type instanceof SetType) {
            type = ((SetType)type).getElementType();
        }
        if (type instanceof TupleType) {
            Type[] types = ((TupleType)type).elementTypes;
            ArrayList<Hierarchy> hierarchyList = new ArrayList<Hierarchy>();
            for (int i = 0; i < types.length; ++i) {
                Hierarchy hierarchy = types[i].getHierarchy();
                hierarchyList.add(hierarchy);
            }
            return hierarchyList.toArray(new Hierarchy[hierarchyList.size()]);
        }
        return new Hierarchy[]{type.getHierarchy()};
    }

    public void setParameter(String parameterName, String value) {
        Parameter param = this.lookupParam(parameterName);
        if (param == null) {
            throw MondrianResource.instance().MdxParamNotFound.ex(parameterName);
        }
        Exp exp = param.quickParse(value, this);
        param.setValue(exp);
    }

    public void swapAxes() {
        if (this.axes.length == 2) {
            Exp e0 = this.axes[0].set;
            boolean nonEmpty0 = this.axes[0].nonEmpty;
            Exp e1 = this.axes[1].set;
            boolean nonEmpty1 = this.axes[1].nonEmpty;
            this.axes[1].set = e0;
            this.axes[1].nonEmpty = nonEmpty0;
            this.axes[0].set = e1;
            this.axes[0].nonEmpty = nonEmpty1;
        }
    }

    public Parameter lookupParam(String parameterName) {
        for (int i = 0; i < this.parameters.length; ++i) {
            if (!this.parameters[i].getName().equals(parameterName)) continue;
            return this.parameters[i];
        }
        return null;
    }

    private int[] resolveParameters() {
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i].validate(this);
        }
        int[] usageCount = new int[this.parameters.length];
        Walker queryElements = new Walker(this);
        while (queryElements.hasMoreElements()) {
            Object queryElement = queryElements.nextElement();
            if (!(queryElement instanceof Parameter)) continue;
            boolean found = false;
            for (int i = 0; i < this.parameters.length; ++i) {
                if (!this.parameters[i].equals(queryElement)) continue;
                int n = i;
                usageCount[n] = usageCount[n] + 1;
                found = true;
                break;
            }
            if (found) continue;
            throw MondrianResource.instance().MdxParamNotFound.ex(((Parameter)queryElement).getName());
        }
        return usageCount;
    }

    public Parameter[] getParameters() {
        int[] usageCount = this.resolveParameters();
        int nUsed = 0;
        for (int i = 0; i < usageCount.length; ++i) {
            if (usageCount[i] <= 0) continue;
            ++nUsed;
        }
        Parameter[] usedParameters = new Parameter[nUsed];
        nUsed = 0;
        for (int i = 0; i < this.parameters.length; ++i) {
            if (usageCount[i] <= 0) continue;
            usedParameters[nUsed++] = this.parameters[i];
        }
        return usedParameters;
    }

    public Cube getCube() {
        return this.cube;
    }

    public SchemaReader getSchemaReader(boolean accessControlled) {
        Role role = accessControlled ? this.getConnection().getRole() : null;
        SchemaReader cubeSchemaReader = this.cube.getSchemaReader(role);
        return new QuerySchemaReader(cubeSchemaReader);
    }

    public Member lookupMemberFromCache(String s) {
        Iterator definedMembers = this.getDefinedMembers().iterator();
        while (definedMembers.hasNext()) {
            Member mdxMember = (Member)definedMembers.next();
            if (!Util.equalName(mdxMember.getUniqueName(), s)) continue;
            return mdxMember;
        }
        return null;
    }

    private NamedSet lookupNamedSet(String name) {
        for (int i = 0; i < this.formulas.length; ++i) {
            Formula formula = this.formulas[i];
            if (formula.isMember() || formula.getElement() == null || !formula.getName().equals(name)) continue;
            return (NamedSet)formula.getElement();
        }
        return null;
    }

    public Formula[] getFormulas() {
        return this.formulas;
    }

    public QueryAxis[] getAxes() {
        return this.axes;
    }

    public void removeFormula(String uniqueName, boolean failIfUsedInQuery) {
        Formula formula = this.findFormula(uniqueName);
        if (failIfUsedInQuery && formula != null) {
            OlapElement mdxElement = formula.getElement();
            Walker walker = new Walker(this);
            while (walker.hasMoreElements()) {
                Object queryElement = walker.nextElement();
                if (!queryElement.equals(mdxElement)) continue;
                String formulaType = formula.isMember() ? MondrianResource.instance().CalculatedMember.str() : MondrianResource.instance().CalculatedSet.str();
                int i = 0;
                Object parent = walker.getAncestor(i);
                Object grandParent = walker.getAncestor(i + 1);
                while (parent != null && grandParent != null) {
                    if (grandParent instanceof Query) {
                        if (parent instanceof Axis) {
                            throw MondrianResource.instance().MdxCalculatedFormulaUsedOnAxis.ex(formulaType, uniqueName, ((QueryAxis)parent).getAxisName());
                        }
                        if (parent instanceof Formula) {
                            String parentFormulaType = ((Formula)parent).isMember() ? MondrianResource.instance().CalculatedMember.str() : MondrianResource.instance().CalculatedSet.str();
                            throw MondrianResource.instance().MdxCalculatedFormulaUsedInFormula.ex(formulaType, uniqueName, parentFormulaType, ((Formula)parent).getUniqueName());
                        }
                        throw MondrianResource.instance().MdxCalculatedFormulaUsedOnSlicer.ex(formulaType, uniqueName);
                    }
                    parent = walker.getAncestor(++i);
                    grandParent = walker.getAncestor(i + 1);
                }
                throw MondrianResource.instance().MdxCalculatedFormulaUsedInQuery.ex(formulaType, uniqueName, this.toMdx());
            }
        }
        ArrayList<Formula> formulaList = new ArrayList<Formula>();
        for (int i = 0; i < this.formulas.length; ++i) {
            if (this.formulas[i].getUniqueName().equalsIgnoreCase(uniqueName)) continue;
            formulaList.add(this.formulas[i]);
        }
        this.formulas = formulaList.toArray(new Formula[0]);
    }

    public boolean canRemoveFormula(String uniqueName) {
        Formula formula = this.findFormula(uniqueName);
        if (formula == null) {
            return false;
        }
        OlapElement mdxElement = formula.getElement();
        Walker walker = new Walker(this);
        while (walker.hasMoreElements()) {
            Object queryElement = walker.nextElement();
            if (!queryElement.equals(mdxElement)) continue;
            return false;
        }
        return true;
    }

    public Formula findFormula(String uniqueName) {
        for (int i = 0; i < this.formulas.length; ++i) {
            if (!this.formulas[i].getUniqueName().equalsIgnoreCase(uniqueName)) continue;
            return this.formulas[i];
        }
        return null;
    }

    public void renameFormula(String uniqueName, String newName) {
        Formula formula = this.findFormula(uniqueName);
        if (formula == null) {
            throw MondrianResource.instance().MdxFormulaNotFound.ex("formula", uniqueName, this.toMdx());
        }
        formula.rename(newName);
    }

    List getDefinedMembers() {
        ArrayList<OlapElement> definedMembers = new ArrayList<OlapElement>();
        for (int i = 0; i < this.formulas.length; ++i) {
            if (!this.formulas[i].isMember() || this.formulas[i].getElement() == null || !this.getConnection().getRole().canAccess(this.formulas[i].getElement())) continue;
            definedMembers.add(this.formulas[i].getElement());
        }
        return definedMembers;
    }

    public void setAxisShowEmptyCells(int axis, boolean showEmpty) {
        if (axis >= this.axes.length) {
            throw MondrianResource.instance().MdxAxisShowSubtotalsNotSupported.ex(new Integer(axis));
        }
        this.axes[axis].nonEmpty = !showEmpty;
    }

    public Hierarchy[] getMdxHierarchiesOnAxis(int axis) {
        if (axis >= this.axes.length) {
            throw MondrianResource.instance().MdxAxisShowSubtotalsNotSupported.ex(new Integer(axis));
        }
        return this.collectHierarchies(axis == -1 ? this.slicer : this.axes[axis].set);
    }

    static /* synthetic */ Parameter[] access$002(Query x0, Parameter[] x1) {
        x0.parameters = x1;
        return x1;
    }

    static class QueryPrintWriter
    extends PrintWriter {
        final HashSet parameters = new HashSet();

        QueryPrintWriter(Writer writer) {
            super(writer);
        }
    }

    private class QuerySchemaReader
    extends DelegatingSchemaReader {
        public QuerySchemaReader(SchemaReader cubeSchemaReader) {
            super(cubeSchemaReader);
        }

        public Member getMemberByUniqueName(String[] uniqueNameParts, boolean failIfNotFound) {
            String uniqueName = Util.implode(uniqueNameParts);
            Member member = Query.this.lookupMemberFromCache(uniqueName);
            if (member == null) {
                member = this.schemaReader.getMemberByUniqueName(uniqueNameParts, failIfNotFound);
            }
            if (this.getRole().canAccess(member)) {
                return member;
            }
            return null;
        }

        public Member getCalculatedMember(String[] nameParts) {
            String uniqueName = Util.implode(nameParts);
            return Query.this.lookupMemberFromCache(uniqueName);
        }

        public List getCalculatedMembers(Hierarchy hierarchy) {
            List definedMembers = Query.this.getDefinedMembers();
            ArrayList<Member> result = new ArrayList<Member>();
            for (int i = 0; i < definedMembers.size(); ++i) {
                Member member = (Member)definedMembers.get(i);
                if (!member.getHierarchy().equals(hierarchy)) continue;
                result.add(member);
            }
            return result;
        }

        public List getCalculatedMembers(Level level) {
            List hierachyMembers = this.getCalculatedMembers(level.getHierarchy());
            ArrayList<Member> result = new ArrayList<Member>();
            for (int i = 0; i < hierachyMembers.size(); ++i) {
                Member member = (Member)hierachyMembers.get(i);
                if (!member.getLevel().equals(level)) continue;
                result.add(member);
            }
            return result;
        }

        public List getCalculatedMembers() {
            return Query.this.getDefinedMembers();
        }

        public OlapElement getElementChild(OlapElement parent, String s) {
            OlapElement mdxElement = this.schemaReader.getElementChild(parent, s);
            if (mdxElement != null) {
                return mdxElement;
            }
            for (int i = 0; i < Query.this.formulas.length; ++i) {
                Formula formula = Query.this.formulas[i];
                if (formula.isMember() || !Util.equalName(formula.getNames()[0], s)) continue;
                return formula.getNamedSet();
            }
            return mdxElement;
        }

        public OlapElement lookupCompound(OlapElement parent, String[] names, boolean failIfNotFound, int category) {
            Member member;
            Formula formula;
            switch (category) {
                case 0: 
                case 6: {
                    Member calculatedMember;
                    if (parent != Query.this.cube || (calculatedMember = this.getCalculatedMember(names)) == null) break;
                    return calculatedMember;
                }
            }
            switch (category) {
                case 0: 
                case 8: {
                    NamedSet namedSet;
                    if (parent != Query.this.cube || (namedSet = this.getNamedSet(names)) == null) break;
                    return namedSet;
                }
            }
            OlapElement olapElement = super.lookupCompound(parent, names, failIfNotFound, category);
            if (olapElement instanceof Member && (formula = (Formula)(member = (Member)olapElement).getPropertyValue(Property.FORMULA.name)) != null) {
                Formula formulaClone = (Formula)formula.clone();
                formulaClone.createElement(Query.this);
                formulaClone.accept(Query.this.createValidator());
                olapElement = formulaClone.getMdxMember();
            }
            return olapElement;
        }

        public NamedSet getNamedSet(String[] nameParts) {
            if (nameParts.length != 1) {
                return null;
            }
            return Query.this.lookupNamedSet(nameParts[0]);
        }
    }

    private class StackValidator
    implements Validator {
        private final Stack stack = new Stack();
        private final FunTable funTable;
        private boolean haveCollectedParameters;
        private final Map resolvedNodes = new HashMap();
        private final Object placeHolder = "dummy";

        public StackValidator(FunTable funTable) {
            Util.assertPrecondition(funTable != null, "funTable != null");
            this.funTable = funTable;
        }

        public Query getQuery() {
            return Query.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Exp validate(Exp exp, boolean scalar) {
            Exp resolved = (Exp)this.resolvedNodes.get(exp);
            if (resolved != null) {
                return scalar ? this.convertToScalar(resolved) : resolved;
            }
            this.stack.push(exp);
            try {
                this.resolvedNodes.put(exp, this.placeHolder);
                resolved = exp.accept(this);
                this.resolvedNodes.put(exp, resolved);
                if (scalar) {
                    resolved = this.convertToScalar(resolved);
                }
                Exp exp2 = resolved;
                return exp2;
            }
            finally {
                this.stack.pop();
            }
        }

        private Exp convertToScalar(Exp exp) {
            return this.funTable.createValueFunCall(exp, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Parameter validate(Parameter parameter) {
            Parameter resolved = (Parameter)this.resolvedNodes.get(parameter);
            if (resolved != null) {
                return parameter;
            }
            this.stack.push(parameter);
            try {
                this.resolvedNodes.put(parameter, this.placeHolder);
                resolved = (Parameter)parameter.accept(this);
                this.resolvedNodes.put(parameter, resolved);
                Parameter parameter2 = resolved;
                return parameter2;
            }
            finally {
                this.stack.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validate(MemberProperty memberProperty) {
            if (this.resolvedNodes.put(memberProperty, this.placeHolder) != null) {
                return;
            }
            this.stack.push(memberProperty);
            try {
                memberProperty.resolve(this);
            }
            finally {
                this.stack.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validate(QueryAxis axis) {
            if (this.resolvedNodes.put(axis, this.placeHolder) != null) {
                return;
            }
            this.stack.push(axis);
            try {
                axis.resolve(this);
            }
            finally {
                this.stack.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void validate(Formula formula) {
            if (this.resolvedNodes.put(formula, this.placeHolder) != null) {
                return;
            }
            this.stack.push(formula);
            try {
                formula.accept(this);
            }
            finally {
                this.stack.pop();
            }
        }

        public boolean canConvert(Exp fromExp, int to, int[] conversionCount) {
            return FunUtil.canConvert(fromExp, to, conversionCount);
        }

        public Exp convert(Exp fromExp, int to) {
            return FunUtil.convert(fromExp, to, this);
        }

        public boolean requiresExpression() {
            return this.requiresExpression(this.stack.size() - 1);
        }

        private boolean requiresExpression(int n) {
            if (n < 1) {
                return false;
            }
            Object parent = this.stack.get(n - 1);
            if (parent instanceof Formula) {
                return ((Formula)parent).isMember();
            }
            if (parent instanceof FunCall) {
                FunCall funCall = (FunCall)parent;
                if (funCall.isCallToTuple()) {
                    return this.requiresExpression(n - 1);
                }
                int k = this.whichArg(funCall, this.stack.get(n));
                if (k < 0) {
                    return false;
                }
                return this.funTable.requiresExpression(funCall, k, this);
            }
            return false;
        }

        public FunTable getFunTable() {
            return this.funTable;
        }

        /*
         * WARNING - void declaration
         */
        public Parameter createOrLookupParam(FunCall funCall) {
            Util.assertTrue(funCall.getArg(0) instanceof Literal, "The name of parameter must be a quoted string");
            String name = (String)((Literal)funCall.getArg(0)).getValue();
            Parameter param = Query.this.lookupParam(name);
            ParameterFunDef funDef = (ParameterFunDef)funCall.getFunDef();
            if (funDef.getName().equals("Parameter")) {
                void var6_8;
                if (param != null) {
                    if (param.getDefineCount() > 0) {
                        throw Util.newInternal("Parameter '" + name + "' is defined more than once");
                    }
                    param.incrementDefineCount();
                    return param;
                }
                Exp arg1 = funCall.getArg(1);
                int category = funCall.getCategory();
                switch (category) {
                    case 6: {
                        Dimension dimension = (Dimension)arg1;
                        Type type = new MemberType(dimension.getHierarchy(), null, null);
                        break;
                    }
                    case 9: {
                        Type type = new StringType();
                        break;
                    }
                    case 7: {
                        Type type = new NumericType();
                        break;
                    }
                    case 15: {
                        Type type = new DecimalType(Integer.MAX_VALUE, 0);
                        break;
                    }
                    default: {
                        throw Category.instance.badValue(category);
                    }
                }
                param = new Parameter(funDef.parameterName, category, funDef.exp, funDef.parameterDescription, (Type)var6_8);
                Parameter[] old = Query.this.parameters;
                int count = old.length;
                Query.access$002(Query.this, new Parameter[count + 1]);
                System.arraycopy(old, 0, Query.this.parameters, 0, count);
                ((Query)Query.this).parameters[count] = param;
                return param;
            }
            if (param != null) {
                return param;
            }
            if (!this.haveCollectedParameters) {
                this.haveCollectedParameters = true;
                this.collectParameters();
                param = Query.this.lookupParam(name);
                if (param != null) {
                    return param;
                }
            }
            throw Util.newInternal("Parameter '" + name + "' is referenced but never defined");
        }

        private void collectParameters() {
            Walker walker = new Walker(Query.this);
            while (walker.hasMoreElements()) {
                FunCall call;
                Object o = walker.nextElement();
                if (o instanceof Parameter || !(o instanceof FunCall) || !(call = (FunCall)o).getFunName().equalsIgnoreCase("Parameter")) continue;
                Parameter param = (Parameter)this.validate(call, false);
                param.resetDefineCount();
            }
        }

        private int whichArg(Object node, Object arg) {
            if (node instanceof Walkable) {
                Object[] children = ((Walkable)node).getChildren();
                for (int i = 0; i < children.length; ++i) {
                    if (children[i] != arg) continue;
                    return i;
                }
            }
            return -1;
        }
    }
}

