/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import mondrian.olap.Category;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.SymbolType;
import mondrian.olap.type.Type;

public class Literal
extends ExpBase {
    public static final Literal emptyString = new Literal("", false);
    public static final Literal zero = new Literal(new Integer(0));
    public static final Literal one = new Literal(new Integer(1));
    public static final Literal negativeOne = new Literal(new Integer(-1));
    public static final Literal doubleZero = new Literal(new Double(0.0));
    public static final Literal doubleOne = new Literal(new Double(1.0));
    public static final Literal doubleNegativeOne = new Literal(new Double(-1.0));
    public final int type;
    private final Object o;

    public static Literal createString(String s) {
        return s.equals("") ? emptyString : new Literal(s, false);
    }

    public static Literal createSymbol(String s) {
        return new Literal(s, true);
    }

    public static Literal create(Double d) {
        double dv = d;
        if (dv == 0.0) {
            return doubleZero;
        }
        if (dv == 1.0) {
            return doubleOne;
        }
        if (dv == -1.0) {
            return doubleNegativeOne;
        }
        return new Literal(d);
    }

    public static Literal create(Integer i) {
        switch (i) {
            case -1: {
                return negativeOne;
            }
            case 0: {
                return zero;
            }
            case 1: {
                return one;
            }
        }
        return new Literal(i);
    }

    private Literal(String s, boolean isSymbol) {
        this.o = s;
        this.type = isSymbol ? 11 : 9;
    }

    private Literal(Double d) {
        this.o = d;
        this.type = 7;
    }

    private Literal(Integer i) {
        this.o = i;
        this.type = 7;
    }

    public Object clone() {
        return this;
    }

    public void unparse(PrintWriter pw) {
        switch (this.type) {
            case 7: 
            case 11: {
                pw.print(this.o);
                break;
            }
            case 9: {
                pw.print(Util.quoteForMdx((String)this.o));
                break;
            }
            default: {
                throw Util.newInternal("bad literal type " + this.type);
            }
        }
    }

    public int getCategory() {
        return this.type;
    }

    public Type getTypeX() {
        switch (this.type) {
            case 11: {
                return new SymbolType();
            }
            case 7: {
                return new NumericType();
            }
            case 9: {
                return new StringType();
            }
        }
        throw Category.instance.badValue(this.type);
    }

    public Exp accept(Validator validator) {
        return this;
    }

    public Object evaluate(Evaluator evaluator) {
        return evaluator.visit(this);
    }

    public Object evaluateScalar(Evaluator evaluator) {
        return this.o;
    }

    public Object getValue() {
        return this.o;
    }

    public int getIntValue() {
        if (this.o instanceof Number) {
            return ((Number)this.o).intValue();
        }
        throw Util.newInternal("cannot convert " + this.o + " to int");
    }

    public boolean dependsOn(Dimension dimension) {
        return false;
    }
}

