/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import mondrian.olap.Connection;
import mondrian.olap.Exp;
import mondrian.olap.FunTable;
import mondrian.olap.Parser;
import mondrian.olap.Query;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import org.apache.log4j.Logger;

public abstract class ConnectionBase
implements Connection {
    protected ConnectionBase() {
    }

    protected abstract Logger getLogger();

    public String getFullConnectString() {
        String s = this.getConnectString();
        String catalogName = this.getCatalogName();
        if (catalogName != null) {
            int len = s.length() + catalogName.length() + 32;
            StringBuffer buf = new StringBuffer(len);
            buf.append(s);
            if (!s.endsWith(";")) {
                buf.append(';');
            }
            buf.append("Initial Catalog=");
            buf.append(catalogName);
            buf.append(';');
            s = buf.toString();
        }
        return s;
    }

    public Query parseQuery(String s) {
        boolean debug = false;
        if (this.getLogger().isDebugEnabled()) {
            StringBuffer buf = new StringBuffer(256);
            buf.append(Util.nl);
            buf.append(s);
            this.getLogger().debug((Object)buf.toString());
        }
        try {
            Parser parser = new Parser();
            FunTable funTable = this.getSchema().getFunTable();
            Query q = parser.parseInternal(this, s, debug, funTable);
            return q;
        }
        catch (Throwable e) {
            throw MondrianResource.instance().FailedToParseQuery.ex(s, e);
        }
    }

    public Exp parseExpression(String s) {
        boolean debug = false;
        if (this.getLogger().isDebugEnabled()) {
            StringBuffer buf = new StringBuffer(256);
            buf.append(Util.nl);
            buf.append(s);
            this.getLogger().debug((Object)buf.toString());
        }
        try {
            Parser parser = new Parser();
            FunTable funTable = this.getSchema().getFunTable();
            Exp q = parser.parseExpression(this, s, debug, funTable);
            return q;
        }
        catch (Throwable e) {
            throw MondrianResource.instance().FailedToParseQuery.ex(s, e);
        }
    }
}

