/*
 * Decompiled with CFR 0.152.
 */
package mondrian.jolap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jmi.reflect.RefPackage;
import javax.olap.OLAPException;
import javax.olap.metadata.Dimension;
import javax.olap.metadata.MemberObjectFactories;
import javax.olap.query.querycoremodel.Constant;
import javax.olap.query.querycoremodel.CubeView;
import javax.olap.query.querycoremodel.DimensionView;
import javax.olap.query.querycoremodel.EdgeView;
import javax.olap.query.querytransaction.QueryTransactionManager;
import javax.olap.resource.ConnectionMetaData;
import mondrian.jolap.MondrianCubeView;
import mondrian.jolap.MondrianDimensionView;
import mondrian.jolap.MondrianJolapCube;
import mondrian.jolap.MondrianJolapDimension;
import mondrian.jolap.MondrianMemberObjectFactories;
import mondrian.jolap.RefObjectSupport;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.Hierarchy;
import mondrian.olap.Schema;

class MondrianJolapConnection
extends RefObjectSupport
implements javax.olap.resource.Connection {
    Connection mondrianConnection;
    private final MondrianMemberObjectFactories memberObjectFactories = new MondrianMemberObjectFactories();

    MondrianJolapConnection(Connection connection) {
        this.mondrianConnection = connection;
    }

    public void close() throws OLAPException {
        this.mondrianConnection.close();
    }

    public ConnectionMetaData getMetaData() throws OLAPException {
        throw new UnsupportedOperationException();
    }

    public RefPackage getTopLevelPackage() throws OLAPException {
        throw new UnsupportedOperationException();
    }

    public List getSchema() throws OLAPException {
        throw new UnsupportedOperationException();
    }

    public javax.olap.metadata.Schema getCurrentSchema() throws OLAPException {
        return null;
    }

    public void setCurrentSchema(javax.olap.metadata.Schema schema) throws OLAPException {
        throw new UnsupportedOperationException();
    }

    public Collection getDimensions() throws OLAPException {
        Schema schema = this.mondrianConnection.getSchema();
        Hierarchy[] sharedHierarchies = schema.getSharedHierarchies();
        ArrayList<MondrianJolapDimension> list = new ArrayList<MondrianJolapDimension>();
        for (int i = 0; i < sharedHierarchies.length; ++i) {
            list.add(new MondrianJolapDimension(this.getCurrentSchema(), sharedHierarchies[i].getDimension()));
        }
        return list;
    }

    public Collection getCubes() throws OLAPException {
        Schema schema = this.mondrianConnection.getSchema();
        Cube[] cubes = schema.getCubes();
        ArrayList<MondrianJolapCube> list = new ArrayList<MondrianJolapCube>();
        for (int i = 0; i < cubes.length; ++i) {
            Cube cube = cubes[i];
            list.add(new MondrianJolapCube(this.getCurrentSchema(), cube));
        }
        return list;
    }

    public CubeView createCubeView() throws OLAPException {
        return new MondrianCubeView(this, null);
    }

    public DimensionView createDimensionView(Dimension dimension) throws OLAPException {
        return new MondrianDimensionView(dimension);
    }

    public EdgeView createEdgeView() throws OLAPException {
        throw new UnsupportedOperationException();
    }

    public Collection getSchemas() throws OLAPException {
        throw new UnsupportedOperationException();
    }

    public Constant createConstant() throws OLAPException {
        throw new UnsupportedOperationException();
    }

    public MemberObjectFactories getMemberObjectFactories() throws OLAPException {
        return this.memberObjectFactories;
    }

    public QueryTransactionManager getQueryTransactionManager() throws OLAPException {
        throw new UnsupportedOperationException();
    }

    public void abort() throws OLAPException {
    }
}

