/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;

class SelectionRecord
extends WritableRecordData {
    private PaneType pane;
    private int column;
    private int row;
    public static final PaneType lowerRight = new PaneType(0);
    public static final PaneType upperRight = new PaneType(1);
    public static final PaneType lowerLeft = new PaneType(2);
    public static final PaneType upperLeft = new PaneType(3);

    public SelectionRecord(PaneType pt, int col, int r) {
        super(Type.SELECTION);
        this.column = col;
        this.row = r;
        this.pane = pt;
    }

    public byte[] getData() {
        byte[] data = new byte[15];
        data[0] = (byte)this.pane.val;
        IntegerHelper.getTwoBytes(this.row, data, 1);
        IntegerHelper.getTwoBytes(this.column, data, 3);
        data[7] = 1;
        IntegerHelper.getTwoBytes(this.row, data, 9);
        IntegerHelper.getTwoBytes(this.row, data, 11);
        data[13] = (byte)this.column;
        data[14] = (byte)this.column;
        return data;
    }

    private static class PaneType {
        int val;

        PaneType(int v) {
            this.val = v;
        }
    }
}

