/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class BarcodeCodabar
extends Barcode {
    static byte[][] BARS;
    static String CHARS;
    static final int START_STOP_IDX = 16;

    static {
        byte[][] byArrayArray = new byte[20][];
        byte[] byArray = new byte[7];
        byArray[5] = 1;
        byArray[6] = 1;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[7];
        byArray2[4] = 1;
        byArray2[5] = 1;
        byArrayArray[1] = byArray2;
        byte[] byArray3 = new byte[7];
        byArray3[3] = 1;
        byArray3[6] = 1;
        byArrayArray[2] = byArray3;
        byte[] byArray4 = new byte[7];
        byArray4[0] = 1;
        byArray4[1] = 1;
        byArrayArray[3] = byArray4;
        byte[] byArray5 = new byte[7];
        byArray5[2] = 1;
        byArray5[5] = 1;
        byArrayArray[4] = byArray5;
        byte[] byArray6 = new byte[7];
        byArray6[0] = 1;
        byArray6[5] = 1;
        byArrayArray[5] = byArray6;
        byte[] byArray7 = new byte[7];
        byArray7[1] = 1;
        byArray7[6] = 1;
        byArrayArray[6] = byArray7;
        byte[] byArray8 = new byte[7];
        byArray8[1] = 1;
        byArray8[4] = 1;
        byArrayArray[7] = byArray8;
        byte[] byArray9 = new byte[7];
        byArray9[1] = 1;
        byArray9[2] = 1;
        byArrayArray[8] = byArray9;
        byte[] byArray10 = new byte[7];
        byArray10[0] = 1;
        byArray10[3] = 1;
        byArrayArray[9] = byArray10;
        byte[] byArray11 = new byte[7];
        byArray11[3] = 1;
        byArray11[4] = 1;
        byArrayArray[10] = byArray11;
        byte[] byArray12 = new byte[7];
        byArray12[2] = 1;
        byArray12[3] = 1;
        byArrayArray[11] = byArray12;
        byte[] byArray13 = new byte[7];
        byArray13[0] = 1;
        byArray13[4] = 1;
        byArray13[6] = 1;
        byArrayArray[12] = byArray13;
        byte[] byArray14 = new byte[7];
        byArray14[0] = 1;
        byArray14[2] = 1;
        byArray14[6] = 1;
        byArrayArray[13] = byArray14;
        byte[] byArray15 = new byte[7];
        byArray15[0] = 1;
        byArray15[2] = 1;
        byArray15[4] = 1;
        byArrayArray[14] = byArray15;
        byte[] byArray16 = new byte[7];
        byArray16[2] = 1;
        byArray16[4] = 1;
        byArray16[6] = 1;
        byArrayArray[15] = byArray16;
        byte[] byArray17 = new byte[7];
        byArray17[2] = 1;
        byArray17[3] = 1;
        byArray17[5] = 1;
        byArrayArray[16] = byArray17;
        byte[] byArray18 = new byte[7];
        byArray18[3] = 1;
        byArray18[5] = 1;
        byArray18[6] = 1;
        byArrayArray[17] = byArray18;
        byte[] byArray19 = new byte[7];
        byArray19[1] = 1;
        byArray19[3] = 1;
        byArray19[6] = 1;
        byArrayArray[18] = byArray19;
        byte[] byArray20 = new byte[7];
        byArray20[3] = 1;
        byArray20[4] = 1;
        byArray20[5] = 1;
        byArrayArray[19] = byArray20;
        BARS = byArrayArray;
        CHARS = "0123456789-$:/.+ABCD";
    }

    public BarcodeCodabar() {
        try {
            this.x = 0.8f;
            this.n = 2.0f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.generateChecksum = false;
            this.checksumText = false;
            this.startStopText = false;
            this.codeType = 12;
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public static byte[] getBarsCodabar(String text) {
        int len = (text = text.toUpperCase()).length();
        if (len < 2) {
            throw new IllegalArgumentException("Codabar must have at least a start and stop character.");
        }
        if (CHARS.indexOf(text.charAt(0)) < 16 || CHARS.indexOf(text.charAt(len - 1)) < 16) {
            throw new IllegalArgumentException("Codabar must have one of 'ABCD' as start/stop character.");
        }
        byte[] bars = new byte[text.length() * 8 - 1];
        int k = 0;
        while (k < len) {
            int idx = CHARS.indexOf(text.charAt(k));
            if (idx >= 16 && k > 0 && k < len - 1) {
                throw new IllegalArgumentException("In codabar, start/stop characters are only allowed at the extremes.");
            }
            if (idx < 0) {
                throw new IllegalArgumentException("The character '" + text.charAt(k) + "' is illegal in codabar.");
            }
            System.arraycopy(BARS[idx], 0, bars, k * 8, 7);
            ++k;
        }
        return bars;
    }

    public static String calculateChecksum(String code) {
        if (code.length() < 2) {
            return code;
        }
        String text = code.toUpperCase();
        int sum = 0;
        int len = text.length();
        int k = 0;
        while (k < len) {
            sum += CHARS.indexOf(text.charAt(k));
            ++k;
        }
        sum = (sum + 15) / 16 * 16 - sum;
        return String.valueOf(code.substring(0, len - 1)) + CHARS.charAt(sum) + code.substring(len - 1);
    }

    public Rectangle getBarcodeSize() {
        float fontX = 0.0f;
        float fontY = 0.0f;
        String text = this.code;
        if (this.generateChecksum && this.checksumText) {
            text = BarcodeCodabar.calculateChecksum(this.code);
        }
        if (!this.startStopText) {
            text = text.substring(1, text.length() - 1);
        }
        if (this.font != null) {
            fontY = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            fontX = this.font.getWidthPoint(text, this.size);
        }
        text = this.code;
        if (this.generateChecksum) {
            text = BarcodeCodabar.calculateChecksum(this.code);
        }
        byte[] bars = BarcodeCodabar.getBarsCodabar(text);
        int wide = 0;
        int k = 0;
        while (k < bars.length) {
            wide += bars[k];
            ++k;
        }
        int narrow = bars.length - wide;
        float fullWidth = this.x * ((float)narrow + (float)wide * this.n);
        fullWidth = Math.max(fullWidth, fontX);
        float fullHeight = this.barHeight + fontY;
        return new Rectangle(fullWidth, fullHeight);
    }

    public Rectangle placeBarcode(PdfContentByte cb, Color barColor, Color textColor) {
        String fullCode = this.code;
        if (this.generateChecksum && this.checksumText) {
            fullCode = BarcodeCodabar.calculateChecksum(this.code);
        }
        if (!this.startStopText) {
            fullCode = fullCode.substring(1, fullCode.length() - 1);
        }
        float fontX = 0.0f;
        if (this.font != null) {
            fontX = this.font.getWidthPoint(fullCode, this.size);
        }
        byte[] bars = BarcodeCodabar.getBarsCodabar(this.generateChecksum ? BarcodeCodabar.calculateChecksum(this.code) : this.code);
        int wide = 0;
        int k = 0;
        while (k < bars.length) {
            wide += bars[k];
            ++k;
        }
        int narrow = bars.length - wide;
        float fullWidth = this.x * ((float)narrow + (float)wide * this.n);
        float barStartX = 0.0f;
        float textStartX = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (fontX > fullWidth) {
                    barStartX = fontX - fullWidth;
                    break;
                }
                textStartX = fullWidth - fontX;
                break;
            }
            default: {
                if (fontX > fullWidth) {
                    barStartX = (fontX - fullWidth) / 2.0f;
                    break;
                }
                textStartX = (fullWidth - fontX) / 2.0f;
            }
        }
        float barStartY = 0.0f;
        float textStartY = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                textStartY = this.barHeight - this.baseline;
            } else {
                textStartY = -this.font.getFontDescriptor(3, this.size);
                barStartY = textStartY + this.baseline;
            }
        }
        boolean print = true;
        if (barColor != null) {
            cb.setColorFill(barColor);
        }
        int k2 = 0;
        while (k2 < bars.length) {
            float w;
            float f = w = bars[k2] == 0 ? this.x : this.x * this.n;
            if (print) {
                cb.rectangle(barStartX, barStartY, w - this.inkSpreading, this.barHeight);
            }
            print = !print;
            barStartX += w;
            ++k2;
        }
        cb.fill();
        if (this.font != null) {
            if (textColor != null) {
                cb.setColorFill(textColor);
            }
            cb.beginText();
            cb.setFontAndSize(this.font, this.size);
            cb.setTextMatrix(textStartX, textStartY);
            cb.showText(fullCode);
            cb.endText();
        }
        return this.getBarcodeSize();
    }

    public Image createAwtImage(Color foreground, Color background) {
        int f = foreground.getRGB();
        int g = background.getRGB();
        Canvas canvas = new Canvas();
        String fullCode = this.code;
        if (this.generateChecksum && this.checksumText) {
            fullCode = BarcodeCodabar.calculateChecksum(this.code);
        }
        if (!this.startStopText) {
            fullCode = fullCode.substring(1, fullCode.length() - 1);
        }
        byte[] bars = BarcodeCodabar.getBarsCodabar(this.generateChecksum ? BarcodeCodabar.calculateChecksum(this.code) : this.code);
        int wide = 0;
        int k = 0;
        while (k < bars.length) {
            wide += bars[k];
            ++k;
        }
        int narrow = bars.length - wide;
        int fullWidth = narrow + wide * (int)this.n;
        boolean print = true;
        int ptr = 0;
        int height = (int)this.barHeight;
        int[] pix = new int[fullWidth * height];
        int k2 = 0;
        while (k2 < bars.length) {
            int w = bars[k2] == 0 ? 1 : (int)this.n;
            int c = g;
            if (print) {
                c = f;
            }
            print = !print;
            int j = 0;
            while (j < w) {
                pix[ptr++] = c;
                ++j;
            }
            ++k2;
        }
        k2 = fullWidth;
        while (k2 < pix.length) {
            System.arraycopy(pix, 0, pix, k2, fullWidth);
            k2 += fullWidth;
        }
        Image img = canvas.createImage(new MemoryImageSource(fullWidth, height, pix, 0, fullWidth));
        return img;
    }
}

